/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import java.util.List;
import org.elasticsearch.compute.aggregation.GroupingAggregatorEvaluationContext;
import org.elasticsearch.compute.aggregation.GroupingAggregatorFunction;
import org.elasticsearch.compute.aggregation.IntArrayState;
import org.elasticsearch.compute.aggregation.IntermediateStateDesc;
import org.elasticsearch.compute.aggregation.MinIntAggregator;
import org.elasticsearch.compute.aggregation.SeenGroupIds;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.BooleanVector;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.IntArrayBlock;
import org.elasticsearch.compute.data.IntBigArrayBlock;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;

public final class MinIntGroupingAggregatorFunction
implements GroupingAggregatorFunction {
    private static final List<IntermediateStateDesc> INTERMEDIATE_STATE_DESC = List.of(new IntermediateStateDesc("min", ElementType.INT), new IntermediateStateDesc("seen", ElementType.BOOLEAN));
    private final IntArrayState state;
    private final List<Integer> channels;
    private final DriverContext driverContext;

    public MinIntGroupingAggregatorFunction(List<Integer> channels, IntArrayState state, DriverContext driverContext) {
        this.channels = channels;
        this.state = state;
        this.driverContext = driverContext;
    }

    public static MinIntGroupingAggregatorFunction create(List<Integer> channels, DriverContext driverContext) {
        return new MinIntGroupingAggregatorFunction(channels, new IntArrayState(driverContext.bigArrays(), MinIntAggregator.init()), driverContext);
    }

    public static List<IntermediateStateDesc> intermediateStateDesc() {
        return INTERMEDIATE_STATE_DESC;
    }

    @Override
    public int intermediateBlockCount() {
        return INTERMEDIATE_STATE_DESC.size();
    }

    @Override
    public GroupingAggregatorFunction.AddInput prepareProcessRawInputPage(SeenGroupIds seenGroupIds, Page page) {
        final IntBlock vBlock = (IntBlock)page.getBlock(this.channels.get(0));
        final IntVector vVector = vBlock.asVector();
        if (vVector == null) {
            this.maybeEnableGroupIdTracking(seenGroupIds, vBlock);
            return new GroupingAggregatorFunction.AddInput(){

                @Override
                public void add(int positionOffset, IntArrayBlock groupIds) {
                    MinIntGroupingAggregatorFunction.this.addRawInput(positionOffset, groupIds, vBlock);
                }

                @Override
                public void add(int positionOffset, IntBigArrayBlock groupIds) {
                    MinIntGroupingAggregatorFunction.this.addRawInput(positionOffset, groupIds, vBlock);
                }

                @Override
                public void add(int positionOffset, IntVector groupIds) {
                    MinIntGroupingAggregatorFunction.this.addRawInput(positionOffset, groupIds, vBlock);
                }

                public void close() {
                }
            };
        }
        return new GroupingAggregatorFunction.AddInput(){

            @Override
            public void add(int positionOffset, IntArrayBlock groupIds) {
                MinIntGroupingAggregatorFunction.this.addRawInput(positionOffset, groupIds, vVector);
            }

            @Override
            public void add(int positionOffset, IntBigArrayBlock groupIds) {
                MinIntGroupingAggregatorFunction.this.addRawInput(positionOffset, groupIds, vVector);
            }

            @Override
            public void add(int positionOffset, IntVector groupIds) {
                MinIntGroupingAggregatorFunction.this.addRawInput(positionOffset, groupIds, vVector);
            }

            public void close() {
            }
        };
    }

    private void addRawInput(int positionOffset, IntArrayBlock groups, IntBlock vBlock) {
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            int valuesPosition;
            if (groups.isNull(groupPosition) || vBlock.isNull(valuesPosition = groupPosition + positionOffset)) continue;
            int groupStart = groups.getFirstValueIndex(groupPosition);
            int groupEnd = groupStart + groups.getValueCount(groupPosition);
            for (int g = groupStart; g < groupEnd; ++g) {
                int groupId = groups.getInt(g);
                int vStart = vBlock.getFirstValueIndex(valuesPosition);
                int vEnd = vStart + vBlock.getValueCount(valuesPosition);
                for (int vOffset = vStart; vOffset < vEnd; ++vOffset) {
                    int vValue = vBlock.getInt(vOffset);
                    this.state.set(groupId, MinIntAggregator.combine(this.state.getOrDefault(groupId), vValue));
                }
            }
        }
    }

    private void addRawInput(int positionOffset, IntArrayBlock groups, IntVector vVector) {
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            if (groups.isNull(groupPosition)) continue;
            int valuesPosition = groupPosition + positionOffset;
            int groupStart = groups.getFirstValueIndex(groupPosition);
            int groupEnd = groupStart + groups.getValueCount(groupPosition);
            for (int g = groupStart; g < groupEnd; ++g) {
                int groupId = groups.getInt(g);
                int vValue = vVector.getInt(valuesPosition);
                this.state.set(groupId, MinIntAggregator.combine(this.state.getOrDefault(groupId), vValue));
            }
        }
    }

    @Override
    public void addIntermediateInput(int positionOffset, IntArrayBlock groups, Page page) {
        this.state.enableGroupIdTracking(new SeenGroupIds.Empty());
        assert (this.channels.size() == this.intermediateBlockCount());
        Object minUncast = page.getBlock(this.channels.get(0));
        if (minUncast.areAllValuesNull()) {
            return;
        }
        IntVector min = ((IntBlock)minUncast).asVector();
        Object seenUncast = page.getBlock(this.channels.get(1));
        if (seenUncast.areAllValuesNull()) {
            return;
        }
        BooleanVector seen = ((BooleanBlock)seenUncast).asVector();
        assert (min.getPositionCount() == seen.getPositionCount());
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            if (groups.isNull(groupPosition)) continue;
            int groupStart = groups.getFirstValueIndex(groupPosition);
            int groupEnd = groupStart + groups.getValueCount(groupPosition);
            for (int g = groupStart; g < groupEnd; ++g) {
                int groupId = groups.getInt(g);
                int valuesPosition = groupPosition + positionOffset;
                if (!seen.getBoolean(valuesPosition)) continue;
                this.state.set(groupId, MinIntAggregator.combine(this.state.getOrDefault(groupId), min.getInt(valuesPosition)));
            }
        }
    }

    private void addRawInput(int positionOffset, IntBigArrayBlock groups, IntBlock vBlock) {
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            int valuesPosition;
            if (groups.isNull(groupPosition) || vBlock.isNull(valuesPosition = groupPosition + positionOffset)) continue;
            int groupStart = groups.getFirstValueIndex(groupPosition);
            int groupEnd = groupStart + groups.getValueCount(groupPosition);
            for (int g = groupStart; g < groupEnd; ++g) {
                int groupId = groups.getInt(g);
                int vStart = vBlock.getFirstValueIndex(valuesPosition);
                int vEnd = vStart + vBlock.getValueCount(valuesPosition);
                for (int vOffset = vStart; vOffset < vEnd; ++vOffset) {
                    int vValue = vBlock.getInt(vOffset);
                    this.state.set(groupId, MinIntAggregator.combine(this.state.getOrDefault(groupId), vValue));
                }
            }
        }
    }

    private void addRawInput(int positionOffset, IntBigArrayBlock groups, IntVector vVector) {
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            if (groups.isNull(groupPosition)) continue;
            int valuesPosition = groupPosition + positionOffset;
            int groupStart = groups.getFirstValueIndex(groupPosition);
            int groupEnd = groupStart + groups.getValueCount(groupPosition);
            for (int g = groupStart; g < groupEnd; ++g) {
                int groupId = groups.getInt(g);
                int vValue = vVector.getInt(valuesPosition);
                this.state.set(groupId, MinIntAggregator.combine(this.state.getOrDefault(groupId), vValue));
            }
        }
    }

    @Override
    public void addIntermediateInput(int positionOffset, IntBigArrayBlock groups, Page page) {
        this.state.enableGroupIdTracking(new SeenGroupIds.Empty());
        assert (this.channels.size() == this.intermediateBlockCount());
        Object minUncast = page.getBlock(this.channels.get(0));
        if (minUncast.areAllValuesNull()) {
            return;
        }
        IntVector min = ((IntBlock)minUncast).asVector();
        Object seenUncast = page.getBlock(this.channels.get(1));
        if (seenUncast.areAllValuesNull()) {
            return;
        }
        BooleanVector seen = ((BooleanBlock)seenUncast).asVector();
        assert (min.getPositionCount() == seen.getPositionCount());
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            if (groups.isNull(groupPosition)) continue;
            int groupStart = groups.getFirstValueIndex(groupPosition);
            int groupEnd = groupStart + groups.getValueCount(groupPosition);
            for (int g = groupStart; g < groupEnd; ++g) {
                int groupId = groups.getInt(g);
                int valuesPosition = groupPosition + positionOffset;
                if (!seen.getBoolean(valuesPosition)) continue;
                this.state.set(groupId, MinIntAggregator.combine(this.state.getOrDefault(groupId), min.getInt(valuesPosition)));
            }
        }
    }

    private void addRawInput(int positionOffset, IntVector groups, IntBlock vBlock) {
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            int valuesPosition = groupPosition + positionOffset;
            if (vBlock.isNull(valuesPosition)) continue;
            int groupId = groups.getInt(groupPosition);
            int vStart = vBlock.getFirstValueIndex(valuesPosition);
            int vEnd = vStart + vBlock.getValueCount(valuesPosition);
            for (int vOffset = vStart; vOffset < vEnd; ++vOffset) {
                int vValue = vBlock.getInt(vOffset);
                this.state.set(groupId, MinIntAggregator.combine(this.state.getOrDefault(groupId), vValue));
            }
        }
    }

    private void addRawInput(int positionOffset, IntVector groups, IntVector vVector) {
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            int valuesPosition = groupPosition + positionOffset;
            int groupId = groups.getInt(groupPosition);
            int vValue = vVector.getInt(valuesPosition);
            this.state.set(groupId, MinIntAggregator.combine(this.state.getOrDefault(groupId), vValue));
        }
    }

    @Override
    public void addIntermediateInput(int positionOffset, IntVector groups, Page page) {
        this.state.enableGroupIdTracking(new SeenGroupIds.Empty());
        assert (this.channels.size() == this.intermediateBlockCount());
        Object minUncast = page.getBlock(this.channels.get(0));
        if (minUncast.areAllValuesNull()) {
            return;
        }
        IntVector min = ((IntBlock)minUncast).asVector();
        Object seenUncast = page.getBlock(this.channels.get(1));
        if (seenUncast.areAllValuesNull()) {
            return;
        }
        BooleanVector seen = ((BooleanBlock)seenUncast).asVector();
        assert (min.getPositionCount() == seen.getPositionCount());
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            int groupId = groups.getInt(groupPosition);
            int valuesPosition = groupPosition + positionOffset;
            if (!seen.getBoolean(valuesPosition)) continue;
            this.state.set(groupId, MinIntAggregator.combine(this.state.getOrDefault(groupId), min.getInt(valuesPosition)));
        }
    }

    private void maybeEnableGroupIdTracking(SeenGroupIds seenGroupIds, IntBlock vBlock) {
        if (vBlock.mayHaveNulls()) {
            this.state.enableGroupIdTracking(seenGroupIds);
        }
    }

    @Override
    public void selectedMayContainUnseenGroups(SeenGroupIds seenGroupIds) {
        this.state.enableGroupIdTracking(seenGroupIds);
    }

    @Override
    public void evaluateIntermediate(Block[] blocks, int offset, IntVector selected) {
        this.state.toIntermediate(blocks, offset, selected, this.driverContext);
    }

    @Override
    public void evaluateFinal(Block[] blocks, int offset, IntVector selected, GroupingAggregatorEvaluationContext ctx) {
        blocks[offset] = this.state.toValuesBlock(selected, ctx.driverContext());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("[");
        sb.append("channels=").append(this.channels);
        sb.append("]");
        return sb.toString();
    }

    public void close() {
        this.state.close();
    }
}

