/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import org.apache.lucene.util.BytesRef;
import org.elasticsearch.compute.aggregation.GroupingAggregatorEvaluationContext;
import org.elasticsearch.compute.aggregation.QuantileStates;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.operator.DriverContext;

class MedianAbsoluteDeviationDoubleAggregator {
    MedianAbsoluteDeviationDoubleAggregator() {
    }

    public static QuantileStates.SingleState initSingle(DriverContext driverContext) {
        return new QuantileStates.SingleState(driverContext.breaker(), 50.0);
    }

    public static void combine(QuantileStates.SingleState current, double v) {
        current.add(v);
    }

    public static void combineIntermediate(QuantileStates.SingleState state, BytesRef inValue) {
        state.add(inValue);
    }

    public static Block evaluateFinal(QuantileStates.SingleState state, DriverContext driverContext) {
        return state.evaluateMedianAbsoluteDeviation(driverContext);
    }

    public static QuantileStates.GroupingState initGrouping(DriverContext driverContext) {
        return new QuantileStates.GroupingState(driverContext.breaker(), driverContext.bigArrays(), 50.0);
    }

    public static void combine(QuantileStates.GroupingState state, int groupId, double v) {
        state.add(groupId, v);
    }

    public static void combineIntermediate(QuantileStates.GroupingState state, int groupId, BytesRef inValue) {
        state.add(groupId, inValue);
    }

    public static Block evaluateFinal(QuantileStates.GroupingState state, IntVector selected, GroupingAggregatorEvaluationContext ctx) {
        return state.evaluateMedianAbsoluteDeviation(selected, ctx.driverContext());
    }
}

