/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.core.expression;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.lucene.BytesRefs;
import org.elasticsearch.xpack.esql.core.expression.EntryExpression;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Literal;
import org.elasticsearch.xpack.esql.core.expression.Nullability;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.core.util.PlanStreamInput;

public class MapExpression
extends Expression {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "MapExpression", MapExpression::readFrom);
    private final List<EntryExpression> entryExpressions;
    private final Map<Expression, Expression> map;
    private final Map<String, Expression> keyFoldedMap;

    public MapExpression(Source source, List<Expression> entries) {
        super(source, entries);
        int entryCount = entries.size() / 2;
        this.entryExpressions = new ArrayList<EntryExpression>(entryCount);
        this.map = new LinkedHashMap<Expression, Expression>(entryCount);
        this.keyFoldedMap = new LinkedHashMap<String, Expression>(entryCount);
        for (int i = 0; i < entryCount; ++i) {
            Expression key = entries.get(i * 2);
            Expression value = entries.get(i * 2 + 1);
            this.entryExpressions.add(new EntryExpression(key.source(), key, value));
            this.map.put(key, value);
            if (!(key instanceof Literal)) continue;
            Literal l = (Literal)key;
            this.keyFoldedMap.put(BytesRefs.toString((Object)l.value()), value);
        }
    }

    private static MapExpression readFrom(StreamInput in) throws IOException {
        return new MapExpression(Source.readFrom((StreamInput)((PlanStreamInput)in)), in.readNamedWriteableCollectionAsList(Expression.class));
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.source().writeTo(out);
        out.writeNamedWriteableCollection(this.children());
    }

    public String getWriteableName() {
        return MapExpression.ENTRY.name;
    }

    @Override
    public MapExpression replaceChildren(List<Expression> newChildren) {
        return new MapExpression(this.source(), newChildren);
    }

    @Override
    protected NodeInfo<MapExpression> info() {
        return NodeInfo.create(this, MapExpression::new, this.children());
    }

    public List<EntryExpression> entryExpressions() {
        return this.entryExpressions;
    }

    public Map<Expression, Expression> map() {
        return this.map;
    }

    public Map<String, Expression> keyFoldedMap() {
        return this.keyFoldedMap;
    }

    @Override
    public Nullability nullable() {
        return Nullability.FALSE;
    }

    @Override
    public DataType dataType() {
        return DataType.UNSUPPORTED;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.entryExpressions);
    }

    public Expression get(Object key) {
        if (key instanceof Expression) {
            return this.map.get(key);
        }
        return this.keyFoldedMap.containsKey(key) ? this.keyFoldedMap.get(key) : this.keyFoldedMap.get(this.foldKey(key));
    }

    public boolean containsKey(Object key) {
        return this.keyFoldedMap.containsKey(key) || this.keyFoldedMap.containsKey(this.foldKey(key));
    }

    private BytesRef foldKey(Object key) {
        return new BytesRef((CharSequence)key.toString());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MapExpression other = (MapExpression)obj;
        return Objects.equals(this.entryExpressions, other.entryExpressions);
    }

    @Override
    public String toString() {
        String str = this.entryExpressions.stream().map(String::valueOf).collect(Collectors.joining(", "));
        return "{ " + str + " }";
    }
}

