/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.stats;

import org.apache.lucene.util.BytesRef;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.blockloader.BlockLoaderFunctionConfig;
import org.elasticsearch.xpack.esql.core.expression.FieldAttribute;

public interface SearchStats {
    public static final SearchStats EMPTY = new EmptySearchStats();

    public boolean exists(FieldAttribute.FieldName var1);

    public boolean isIndexed(FieldAttribute.FieldName var1);

    public boolean hasDocValues(FieldAttribute.FieldName var1);

    public boolean hasExactSubfield(FieldAttribute.FieldName var1);

    public long count();

    public long count(FieldAttribute.FieldName var1);

    public long count(FieldAttribute.FieldName var1, BytesRef var2);

    public Object min(FieldAttribute.FieldName var1);

    public Object max(FieldAttribute.FieldName var1);

    public boolean isSingleValue(FieldAttribute.FieldName var1);

    public boolean canUseEqualityOnSyntheticSourceDelegate(FieldAttribute.FieldName var1, String var2);

    public boolean supportsLoaderConfig(FieldAttribute.FieldName var1, BlockLoaderFunctionConfig var2, MappedFieldType.FieldExtractPreference var3);

    default public String constantValue(FieldAttribute.FieldName name) {
        return null;
    }

    default public MappedFieldType fieldType(FieldAttribute.FieldName name) {
        return null;
    }

    public record EmptySearchStats() implements SearchStats
    {
        @Override
        public boolean exists(FieldAttribute.FieldName field) {
            return false;
        }

        @Override
        public boolean isIndexed(FieldAttribute.FieldName field) {
            return false;
        }

        @Override
        public boolean hasDocValues(FieldAttribute.FieldName field) {
            return false;
        }

        @Override
        public boolean hasExactSubfield(FieldAttribute.FieldName field) {
            return false;
        }

        @Override
        public boolean supportsLoaderConfig(FieldAttribute.FieldName name, BlockLoaderFunctionConfig config, MappedFieldType.FieldExtractPreference preference) {
            return false;
        }

        @Override
        public long count() {
            return 0L;
        }

        @Override
        public long count(FieldAttribute.FieldName field) {
            return 0L;
        }

        @Override
        public long count(FieldAttribute.FieldName field, BytesRef value) {
            return 0L;
        }

        @Override
        public Object min(FieldAttribute.FieldName field) {
            return null;
        }

        @Override
        public Object max(FieldAttribute.FieldName field) {
            return null;
        }

        @Override
        public boolean isSingleValue(FieldAttribute.FieldName field) {
            return true;
        }

        @Override
        public boolean canUseEqualityOnSyntheticSourceDelegate(FieldAttribute.FieldName name, String value) {
            return false;
        }
    }

    public static abstract class UnsupportedSearchStats
    implements SearchStats {
        @Override
        public boolean exists(FieldAttribute.FieldName field) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isIndexed(FieldAttribute.FieldName field) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasDocValues(FieldAttribute.FieldName field) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasExactSubfield(FieldAttribute.FieldName field) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean supportsLoaderConfig(FieldAttribute.FieldName name, BlockLoaderFunctionConfig config, MappedFieldType.FieldExtractPreference preference) {
            return false;
        }

        @Override
        public long count() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long count(FieldAttribute.FieldName field) {
            throw new UnsupportedOperationException();
        }

        @Override
        public long count(FieldAttribute.FieldName field, BytesRef value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object min(FieldAttribute.FieldName field) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object max(FieldAttribute.FieldName field) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isSingleValue(FieldAttribute.FieldName field) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean canUseEqualityOnSyntheticSourceDelegate(FieldAttribute.FieldName name, String value) {
            throw new UnsupportedOperationException();
        }
    }
}

