/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.session;

import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Function;
import org.elasticsearch.Build;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesFailure;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesIndexResponse;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesRequest;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesResponse;
import org.elasticsearch.action.fieldcaps.IndexFieldCapabilities;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.mapper.TimeSeriesParams;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.esql.action.EsqlResolveFieldsAction;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.core.type.DateEsField;
import org.elasticsearch.xpack.esql.core.type.EsField;
import org.elasticsearch.xpack.esql.core.type.InvalidMappedField;
import org.elasticsearch.xpack.esql.core.type.KeywordEsField;
import org.elasticsearch.xpack.esql.core.type.TextEsField;
import org.elasticsearch.xpack.esql.core.type.UnsupportedEsField;
import org.elasticsearch.xpack.esql.index.EsIndex;
import org.elasticsearch.xpack.esql.index.IndexResolution;
import org.elasticsearch.xpack.esql.session.EsqlCCSUtils;
import org.elasticsearch.xpack.esql.session.Versioned;
import org.elasticsearch.xpack.esql.type.EsqlDataTypeRegistry;

public class IndexResolver {
    private static Logger LOGGER = LogManager.getLogger(IndexResolver.class);
    public static final Set<String> ALL_FIELDS = Set.of("*");
    public static final Set<String> INDEX_METADATA_FIELD = Set.of("_index");
    public static final String UNMAPPED = "unmapped";
    public static final IndicesOptions FIELD_CAPS_INDICES_OPTIONS = IndicesOptions.builder().concreteTargetOptions(IndicesOptions.ConcreteTargetOptions.ALLOW_UNAVAILABLE_TARGETS).wildcardOptions(IndicesOptions.WildcardOptions.builder().matchOpen(true).matchClosed(false).includeHidden(false).allowEmptyExpressions(true).resolveAliases(true)).gatekeeperOptions(IndicesOptions.GatekeeperOptions.builder().ignoreThrottled(true).allowClosedIndices(true).allowAliasToMultipleIndices(true)).build();
    private final Client client;

    public IndexResolver(Client client) {
        this.client = client;
    }

    public void resolveIndices(String indexWildcard, Set<String> fieldNames, QueryBuilder requestFilter, boolean includeAllDimensions, boolean useAggregateMetricDoubleWhenNotSupported, boolean useDenseVectorWhenNotSupported, ActionListener<IndexResolution> listener) {
        this.resolveIndicesVersioned(indexWildcard, fieldNames, requestFilter, includeAllDimensions, useAggregateMetricDoubleWhenNotSupported, useDenseVectorWhenNotSupported, (ActionListener<Versioned<IndexResolution>>)listener.map(Versioned::inner));
    }

    public void resolveIndicesVersioned(String indexWildcard, Set<String> fieldNames, QueryBuilder requestFilter, boolean includeAllDimensions, boolean useAggregateMetricDoubleWhenNotSupported, boolean useDenseVectorWhenNotSupported, ActionListener<Versioned<IndexResolution>> listener) {
        this.client.execute(EsqlResolveFieldsAction.TYPE, (ActionRequest)IndexResolver.createFieldCapsRequest(indexWildcard, fieldNames, requestFilter, includeAllDimensions), listener.delegateFailureAndWrap((l, response) -> {
            FieldsInfo info = new FieldsInfo(response.caps(), response.caps().minTransportVersion(), Build.current().isSnapshot(), useAggregateMetricDoubleWhenNotSupported, useDenseVectorWhenNotSupported);
            LOGGER.debug("minimum transport version {} {}", new Object[]{response.caps().minTransportVersion(), info.effectiveMinTransportVersion()});
            l.onResponse(new Versioned<IndexResolution>(IndexResolver.mergedMappings(indexWildcard, info), info.effectiveMinTransportVersion()));
        }));
    }

    public static IndexResolution mergedMappings(String indexPattern, FieldsInfo fieldsInfo) {
        assert (ThreadPool.assertCurrentThreadPool((String[])new String[]{"search_coordination"}));
        int numberOfIndices = fieldsInfo.caps.getIndexResponses().size();
        if (numberOfIndices == 0) {
            return IndexResolution.notFound(indexPattern);
        }
        CollectedFieldCaps collectedFieldCaps = IndexResolver.collectFieldCaps(fieldsInfo.caps);
        Map<String, IndexFieldCapabilitiesWithSourceHash> fieldsCaps = collectedFieldCaps.fieldsCaps;
        Map<String, Integer> indexMappingHashDuplicates = collectedFieldCaps.indexMappingHashDuplicates;
        Object[] names = fieldsCaps.keySet().toArray(new String[0]);
        Arrays.sort(names);
        HashMap<String, EsField> rootFields = new HashMap<String, EsField>();
        HashSet<String> partiallyUnmappedFields = new HashSet<String>();
        for (Object name : names) {
            boolean isPartiallyUnmapped;
            int nextDot;
            Map<String, Object> fields = rootFields;
            Object fullName = name;
            boolean isAlias = false;
            UnsupportedEsField firstUnsupportedParent = null;
            while ((nextDot = ((String)name).indexOf(46)) >= 0) {
                String parent = ((String)name).substring(0, nextDot);
                EsField obj = (EsField)fields.get(parent);
                if (obj == null) {
                    obj = new EsField(parent, DataType.OBJECT, new HashMap(), false, true, EsField.TimeSeriesFieldType.NONE);
                    isAlias = true;
                    fields.put(parent, obj);
                } else if (firstUnsupportedParent == null && obj instanceof UnsupportedEsField) {
                    UnsupportedEsField unsupportedParent;
                    firstUnsupportedParent = unsupportedParent = (UnsupportedEsField)obj;
                }
                fields = obj.getProperties();
                name = ((String)name).substring(nextDot + 1);
            }
            IndexFieldCapabilitiesWithSourceHash fieldCap = fieldsCaps.get(fullName);
            List<IndexFieldCapabilities> fcs = fieldCap.fieldCapabilities;
            UnsupportedEsField field = firstUnsupportedParent == null ? IndexResolver.createField(fieldsInfo, (String)name, (String)fullName, fcs, isAlias) : new UnsupportedEsField((String)fullName, firstUnsupportedParent.getOriginalTypes(), firstUnsupportedParent.getName(), new HashMap());
            fields.put((String)name, (EsField)field);
            boolean bl = isPartiallyUnmapped = fcs.size() + indexMappingHashDuplicates.getOrDefault(fieldCap.indexMappingHash, 0) < numberOfIndices;
            if (!isPartiallyUnmapped) continue;
            partiallyUnmappedFields.add((String)fullName);
        }
        Map concreteIndices = Maps.newMapWithExpectedSize((int)fieldsInfo.caps.getIndexResponses().size());
        for (FieldCapabilitiesIndexResponse ir : fieldsInfo.caps.getIndexResponses()) {
            concreteIndices.put(ir.getIndexName(), ir.getIndexMode());
        }
        boolean allEmpty = true;
        for (FieldCapabilitiesIndexResponse ir : fieldsInfo.caps.getIndexResponses()) {
            allEmpty &= ir.get().isEmpty();
        }
        EsIndex index = new EsIndex(indexPattern, rootFields, allEmpty ? Map.of() : concreteIndices, partiallyUnmappedFields);
        Map<String, List<FieldCapabilitiesFailure>> failures = EsqlCCSUtils.groupFailuresPerCluster(fieldsInfo.caps.getFailures());
        return IndexResolution.valid(index, concreteIndices.keySet(), failures);
    }

    private static CollectedFieldCaps collectFieldCaps(FieldCapabilitiesResponse fieldCapsResponse) {
        HashMap<String, Integer> indexMappingHashToDuplicateCount = new HashMap<String, Integer>();
        HashMap<String, IndexFieldCapabilitiesWithSourceHash> fieldsCaps = new HashMap<String, IndexFieldCapabilitiesWithSourceHash>();
        for (FieldCapabilitiesIndexResponse response : fieldCapsResponse.getIndexResponses()) {
            if (indexMappingHashToDuplicateCount.compute(response.getIndexMappingHash(), (k, v) -> v == null ? 1 : v + 1) > 1) continue;
            for (IndexFieldCapabilities fc : response.get().values()) {
                if (fc.isMetadatafield()) continue;
                List<IndexFieldCapabilities> all = fieldsCaps.computeIfAbsent((String)fc.name(), (Function<String, IndexFieldCapabilitiesWithSourceHash>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$collectFieldCaps$2(org.elasticsearch.action.fieldcaps.FieldCapabilitiesIndexResponse java.lang.String ), (Ljava/lang/String;)Lorg/elasticsearch/xpack/esql/session/IndexResolver$IndexFieldCapabilitiesWithSourceHash;)((FieldCapabilitiesIndexResponse)response)).fieldCapabilities;
                all.add(fc);
            }
        }
        Iterator iterator = indexMappingHashToDuplicateCount.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry next = iterator.next();
            if ((Integer)next.getValue() <= 1) {
                iterator.remove();
                continue;
            }
            next.setValue((Integer)next.getValue() - 1);
        }
        return new CollectedFieldCaps(fieldsCaps, indexMappingHashToDuplicateCount);
    }

    private static EsField createField(FieldsInfo fieldsInfo, String name, String fullName, List<IndexFieldCapabilities> fcs, boolean isAlias) {
        boolean typeSupported;
        DataType type;
        List<IndexFieldCapabilities> rest;
        IndexFieldCapabilities first;
        block20: {
            boolean bl;
            block19: {
                block18: {
                    first = fcs.get(0);
                    rest = fcs.subList(1, fcs.size());
                    type = EsqlDataTypeRegistry.INSTANCE.fromEs(first.type(), first.metricType());
                    if (type.supportedVersion().supportedOn(fieldsInfo.effectiveMinTransportVersion(), fieldsInfo.currentBuildIsSnapshot)) break block18;
                    switch (type) {
                        case AGGREGATE_METRIC_DOUBLE: {
                            if (fieldsInfo.useAggregateMetricDoubleWhenNotSupported) {
                                break;
                            }
                            break block19;
                        }
                        case DENSE_VECTOR: {
                            if (fieldsInfo.useDenseVectorWhenNotSupported) {
                                break;
                            }
                            break block19;
                        }
                        default: {
                            break block19;
                        }
                    }
                }
                bl = true;
                break block20;
            }
            bl = typeSupported = false;
        }
        if (!typeSupported) {
            type = DataType.UNSUPPORTED;
        }
        boolean aggregatable = first.isAggregatable();
        EsField.TimeSeriesFieldType timeSeriesFieldType = EsField.TimeSeriesFieldType.fromIndexFieldCapabilities((IndexFieldCapabilities)first);
        if (!rest.isEmpty()) {
            for (IndexFieldCapabilities fc : rest) {
                if (first.metricType() != fc.metricType()) {
                    return IndexResolver.conflictingMetricTypes(name, fullName, fieldsInfo.caps);
                }
                try {
                    timeSeriesFieldType = timeSeriesFieldType.merge(EsField.TimeSeriesFieldType.fromIndexFieldCapabilities((IndexFieldCapabilities)fc));
                }
                catch (IllegalArgumentException e) {
                    return new InvalidMappedField(name, e.getMessage());
                }
            }
            for (IndexFieldCapabilities fc : rest) {
                if (type == EsqlDataTypeRegistry.INSTANCE.fromEs(fc.type(), fc.metricType())) continue;
                return IndexResolver.conflictingTypes(name, fullName, fieldsInfo.caps);
            }
            for (IndexFieldCapabilities fc : rest) {
                aggregatable &= fc.isAggregatable();
            }
        }
        if (type == DataType.TEXT) {
            return new TextEsField(name, new HashMap(), false, isAlias, timeSeriesFieldType);
        }
        if (type == DataType.KEYWORD) {
            int length = Short.MAX_VALUE;
            boolean normalized = false;
            return new KeywordEsField(name, new HashMap(), aggregatable, length, normalized, isAlias, timeSeriesFieldType);
        }
        if (type == DataType.DATETIME) {
            return DateEsField.dateEsField((String)name, new HashMap(), (boolean)aggregatable, (EsField.TimeSeriesFieldType)timeSeriesFieldType);
        }
        if (type == DataType.UNSUPPORTED) {
            return IndexResolver.unsupported(name, first);
        }
        return new EsField(name, type, new HashMap(), aggregatable, isAlias, timeSeriesFieldType);
    }

    private static UnsupportedEsField unsupported(String name, IndexFieldCapabilities fc) {
        String originalType = fc.metricType() == TimeSeriesParams.MetricType.COUNTER ? "counter" : fc.type();
        return new UnsupportedEsField(name, List.of(originalType));
    }

    private static EsField conflictingTypes(String name, String fullName, FieldCapabilitiesResponse fieldCapsResponse) {
        TreeMap<String, Set> typesToIndices = new TreeMap<String, Set>();
        for (FieldCapabilitiesIndexResponse ir : fieldCapsResponse.getIndexResponses()) {
            IndexFieldCapabilities fc = (IndexFieldCapabilities)ir.get().get(fullName);
            if (fc == null) continue;
            DataType type = EsqlDataTypeRegistry.INSTANCE.fromEs(fc.type(), fc.metricType());
            if (type == DataType.UNSUPPORTED) {
                return IndexResolver.unsupported(name, fc);
            }
            typesToIndices.computeIfAbsent(type.typeName(), _key -> new TreeSet()).add(ir.getIndexName());
        }
        return new InvalidMappedField(name, typesToIndices);
    }

    private static EsField conflictingMetricTypes(String name, String fullName, FieldCapabilitiesResponse fieldCapsResponse) {
        TreeSet<String> indices = new TreeSet<String>();
        for (FieldCapabilitiesIndexResponse ir : fieldCapsResponse.getIndexResponses()) {
            IndexFieldCapabilities fc = (IndexFieldCapabilities)ir.get().get(fullName);
            if (fc == null) continue;
            indices.add(ir.getIndexName());
        }
        return new InvalidMappedField(name, "mapped as different metric types in indices: " + String.valueOf(indices));
    }

    private static FieldCapabilitiesRequest createFieldCapsRequest(String index, Set<String> fieldNames, QueryBuilder requestFilter, boolean includeAllDimensions) {
        FieldCapabilitiesRequest req = new FieldCapabilitiesRequest().indices(Strings.commaDelimitedListToStringArray((String)index));
        req.fields((String[])fieldNames.toArray(String[]::new));
        req.includeUnmapped(true);
        req.indexFilter(requestFilter);
        req.returnLocalAll(false);
        req.indicesOptions(FIELD_CAPS_INDICES_OPTIONS);
        if (includeAllDimensions) {
            req.filters(new String[]{"-nested", "+dimension"});
        } else {
            req.filters(new String[]{"-nested"});
        }
        req.setMergeResults(false);
        return req;
    }

    private static /* synthetic */ IndexFieldCapabilitiesWithSourceHash lambda$collectFieldCaps$2(FieldCapabilitiesIndexResponse response, String _key) {
        return new IndexFieldCapabilitiesWithSourceHash(new ArrayList<IndexFieldCapabilities>(), response.getIndexMappingHash());
    }

    public record FieldsInfo(FieldCapabilitiesResponse caps, @Nullable TransportVersion minTransportVersion, boolean currentBuildIsSnapshot, boolean useAggregateMetricDoubleWhenNotSupported, boolean useDenseVectorWhenNotSupported) {
        TransportVersion effectiveMinTransportVersion() {
            return this.minTransportVersion != null ? this.minTransportVersion : TransportVersion.minimumCompatible();
        }
    }

    private record CollectedFieldCaps(Map<String, IndexFieldCapabilitiesWithSourceHash> fieldsCaps, Map<String, Integer> indexMappingHashDuplicates) {
    }

    private record IndexFieldCapabilitiesWithSourceHash(List<IndexFieldCapabilities> fieldCapabilities, String indexMappingHash) {
    }
}

