/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plugin;

import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.elasticsearch.index.IndexMode;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.FieldAttribute;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.util.CollectionUtils;
import org.elasticsearch.xpack.esql.optimizer.LocalPhysicalOptimizerContext;
import org.elasticsearch.xpack.esql.optimizer.rules.physical.local.InsertFieldExtraction;
import org.elasticsearch.xpack.esql.optimizer.rules.physical.local.ReplaceSourceAttributes;
import org.elasticsearch.xpack.esql.plan.logical.EsRelation;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.plan.logical.Project;
import org.elasticsearch.xpack.esql.plan.logical.TopN;
import org.elasticsearch.xpack.esql.plan.physical.EsQueryExec;
import org.elasticsearch.xpack.esql.plan.physical.EstimatesRowSize;
import org.elasticsearch.xpack.esql.plan.physical.ExchangeSinkExec;
import org.elasticsearch.xpack.esql.plan.physical.ExchangeSourceExec;
import org.elasticsearch.xpack.esql.plan.physical.FragmentExec;
import org.elasticsearch.xpack.esql.plan.physical.PhysicalPlan;
import org.elasticsearch.xpack.esql.plan.physical.TopNExec;
import org.elasticsearch.xpack.esql.planner.mapper.LocalMapper;
import org.elasticsearch.xpack.esql.plugin.ReductionPlan;
import org.elasticsearch.xpack.esql.stats.SearchStats;

class LateMaterializationPlanner {
    private static final SearchStats SEARCH_STATS_TOP_N_REPLACEMENT = new SearchStats.UnsupportedSearchStats(){

        @Override
        public boolean exists(FieldAttribute.FieldName field) {
            return true;
        }

        @Override
        public boolean isIndexed(FieldAttribute.FieldName field) {
            return false;
        }

        @Override
        public Object min(FieldAttribute.FieldName field) {
            return null;
        }

        @Override
        public Object max(FieldAttribute.FieldName field) {
            return null;
        }
    };

    public static Optional<ReductionPlan> planReduceDriverTopN(Function<SearchStats, LocalPhysicalOptimizerContext> contextFactory, ExchangeSinkExec originalPlan) {
        TopN tn;
        TopN topN;
        Project p;
        Project topLevelProject;
        FragmentExec fe;
        FragmentExec fragmentExec;
        PhysicalPlan physicalPlan = originalPlan.child();
        FragmentExec fragmentExec2 = fragmentExec = physicalPlan instanceof FragmentExec ? (fe = (FragmentExec)physicalPlan) : null;
        if (fragmentExec == null) {
            return Optional.empty();
        }
        LogicalPlan logicalPlan = fragmentExec.fragment();
        Project project = topLevelProject = logicalPlan instanceof Project ? (p = (Project)logicalPlan) : null;
        if (topLevelProject == null) {
            return Optional.empty();
        }
        LogicalPlan logicalPlan2 = topLevelProject.child();
        TopN topN2 = topN = logicalPlan2 instanceof TopN ? (tn = (TopN)logicalPlan2) : null;
        if (topN == null) {
            return Optional.empty();
        }
        LocalPhysicalOptimizerContext context = contextFactory.apply(SEARCH_STATS_TOP_N_REPLACEMENT);
        List<Attribute> expectedDataOutput = LateMaterializationPlanner.toPhysical(topN, context).output();
        Attribute doc = expectedDataOutput.stream().filter(EsQueryExec::isDocAttribute).findFirst().orElse(null);
        if (doc == null) {
            return Optional.empty();
        }
        LogicalPlan withAddedDocToRelation = (LogicalPlan)topN.transformUp(EsRelation.class, r -> {
            if (r.indexMode() == IndexMode.LOOKUP) {
                return r;
            }
            List attributes = CollectionUtils.prependToCopy((Object)doc, r.output());
            return new EsRelation(r.source(), r.indexPattern(), r.indexMode(), r.indexNameWithModes(), attributes);
        });
        if (withAddedDocToRelation.output().stream().noneMatch(EsQueryExec::isDocAttribute)) {
            return Optional.empty();
        }
        Project updatedFragment = new Project(Source.EMPTY, withAddedDocToRelation, expectedDataOutput);
        FragmentExec updatedFragmentExec = fragmentExec.withFragment(updatedFragment);
        ExchangeSinkExec updatedDataPlan = originalPlan.replaceChild(updatedFragmentExec);
        PhysicalPlan reductionPlan = (PhysicalPlan)LateMaterializationPlanner.toPhysical(fragmentExec.fragment(), context).transformDown(TopNExec.class, t -> t.replaceChild(new ExchangeSourceExec(topN.source(), expectedDataOutput, false)));
        ExchangeSinkExec reductionPlanWithSize = originalPlan.replaceChild(EstimatesRowSize.estimateRowSize(updatedFragmentExec.estimatedRowSize(), reductionPlan));
        return Optional.of(new ReductionPlan(reductionPlanWithSize, updatedDataPlan));
    }

    private static PhysicalPlan toPhysical(LogicalPlan plan, LocalPhysicalOptimizerContext context) {
        return new InsertFieldExtraction().apply(new ReplaceSourceAttributes().apply(new LocalMapper().map(plan)), context);
    }

    private LateMaterializationPlanner() {
    }
}

