/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.optimizer.rules.logical.local;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.AttributeSet;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.FieldAttribute;
import org.elasticsearch.xpack.esql.core.expression.NameId;
import org.elasticsearch.xpack.esql.core.expression.NamedExpression;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.EsField;
import org.elasticsearch.xpack.esql.core.type.FunctionEsField;
import org.elasticsearch.xpack.esql.expression.function.blockloader.BlockLoaderExpression;
import org.elasticsearch.xpack.esql.optimizer.LocalLogicalOptimizerContext;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.OptimizerRules;
import org.elasticsearch.xpack.esql.plan.logical.Aggregate;
import org.elasticsearch.xpack.esql.plan.logical.EsRelation;
import org.elasticsearch.xpack.esql.plan.logical.Eval;
import org.elasticsearch.xpack.esql.plan.logical.Filter;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.plan.logical.local.EsqlProject;

public class PushExpressionsToFieldLoad
extends OptimizerRules.ParameterizedOptimizerRule<LogicalPlan, LocalLogicalOptimizerContext> {
    public PushExpressionsToFieldLoad() {
        super(OptimizerRules.TransformDirection.DOWN);
    }

    @Override
    protected LogicalPlan rule(LogicalPlan plan, LocalLogicalOptimizerContext context) {
        if (plan instanceof Eval || plan instanceof Filter || plan instanceof Aggregate) {
            HashMap addedAttrs = new HashMap();
            LogicalPlan transformedPlan = (LogicalPlan)((Object)plan.transformExpressionsOnly(Expression.class, e -> {
                BlockLoaderExpression ble;
                BlockLoaderExpression.PushedBlockLoaderExpression fuse;
                if (e instanceof BlockLoaderExpression && (fuse = (ble = (BlockLoaderExpression)e).tryPushToFieldLoading(context.searchStats())) != null && context.searchStats().supportsLoaderConfig(fuse.field().fieldName(), fuse.config(), context.configuration().pragmas().fieldExtractPreference())) {
                    return PushExpressionsToFieldLoad.replaceFieldsForFieldTransformations(e, addedAttrs, fuse);
                }
                return e;
            }));
            if (addedAttrs.isEmpty()) {
                return plan;
            }
            List<Attribute> previousAttrs = transformedPlan.output();
            List addedAttrsList = addedAttrs.values().stream().toList();
            transformedPlan = (LogicalPlan)transformedPlan.transformDown(EsRelation.class, esRelation -> {
                AttributeSet updatedOutput = esRelation.outputSet().combine(AttributeSet.of((Collection)addedAttrsList));
                return esRelation.withAttributes(updatedOutput.stream().toList());
            });
            transformedPlan = (LogicalPlan)transformedPlan.transformDown(EsqlProject.class, esProject -> {
                ArrayList<? extends NamedExpression> projections = new ArrayList<NamedExpression>(esProject.projections());
                projections.addAll(addedAttrsList);
                return esProject.withProjections(projections);
            });
            return new EsqlProject(Source.EMPTY, transformedPlan, previousAttrs);
        }
        return plan;
    }

    private static Expression replaceFieldsForFieldTransformations(Expression e, Map<Attribute.IdIgnoringWrapper, Attribute> addedAttrs, BlockLoaderExpression.PushedBlockLoaderExpression fuse) {
        FunctionEsField functionEsField = new FunctionEsField(fuse.field().field(), e.dataType(), fuse.config());
        String name = Attribute.rawTemporaryName((String[])new String[]{fuse.field().name(), fuse.config().function().toString(), String.valueOf(fuse.config().hashCode())});
        FieldAttribute newFunctionAttr = new FieldAttribute(fuse.field().source(), fuse.field().parentName(), fuse.field().qualifier(), name, (EsField)functionEsField, fuse.field().nullable(), new NameId(), true);
        Attribute.IdIgnoringWrapper key = newFunctionAttr.ignoreId();
        if (addedAttrs.containsKey(key)) {
            return (Expression)addedAttrs.get(key);
        }
        addedAttrs.put(key, (Attribute)newFunctionAttr);
        return newFunctionAttr;
    }
}

