/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.date;

import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.BytesRefVector;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.LongVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.compute.operator.Warnings;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.core.InvalidArgumentException;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.scalar.date.DateDiff;

public final class DateDiffNanosMillisEvaluator
implements EvalOperator.ExpressionEvaluator {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(DateDiffNanosMillisEvaluator.class);
    private final Source source;
    private final EvalOperator.ExpressionEvaluator unit;
    private final EvalOperator.ExpressionEvaluator startTimestampNanos;
    private final EvalOperator.ExpressionEvaluator endTimestampMillis;
    private final DriverContext driverContext;
    private Warnings warnings;

    public DateDiffNanosMillisEvaluator(Source source, EvalOperator.ExpressionEvaluator unit, EvalOperator.ExpressionEvaluator startTimestampNanos, EvalOperator.ExpressionEvaluator endTimestampMillis, DriverContext driverContext) {
        this.source = source;
        this.unit = unit;
        this.startTimestampNanos = startTimestampNanos;
        this.endTimestampMillis = endTimestampMillis;
        this.driverContext = driverContext;
    }

    /*
     * Exception decompiling
     */
    public Block eval(Page page) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public long baseRamBytesUsed() {
        long baseRamBytesUsed = BASE_RAM_BYTES_USED;
        baseRamBytesUsed += this.unit.baseRamBytesUsed();
        baseRamBytesUsed += this.startTimestampNanos.baseRamBytesUsed();
        return baseRamBytesUsed += this.endTimestampMillis.baseRamBytesUsed();
    }

    public IntBlock eval(int positionCount, BytesRefBlock unitBlock, LongBlock startTimestampNanosBlock, LongBlock endTimestampMillisBlock) {
        try (IntBlock.Builder result = this.driverContext.blockFactory().newIntBlockBuilder(positionCount);){
            BytesRef unitScratch = new BytesRef();
            block19: for (int p = 0; p < positionCount; ++p) {
                switch (unitBlock.getValueCount(p)) {
                    case 0: {
                        result.appendNull();
                        continue block19;
                    }
                    case 1: {
                        break;
                    }
                    default: {
                        this.warnings().registerException((Exception)new IllegalArgumentException("single-value function encountered multi-value"));
                        result.appendNull();
                        continue block19;
                    }
                }
                switch (startTimestampNanosBlock.getValueCount(p)) {
                    case 0: {
                        result.appendNull();
                        continue block19;
                    }
                    case 1: {
                        break;
                    }
                    default: {
                        this.warnings().registerException((Exception)new IllegalArgumentException("single-value function encountered multi-value"));
                        result.appendNull();
                        continue block19;
                    }
                }
                switch (endTimestampMillisBlock.getValueCount(p)) {
                    case 0: {
                        result.appendNull();
                        continue block19;
                    }
                    case 1: {
                        break;
                    }
                    default: {
                        this.warnings().registerException((Exception)new IllegalArgumentException("single-value function encountered multi-value"));
                        result.appendNull();
                        continue block19;
                    }
                }
                BytesRef unit = unitBlock.getBytesRef(unitBlock.getFirstValueIndex(p), unitScratch);
                long startTimestampNanos = startTimestampNanosBlock.getLong(startTimestampNanosBlock.getFirstValueIndex(p));
                long endTimestampMillis = endTimestampMillisBlock.getLong(endTimestampMillisBlock.getFirstValueIndex(p));
                try {
                    result.appendInt(DateDiff.processNanosMillis(unit, startTimestampNanos, endTimestampMillis));
                    continue;
                }
                catch (IllegalArgumentException | InvalidArgumentException e) {
                    this.warnings().registerException((Exception)e);
                    result.appendNull();
                }
            }
            IntBlock intBlock = result.build();
            return intBlock;
        }
    }

    public IntBlock eval(int positionCount, BytesRefVector unitVector, LongVector startTimestampNanosVector, LongVector endTimestampMillisVector) {
        try (IntBlock.Builder result = this.driverContext.blockFactory().newIntBlockBuilder(positionCount);){
            BytesRef unitScratch = new BytesRef();
            for (int p = 0; p < positionCount; ++p) {
                BytesRef unit = unitVector.getBytesRef(p, unitScratch);
                long startTimestampNanos = startTimestampNanosVector.getLong(p);
                long endTimestampMillis = endTimestampMillisVector.getLong(p);
                try {
                    result.appendInt(DateDiff.processNanosMillis(unit, startTimestampNanos, endTimestampMillis));
                    continue;
                }
                catch (IllegalArgumentException | InvalidArgumentException e) {
                    this.warnings().registerException((Exception)e);
                    result.appendNull();
                }
            }
            IntBlock intBlock = result.build();
            return intBlock;
        }
    }

    public String toString() {
        return "DateDiffNanosMillisEvaluator[unit=" + String.valueOf(this.unit) + ", startTimestampNanos=" + String.valueOf(this.startTimestampNanos) + ", endTimestampMillis=" + String.valueOf(this.endTimestampMillis) + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable[])new Releasable[]{this.unit, this.startTimestampNanos, this.endTimestampMillis});
    }

    private Warnings warnings() {
        if (this.warnings == null) {
            this.warnings = Warnings.createWarnings((DriverContext.WarningsMode)this.driverContext.warningsMode(), (int)this.source.source().getLineNumber(), (int)this.source.source().getColumnNumber(), (String)this.source.text());
        }
        return this.warnings;
    }

    static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory unit;
        private final EvalOperator.ExpressionEvaluator.Factory startTimestampNanos;
        private final EvalOperator.ExpressionEvaluator.Factory endTimestampMillis;

        public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory unit, EvalOperator.ExpressionEvaluator.Factory startTimestampNanos, EvalOperator.ExpressionEvaluator.Factory endTimestampMillis) {
            this.source = source;
            this.unit = unit;
            this.startTimestampNanos = startTimestampNanos;
            this.endTimestampMillis = endTimestampMillis;
        }

        public DateDiffNanosMillisEvaluator get(DriverContext context) {
            return new DateDiffNanosMillisEvaluator(this.source, this.unit.get(context), this.startTimestampNanos.get(context), this.endTimestampMillis.get(context), context);
        }

        public String toString() {
            return "DateDiffNanosMillisEvaluator[unit=" + String.valueOf(this.unit) + ", startTimestampNanos=" + String.valueOf(this.startTimestampNanos) + ", endTimestampMillis=" + String.valueOf(this.endTimestampMillis) + "]";
        }
    }
}

