/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.aggregate;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.common.Randomness;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.compute.aggregation.AggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.SampleBooleanAggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.SampleBytesRefAggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.SampleDoubleAggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.SampleIntAggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.SampleLongAggregatorFunctionSupplier;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.xpack.esql.EsqlIllegalArgumentException;
import org.elasticsearch.xpack.esql.capabilities.PostOptimizationVerificationAware;
import org.elasticsearch.xpack.esql.common.Failures;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Literal;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.expression.Foldables;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionAppliesTo;
import org.elasticsearch.xpack.esql.expression.function.FunctionAppliesToLifecycle;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.FunctionType;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.aggregate.AggregateFunction;
import org.elasticsearch.xpack.esql.planner.PlannerUtils;
import org.elasticsearch.xpack.esql.planner.ToAggregator;

public class Sample
extends AggregateFunction
implements ToAggregator,
PostOptimizationVerificationAware {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "Sample", Sample::new);

    @FunctionInfo(returnType={"boolean", "cartesian_point", "cartesian_shape", "date", "date_nanos", "double", "geo_point", "geo_shape", "geohash", "geotile", "geohex", "integer", "ip", "keyword", "long", "unsigned_long", "version"}, description="Collects sample values for a field.", type=FunctionType.AGGREGATE, examples={@Example(file="stats_sample", tag="doc")}, appliesTo={@FunctionAppliesTo(lifeCycle=FunctionAppliesToLifecycle.GA, version="9.1.0")})
    public Sample(Source source, @Param(name="field", type={"boolean", "cartesian_point", "cartesian_shape", "date", "date_nanos", "double", "geo_point", "geo_shape", "geohash", "geotile", "geohex", "integer", "ip", "keyword", "long", "unsigned_long", "text", "version"}, description="The field to collect sample values for.") Expression field, @Param(name="limit", type={"integer"}, description="The maximum number of values to collect.") Expression limit) {
        this(source, field, (Expression)Literal.TRUE, (Expression)NO_WINDOW, limit, (Expression)new Literal(Source.EMPTY, (Object)Randomness.get().nextLong(), DataType.LONG));
    }

    public Sample(Source source, Expression field, Expression filter, Expression window, Expression limit, Expression uuid) {
        super(source, field, filter, window, List.of(limit, uuid));
    }

    private Sample(StreamInput in) throws IOException {
        super(in);
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        Expression.TypeResolution typeResolution = TypeResolutions.isRepresentableExceptCountersDenseVectorAndAggregateMetricDouble((Expression)this.field(), (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.FIRST).and(TypeResolutions.isNotNull((Expression)this.limitField(), (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.SECOND)).and(TypeResolutions.isType((Expression)this.limitField(), dt -> dt == DataType.INTEGER, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.SECOND, (String[])new String[]{"integer"}));
        if (typeResolution.unresolved()) {
            return typeResolution;
        }
        Expression.TypeResolution result = Foldables.resolveTypeLimit(this.limitField(), this.sourceText(), Foldables.TypeResolutionValidator.forPreOptimizationValidation(this.limitField()));
        if (!result.equals(Expression.TypeResolution.TYPE_RESOLVED)) {
            return result;
        }
        return Expression.TypeResolution.TYPE_RESOLVED;
    }

    public String getWriteableName() {
        return Sample.ENTRY.name;
    }

    public DataType dataType() {
        return this.field().dataType().noText();
    }

    protected NodeInfo<Sample> info() {
        return NodeInfo.create((Node)this, Sample::new, (Object)this.field(), (Object)this.filter(), (Object)this.window(), (Object)this.limitField(), (Object)this.uuid());
    }

    public Sample replaceChildren(List<Expression> newChildren) {
        return new Sample(this.source(), newChildren.get(0), newChildren.get(1), newChildren.get(2), newChildren.get(3), newChildren.get(4));
    }

    @Override
    public AggregatorFunctionSupplier supplier() {
        return switch (PlannerUtils.toElementType(this.field().dataType())) {
            case ElementType.BOOLEAN -> new SampleBooleanAggregatorFunctionSupplier(this.limitValue());
            case ElementType.BYTES_REF -> new SampleBytesRefAggregatorFunctionSupplier(this.limitValue());
            case ElementType.DOUBLE -> new SampleDoubleAggregatorFunctionSupplier(this.limitValue());
            case ElementType.INT -> new SampleIntAggregatorFunctionSupplier(this.limitValue());
            case ElementType.LONG -> new SampleLongAggregatorFunctionSupplier(this.limitValue());
            default -> throw EsqlIllegalArgumentException.illegalDataType(this.field().dataType());
        };
    }

    @Override
    public Sample withFilter(Expression filter) {
        return new Sample(this.source(), this.field(), filter, this.window(), this.limitField(), this.uuid());
    }

    Expression limitField() {
        return this.parameters().get(0);
    }

    private int limitValue() {
        return Foldables.limitValue(this.limitField(), this.sourceText());
    }

    Expression uuid() {
        return this.parameters().get(1);
    }

    @Override
    public void postOptimizationVerification(Failures failures) {
        Foldables.resolveTypeLimit(this.limitField(), this.sourceText(), Foldables.TypeResolutionValidator.forPostOptimizationValidation(this.limitField(), failures));
    }
}

