/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.analysis;

import java.lang.runtime.SwitchBootstraps;
import java.time.Duration;
import java.time.temporal.TemporalAmount;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.logging.HeaderWarning;
import org.elasticsearch.common.logging.LoggerMessageFormat;
import org.elasticsearch.common.lucene.BytesRefs;
import org.elasticsearch.compute.data.AggregateMetricDoubleBlockBuilder;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.core.Strings;
import org.elasticsearch.index.IndexMode;
import org.elasticsearch.logging.Logger;
import org.elasticsearch.xpack.core.enrich.EnrichPolicy;
import org.elasticsearch.xpack.esql.Column;
import org.elasticsearch.xpack.esql.EsqlIllegalArgumentException;
import org.elasticsearch.xpack.esql.VerificationException;
import org.elasticsearch.xpack.esql.analysis.AnalyzerContext;
import org.elasticsearch.xpack.esql.analysis.AnalyzerRules;
import org.elasticsearch.xpack.esql.analysis.Verifier;
import org.elasticsearch.xpack.esql.capabilities.TranslationAware;
import org.elasticsearch.xpack.esql.common.Failure;
import org.elasticsearch.xpack.esql.core.capabilities.Resolvables;
import org.elasticsearch.xpack.esql.core.expression.Alias;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.AttributeSet;
import org.elasticsearch.xpack.esql.core.expression.EmptyAttribute;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Expressions;
import org.elasticsearch.xpack.esql.core.expression.FieldAttribute;
import org.elasticsearch.xpack.esql.core.expression.FoldContext;
import org.elasticsearch.xpack.esql.core.expression.Literal;
import org.elasticsearch.xpack.esql.core.expression.MetadataAttribute;
import org.elasticsearch.xpack.esql.core.expression.NameId;
import org.elasticsearch.xpack.esql.core.expression.NamedExpression;
import org.elasticsearch.xpack.esql.core.expression.Nullability;
import org.elasticsearch.xpack.esql.core.expression.ReferenceAttribute;
import org.elasticsearch.xpack.esql.core.expression.UnresolvedAttribute;
import org.elasticsearch.xpack.esql.core.expression.UnresolvedStar;
import org.elasticsearch.xpack.esql.core.expression.predicate.BinaryOperator;
import org.elasticsearch.xpack.esql.core.expression.predicate.operator.comparison.BinaryComparison;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.core.type.EsField;
import org.elasticsearch.xpack.esql.core.type.InvalidMappedField;
import org.elasticsearch.xpack.esql.core.type.MultiTypeEsField;
import org.elasticsearch.xpack.esql.core.type.PotentiallyUnmappedKeywordEsField;
import org.elasticsearch.xpack.esql.core.type.UnsupportedEsField;
import org.elasticsearch.xpack.esql.core.util.CollectionUtils;
import org.elasticsearch.xpack.esql.core.util.Holder;
import org.elasticsearch.xpack.esql.core.util.StringUtils;
import org.elasticsearch.xpack.esql.enrich.ResolvedEnrichPolicy;
import org.elasticsearch.xpack.esql.expression.NamedExpressions;
import org.elasticsearch.xpack.esql.expression.UnresolvedNamePattern;
import org.elasticsearch.xpack.esql.expression.function.EsqlFunctionRegistry;
import org.elasticsearch.xpack.esql.expression.function.FunctionDefinition;
import org.elasticsearch.xpack.esql.expression.function.UnresolvedFunction;
import org.elasticsearch.xpack.esql.expression.function.UnsupportedAttribute;
import org.elasticsearch.xpack.esql.expression.function.aggregate.Absent;
import org.elasticsearch.xpack.esql.expression.function.aggregate.AbsentOverTime;
import org.elasticsearch.xpack.esql.expression.function.aggregate.AggregateFunction;
import org.elasticsearch.xpack.esql.expression.function.aggregate.Avg;
import org.elasticsearch.xpack.esql.expression.function.aggregate.AvgOverTime;
import org.elasticsearch.xpack.esql.expression.function.aggregate.Count;
import org.elasticsearch.xpack.esql.expression.function.aggregate.CountOverTime;
import org.elasticsearch.xpack.esql.expression.function.aggregate.Max;
import org.elasticsearch.xpack.esql.expression.function.aggregate.MaxOverTime;
import org.elasticsearch.xpack.esql.expression.function.aggregate.Min;
import org.elasticsearch.xpack.esql.expression.function.aggregate.MinOverTime;
import org.elasticsearch.xpack.esql.expression.function.aggregate.Present;
import org.elasticsearch.xpack.esql.expression.function.aggregate.PresentOverTime;
import org.elasticsearch.xpack.esql.expression.function.aggregate.Sum;
import org.elasticsearch.xpack.esql.expression.function.aggregate.SumOverTime;
import org.elasticsearch.xpack.esql.expression.function.aggregate.SummationMode;
import org.elasticsearch.xpack.esql.expression.function.aggregate.Values;
import org.elasticsearch.xpack.esql.expression.function.grouping.GroupingFunction;
import org.elasticsearch.xpack.esql.expression.function.inference.InferenceFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.EsqlScalarFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.conditional.Case;
import org.elasticsearch.xpack.esql.expression.function.scalar.conditional.Greatest;
import org.elasticsearch.xpack.esql.expression.function.scalar.conditional.Least;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.AbstractConvertFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ConvertFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.FoldablesConvertFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.FromAggregateMetricDouble;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToAggregateMetricDouble;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToDateNanos;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToDenseVector;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToDouble;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToInteger;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToLong;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToString;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToUnsignedLong;
import org.elasticsearch.xpack.esql.expression.function.scalar.nulls.Coalesce;
import org.elasticsearch.xpack.esql.expression.function.vector.VectorFunction;
import org.elasticsearch.xpack.esql.expression.predicate.Predicates;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.DateTimeArithmeticOperation;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.EsqlArithmeticOperation;
import org.elasticsearch.xpack.esql.expression.predicate.operator.comparison.EsqlBinaryComparison;
import org.elasticsearch.xpack.esql.expression.predicate.operator.comparison.In;
import org.elasticsearch.xpack.esql.index.EsIndex;
import org.elasticsearch.xpack.esql.index.IndexResolution;
import org.elasticsearch.xpack.esql.inference.ResolvedInference;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.SubstituteSurrogateExpressions;
import org.elasticsearch.xpack.esql.optimizer.rules.physical.local.LucenePushdownPredicates;
import org.elasticsearch.xpack.esql.parser.ParsingException;
import org.elasticsearch.xpack.esql.plan.IndexPattern;
import org.elasticsearch.xpack.esql.plan.QueryPlan;
import org.elasticsearch.xpack.esql.plan.logical.Aggregate;
import org.elasticsearch.xpack.esql.plan.logical.Drop;
import org.elasticsearch.xpack.esql.plan.logical.Enrich;
import org.elasticsearch.xpack.esql.plan.logical.EsRelation;
import org.elasticsearch.xpack.esql.plan.logical.Eval;
import org.elasticsearch.xpack.esql.plan.logical.Fork;
import org.elasticsearch.xpack.esql.plan.logical.InlineStats;
import org.elasticsearch.xpack.esql.plan.logical.Insist;
import org.elasticsearch.xpack.esql.plan.logical.Keep;
import org.elasticsearch.xpack.esql.plan.logical.Limit;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.plan.logical.Lookup;
import org.elasticsearch.xpack.esql.plan.logical.MvExpand;
import org.elasticsearch.xpack.esql.plan.logical.Project;
import org.elasticsearch.xpack.esql.plan.logical.Rename;
import org.elasticsearch.xpack.esql.plan.logical.TimeSeriesAggregate;
import org.elasticsearch.xpack.esql.plan.logical.UnionAll;
import org.elasticsearch.xpack.esql.plan.logical.UnresolvedRelation;
import org.elasticsearch.xpack.esql.plan.logical.fuse.Fuse;
import org.elasticsearch.xpack.esql.plan.logical.fuse.FuseScoreEval;
import org.elasticsearch.xpack.esql.plan.logical.inference.Completion;
import org.elasticsearch.xpack.esql.plan.logical.inference.InferencePlan;
import org.elasticsearch.xpack.esql.plan.logical.inference.Rerank;
import org.elasticsearch.xpack.esql.plan.logical.join.Join;
import org.elasticsearch.xpack.esql.plan.logical.join.JoinConfig;
import org.elasticsearch.xpack.esql.plan.logical.join.JoinType;
import org.elasticsearch.xpack.esql.plan.logical.join.JoinTypes;
import org.elasticsearch.xpack.esql.plan.logical.join.LookupJoin;
import org.elasticsearch.xpack.esql.plan.logical.local.EsqlProject;
import org.elasticsearch.xpack.esql.plan.logical.local.LocalRelation;
import org.elasticsearch.xpack.esql.plan.logical.local.LocalSupplier;
import org.elasticsearch.xpack.esql.rule.ParameterizedRule;
import org.elasticsearch.xpack.esql.rule.ParameterizedRuleExecutor;
import org.elasticsearch.xpack.esql.rule.Rule;
import org.elasticsearch.xpack.esql.rule.RuleExecutor;
import org.elasticsearch.xpack.esql.session.Configuration;
import org.elasticsearch.xpack.esql.telemetry.FeatureMetric;
import org.elasticsearch.xpack.esql.type.EsqlDataTypeConverter;

public class Analyzer
extends ParameterizedRuleExecutor<LogicalPlan, AnalyzerContext> {
    public static final String NO_FIELDS_NAME = "<no-fields>";
    public static final List<Attribute> NO_FIELDS = List.of(new ReferenceAttribute(Source.EMPTY, null, "<no-fields>", DataType.NULL, Nullability.TRUE, null, true));
    private static final List<RuleExecutor.Batch<LogicalPlan>> RULES = List.of(new RuleExecutor.Batch("Initialize", RuleExecutor.Limiter.ONCE, new ResolveTable(), new ResolveEnrich(), new ResolveLookupTables(), new ResolveFunctions(), new ResolveInference(), new DateMillisToNanosInEsRelation()), new RuleExecutor.Batch("Resolution", new ResolveRefs(), new ImplicitCasting(), new ResolveUnionTypes(), new ImplicitCastAggregateMetricDoubles(), new ResolveUnionTypesInUnionAll()), new RuleExecutor.Batch("Finish Analysis", RuleExecutor.Limiter.ONCE, new AddImplicitLimit(), new AddImplicitForkLimit(), new UnionTypesCleanup()));
    public static final TransportVersion ESQL_LOOKUP_JOIN_FULL_TEXT_FUNCTION = TransportVersion.fromName((String)"esql_lookup_join_full_text_function");
    private final Verifier verifier;

    public Analyzer(AnalyzerContext context, Verifier verifier) {
        super(context);
        this.verifier = verifier;
    }

    public LogicalPlan analyze(LogicalPlan plan) {
        BitSet partialMetrics = new BitSet(FeatureMetric.values().length);
        return this.verify(this.execute(plan), this.gatherPreAnalysisMetrics(plan, partialMetrics));
    }

    public LogicalPlan verify(LogicalPlan plan, BitSet partialMetrics) {
        Collection<Failure> failures = this.verifier.verify(plan, partialMetrics);
        if (!failures.isEmpty()) {
            throw new VerificationException(failures);
        }
        return plan;
    }

    @Override
    protected List<RuleExecutor.Batch<LogicalPlan>> batches() {
        return RULES;
    }

    public static List<Attribute> mappingAsAttributes(Source source, Map<String, EsField> mapping) {
        ArrayList<Attribute> list = new ArrayList<Attribute>();
        Analyzer.mappingAsAttributes(list, source, null, mapping);
        list.sort(Comparator.comparing(NamedExpression::name));
        return list;
    }

    private static void mappingAsAttributes(List<Attribute> list, Source source, String parentName, Map<String, EsField> mapping) {
        for (Map.Entry<String, EsField> entry : mapping.entrySet()) {
            FieldAttribute attribute;
            String name = entry.getKey();
            EsField t = entry.getValue();
            if (t == null) continue;
            name = parentName == null ? name : parentName + "." + name;
            Map fieldProperties = t.getProperties();
            DataType type = t.getDataType().widenSmallNumeric();
            if (type != t.getDataType()) {
                t = new EsField(t.getName(), type, t.getProperties(), t.isAggregatable(), t.isAlias(), t.getTimeSeriesFieldType());
            }
            if (t instanceof UnsupportedEsField) {
                UnsupportedEsField uef = (UnsupportedEsField)t;
                v0 = new UnsupportedAttribute(source, name, uef);
            } else {
                v0 = attribute = new FieldAttribute(source, parentName, null, name, t);
            }
            if (DataType.isPrimitive((DataType)type)) {
                list.add((Attribute)attribute);
            }
            if (fieldProperties.isEmpty()) continue;
            Analyzer.mappingAsAttributes(list, source, attribute.name(), fieldProperties);
        }
    }

    private static List<Attribute> resolveAgainstList(UnresolvedNamePattern up, Collection<Attribute> attrList) {
        UnresolvedAttribute ua = new UnresolvedAttribute(up.source(), up.pattern());
        Predicate<Attribute> matcher = a -> up.match(a.name());
        List<Attribute> matches = AnalyzerRules.maybeResolveAgainstList(matcher, () -> ua, attrList, true, a -> Analyzer.handleSpecialFields(ua, a));
        return Analyzer.potentialCandidatesIfNoMatchesFound(ua, matches, attrList, list -> UnresolvedNamePattern.errorMessage(up.pattern(), list));
    }

    private static List<Attribute> resolveAgainstList(UnresolvedAttribute ua, Collection<Attribute> attrList) {
        List<Attribute> matches = AnalyzerRules.maybeResolveAgainstList(ua, attrList, a -> Analyzer.handleSpecialFields(ua, a));
        return Analyzer.potentialCandidatesIfNoMatchesFound(ua, matches, attrList, arg_0 -> ((UnresolvedAttribute)ua).defaultUnresolvedMessage(arg_0));
    }

    private static List<Attribute> potentialCandidatesIfNoMatchesFound(UnresolvedAttribute ua, List<Attribute> matches, Collection<Attribute> attrList, Function<List<String>, String> messageProducer) {
        if (ua.customMessage()) {
            return List.of();
        }
        if (matches.isEmpty()) {
            HashSet<String> names = new HashSet<String>(attrList.size());
            for (Attribute a : attrList) {
                String nameCandidate = a.name();
                if (!DataType.isPrimitive((DataType)a.dataType())) continue;
                names.add(nameCandidate);
            }
            String name = ua.name();
            UnresolvedAttribute unresolved = ua.withUnresolvedMessage(messageProducer.apply(StringUtils.findSimilar((String)name, names)));
            matches = Collections.singletonList(unresolved);
        }
        return matches;
    }

    private static Attribute handleSpecialFields(UnresolvedAttribute u, Attribute named) {
        return named.withLocation(u.source());
    }

    private BitSet gatherPreAnalysisMetrics(LogicalPlan plan, BitSet b) {
        if (!plan.collectFirstChildren(Limit.class::isInstance).isEmpty()) {
            b.set(FeatureMetric.LIMIT.ordinal());
        }
        if (plan instanceof Aggregate) {
            b.set(FeatureMetric.STATS.ordinal());
        } else {
            plan.forEachDownMayReturnEarly((p, breakEarly) -> {
                if (p instanceof InlineStats) {
                    return;
                }
                for (LogicalPlan c : p.children()) {
                    if (!(c instanceof Aggregate)) continue;
                    b.set(FeatureMetric.STATS.ordinal());
                    breakEarly.set((Object)true);
                    return;
                }
            });
        }
        plan.forEachDown(p -> FeatureMetric.set(p, b));
        return b;
    }

    private static void typeResolutions(FieldAttribute fieldAttribute, ConvertFunction convert, DataType type, InvalidMappedField imf, HashMap<ResolveUnionTypes.TypeResolutionKey, Expression> typeResolutions) {
        ResolveUnionTypes.TypeResolutionKey key = new ResolveUnionTypes.TypeResolutionKey(fieldAttribute.name(), type);
        Expression concreteConvert = ResolveUnionTypes.typeSpecificConvert(convert, fieldAttribute.source(), type, imf);
        typeResolutions.put(key, concreteConvert);
    }

    private static class ResolveUnionTypes
    extends Rule<LogicalPlan, LogicalPlan> {
        private ResolveUnionTypes() {
        }

        @Override
        public LogicalPlan apply(LogicalPlan plan) {
            ArrayList unionFieldAttributes = new ArrayList();
            return (LogicalPlan)plan.transformUp(LogicalPlan.class, p -> !p.childrenResolved() ? p : this.doRule((LogicalPlan)((Object)p), unionFieldAttributes));
        }

        private LogicalPlan doRule(LogicalPlan plan, List<Attribute.IdIgnoringWrapper> unionFieldAttributes) {
            Holder alreadyAddedUnionFieldAttributes = new Holder((Object)unionFieldAttributes.size());
            if (plan instanceof EsRelation) {
                EsRelation rel = (EsRelation)plan;
                unionFieldAttributes.clear();
                for (Attribute attr2 : rel.output()) {
                    FieldAttribute fa;
                    if (!(attr2 instanceof FieldAttribute) || !((fa = (FieldAttribute)attr2).field() instanceof MultiTypeEsField) || !fa.synthetic()) continue;
                    unionFieldAttributes.add(fa.ignoreId());
                }
            }
            plan = (LogicalPlan)((Object)plan.transformExpressionsOnly(e -> {
                if (e instanceof ConvertFunction) {
                    ConvertFunction convert = (ConvertFunction)e;
                    return this.resolveConvertFunction(convert, unionFieldAttributes);
                }
                return e;
            }));
            if (unionFieldAttributes.size() == ((Integer)alreadyAddedUnionFieldAttributes.get()).intValue()) {
                return plan;
            }
            return ResolveUnionTypes.addGeneratedFieldsToEsRelations(plan, unionFieldAttributes.stream().map(attr -> (FieldAttribute)attr.inner()).toList());
        }

        private static LogicalPlan addGeneratedFieldsToEsRelations(LogicalPlan plan, List<FieldAttribute> unionFieldAttributes) {
            return (LogicalPlan)plan.transformDown(EsRelation.class, esr -> {
                ArrayList<FieldAttribute> missing = new ArrayList<FieldAttribute>();
                for (FieldAttribute fa : unionFieldAttributes) {
                    if (esr.outputSet().contains((Object)fa)) continue;
                    missing.add(fa);
                }
                if (!missing.isEmpty()) {
                    return new EsRelation(esr.source(), esr.indexPattern(), esr.indexMode(), esr.indexNameWithModes(), CollectionUtils.combine(esr.output(), missing));
                }
                return esr;
            });
        }

        private Expression resolveConvertFunction(ConvertFunction convert, List<Attribute.IdIgnoringWrapper> unionFieldAttributes) {
            FieldAttribute fa;
            Expression convertExpression = (Expression)convert;
            Expression expression = convert.field();
            if (expression instanceof FieldAttribute && (expression = (fa = (FieldAttribute)expression).field()) instanceof InvalidMappedField) {
                InvalidMappedField imf = (InvalidMappedField)expression;
                typeResolutions = new HashMap();
                Set<DataType> supportedTypes = convert.supportedTypes();
                if (convert instanceof FoldablesConvertFunction) {
                    FoldablesConvertFunction fcf = (FoldablesConvertFunction)convert;
                    String unresolvedMessage = "argument of [" + fcf.sourceText() + "] must be a constant, received [" + Expressions.name((Expression)fa) + "]";
                    UnresolvedAttribute ua = new UnresolvedAttribute(fa.source(), fa.name(), unresolvedMessage);
                    return (Expression)fcf.replaceChildren(Collections.singletonList(ua));
                }
                imf.types().forEach(arg_0 -> ResolveUnionTypes.lambda$resolveConvertFunction$4(supportedTypes, fa, convert, imf, (HashMap)typeResolutions, arg_0));
                if (((HashMap)typeResolutions).size() == imf.getTypesToIndices().size()) {
                    MultiTypeEsField resolvedField = ResolveUnionTypes.resolvedMultiTypeEsField(fa, (HashMap<TypeResolutionKey, Expression>)typeResolutions);
                    return this.createIfDoesNotAlreadyExist(fa, resolvedField, unionFieldAttributes);
                }
            } else {
                FieldAttribute fa2;
                typeResolutions = convert.field();
                if (typeResolutions instanceof FieldAttribute && !(fa2 = (FieldAttribute)typeResolutions).synthetic() && (typeResolutions = fa2.field()) instanceof MultiTypeEsField) {
                    MultiTypeEsField mtf = (MultiTypeEsField)typeResolutions;
                    if (((Expression)convert).dataType() == mtf.getDataType()) {
                        return this.createIfDoesNotAlreadyExist(fa2, mtf, unionFieldAttributes);
                    }
                    Set<DataType> supportedTypes = convert.supportedTypes();
                    if (supportedTypes.contains(fa2.dataType()) && ResolveUnionTypes.canConvertOriginalTypes(mtf, supportedTypes)) {
                        HashMap<String, Expression> indexToConversionExpressions = new HashMap<String, Expression>();
                        for (Map.Entry entry : mtf.getIndexToConversionExpressions().entrySet()) {
                            String indexName = (String)entry.getKey();
                            AbstractConvertFunction originalConversionFunction = (AbstractConvertFunction)entry.getValue();
                            Expression originalField = originalConversionFunction.field();
                            Expression newConvertFunction = (Expression)convertExpression.replaceChildren(Collections.singletonList(originalField));
                            indexToConversionExpressions.put(indexName, newConvertFunction);
                        }
                        MultiTypeEsField multiTypeEsField = new MultiTypeEsField(fa2.fieldName().string(), convertExpression.dataType(), false, indexToConversionExpressions, fa2.field().getTimeSeriesFieldType());
                        return this.createIfDoesNotAlreadyExist(fa2, multiTypeEsField, unionFieldAttributes);
                    }
                } else {
                    expression = convert.field();
                    if (expression instanceof AbstractConvertFunction) {
                        AbstractConvertFunction subConvert = (AbstractConvertFunction)expression;
                        return (Expression)convertExpression.replaceChildren(Collections.singletonList(this.resolveConvertFunction(subConvert, unionFieldAttributes)));
                    }
                }
            }
            return convertExpression;
        }

        private Expression createIfDoesNotAlreadyExist(FieldAttribute fa, MultiTypeEsField resolvedField, List<Attribute.IdIgnoringWrapper> unionFieldAttributes) {
            String unionTypedFieldName = Attribute.rawTemporaryName((String[])new String[]{fa.name(), "converted_to", resolvedField.getDataType().typeName()});
            FieldAttribute unionFieldAttribute = new FieldAttribute(fa.source(), fa.parentName(), fa.qualifier(), unionTypedFieldName, (EsField)resolvedField, true);
            Attribute.IdIgnoringWrapper nonSemanticUnionFieldAttribute = unionFieldAttribute.ignoreId();
            int existingIndex = unionFieldAttributes.indexOf(nonSemanticUnionFieldAttribute);
            if (existingIndex >= 0) {
                return unionFieldAttributes.get(existingIndex).inner();
            }
            unionFieldAttributes.add(nonSemanticUnionFieldAttribute);
            return nonSemanticUnionFieldAttribute.inner();
        }

        private static MultiTypeEsField resolvedMultiTypeEsField(FieldAttribute fa, HashMap<TypeResolutionKey, Expression> typeResolutions) {
            HashMap typesToConversionExpressions = new HashMap();
            InvalidMappedField imf = (InvalidMappedField)fa.field();
            imf.getTypesToIndices().forEach((typeName, indexNames) -> {
                DataType type = DataType.fromTypeName((String)typeName);
                TypeResolutionKey key = new TypeResolutionKey(fa.name(), type);
                if (typeResolutions.containsKey(key)) {
                    typesToConversionExpressions.put(typeName, (Expression)typeResolutions.get(key));
                }
            });
            return MultiTypeEsField.resolveFrom((InvalidMappedField)imf, typesToConversionExpressions);
        }

        private static boolean canConvertOriginalTypes(MultiTypeEsField multiTypeEsField, Set<DataType> supportedTypes) {
            return multiTypeEsField.getIndexToConversionExpressions().values().stream().allMatch(e -> {
                AbstractConvertFunction convertFunction;
                return e instanceof AbstractConvertFunction && supportedTypes.contains((convertFunction = (AbstractConvertFunction)e).field().dataType().widenSmallNumeric());
            });
        }

        private static Expression typeSpecificConvert(ConvertFunction convert, Source source, DataType type, InvalidMappedField mtf) {
            EsField field = new EsField(mtf.getName(), type, mtf.getProperties(), mtf.isAggregatable(), mtf.getTimeSeriesFieldType());
            FieldAttribute originalFieldAttr = (FieldAttribute)convert.field();
            FieldAttribute resolvedAttr = new FieldAttribute(source, originalFieldAttr.parentName(), originalFieldAttr.qualifier(), originalFieldAttr.name(), field, originalFieldAttr.nullable(), originalFieldAttr.id(), true);
            Expression fn = (Expression)convert;
            ArrayList<FieldAttribute> children = new ArrayList<FieldAttribute>(fn.children());
            children.set(0, resolvedAttr);
            Expression e = (Expression)((Expression)convert).replaceChildren(children);
            return SubstituteSurrogateExpressions.rule(e);
        }

        private static /* synthetic */ void lambda$resolveConvertFunction$4(Set supportedTypes, FieldAttribute fa, ConvertFunction convert, InvalidMappedField imf, HashMap typeResolutions, DataType type) {
            if (supportedTypes.contains(type.widenSmallNumeric())) {
                Analyzer.typeResolutions(fa, convert, type, imf, typeResolutions);
            }
        }

        record TypeResolutionKey(String fieldName, DataType fieldType) {
        }
    }

    private static class ResolveTable
    extends AnalyzerRules.ParameterizedAnalyzerRule<UnresolvedRelation, AnalyzerContext> {
        private ResolveTable() {
        }

        @Override
        protected LogicalPlan rule(UnresolvedRelation plan, AnalyzerContext context) {
            IndexResolution indexResolution = plan.indexMode().equals((Object)IndexMode.LOOKUP) ? context.lookupResolution().get(plan.indexPattern().indexPattern()) : context.indexResolution().get(plan.indexPattern());
            return this.resolveIndex(plan, indexResolution);
        }

        private LogicalPlan resolveIndex(UnresolvedRelation plan, IndexResolution indexResolution) {
            if (indexResolution == null || !indexResolution.isValid()) {
                String indexResolutionMessage = indexResolution == null ? "[none specified]" : indexResolution.toString();
                return plan.unresolvedMessage().equals(indexResolutionMessage) ? plan : new UnresolvedRelation(plan.source(), plan.indexPattern(), plan.frozen(), plan.metadataFields(), plan.indexMode(), indexResolutionMessage, plan.telemetryLabel());
            }
            IndexPattern table = plan.indexPattern();
            if (!indexResolution.matches(table.indexPattern())) {
                new UnresolvedRelation(plan.source(), plan.indexPattern(), plan.frozen(), plan.metadataFields(), plan.indexMode(), "invalid [" + String.valueOf(table) + "] resolution to [" + String.valueOf(indexResolution) + "]", plan.telemetryLabel());
            }
            EsIndex esIndex = indexResolution.get();
            List<Attribute> attributes = Analyzer.mappingAsAttributes(plan.source(), esIndex.mapping());
            attributes.addAll(plan.metadataFields());
            return new EsRelation(plan.source(), esIndex.name(), plan.indexMode(), esIndex.indexNameWithModes(), attributes.isEmpty() ? NO_FIELDS : attributes);
        }
    }

    private static class ResolveEnrich
    extends AnalyzerRules.ParameterizedAnalyzerRule<Enrich, AnalyzerContext> {
        private ResolveEnrich() {
        }

        @Override
        protected LogicalPlan rule(Enrich plan, AnalyzerContext context) {
            if (!plan.policyName().resolved()) {
                return plan;
            }
            String policyName = BytesRefs.toString((Object)plan.policyName().fold(FoldContext.small()));
            ResolvedEnrichPolicy resolved = context.enrichResolution().getResolvedPolicy(policyName, plan.mode());
            if (resolved != null) {
                EnrichPolicy policy = new EnrichPolicy(resolved.matchType(), null, List.of(), resolved.matchField(), resolved.enrichFields());
                UnresolvedAttribute matchField = plan.matchField() == null || plan.matchField() instanceof EmptyAttribute ? new UnresolvedAttribute(plan.source(), policy.getMatchField()) : plan.matchField();
                List<NamedExpression> enrichFields = ResolveEnrich.calculateEnrichFields(plan.source(), policyName, Analyzer.mappingAsAttributes(plan.source(), resolved.mapping()), plan.enrichFields(), policy);
                return new Enrich(plan.source(), plan.child(), plan.mode(), plan.policyName(), (NamedExpression)matchField, policy, resolved.concreteIndices(), enrichFields);
            }
            String error = context.enrichResolution().getError(policyName, plan.mode());
            UnresolvedAttribute policyNameExp = new UnresolvedAttribute(plan.policyName().source(), policyName, error);
            return new Enrich(plan.source(), plan.child(), plan.mode(), (Expression)policyNameExp, plan.matchField(), null, Map.of(), List.of());
        }

        public static List<NamedExpression> calculateEnrichFields(Source source, String policyName, List<Attribute> mapping, List<NamedExpression> enrichFields, EnrichPolicy policy) {
            HashSet policyEnrichFieldSet = new HashSet(policy.getEnrichFields());
            Map<String, Attribute> fieldMap = mapping.stream().filter(e -> policyEnrichFieldSet.contains(e.name())).collect(Collectors.toMap(NamedExpression::name, Function.identity()));
            ArrayList<NamedExpression> result = new ArrayList<NamedExpression>();
            if (enrichFields == null || enrichFields.isEmpty()) {
                for (String enrichFieldName : policy.getEnrichFields()) {
                    result.add(ResolveEnrich.createEnrichFieldExpression(source, policyName, fieldMap, enrichFieldName));
                }
            } else {
                for (NamedExpression enrichField : enrichFields) {
                    NamedExpression namedExpression;
                    NamedExpression namedExpression2;
                    if (enrichField instanceof Alias) {
                        Alias a = (Alias)enrichField;
                        namedExpression2 = a.child();
                    } else {
                        namedExpression2 = enrichField;
                    }
                    String enrichFieldName = Expressions.name((Expression)namedExpression2);
                    NamedExpression field = ResolveEnrich.createEnrichFieldExpression(source, policyName, fieldMap, enrichFieldName);
                    if (enrichField instanceof Alias) {
                        Alias a = (Alias)enrichField;
                        namedExpression = new Alias(a.source(), a.name(), (Expression)field);
                    } else {
                        namedExpression = field;
                    }
                    result.add(namedExpression);
                }
            }
            return result;
        }

        private static NamedExpression createEnrichFieldExpression(Source source, String policyName, Map<String, Attribute> fieldMap, String enrichFieldName) {
            Attribute mappedField = fieldMap.get(enrichFieldName);
            if (mappedField == null) {
                String msg = "Enrich field [" + enrichFieldName + "] not found in enrich policy [" + policyName + "]";
                List similar = StringUtils.findSimilar((String)enrichFieldName, fieldMap.keySet());
                if (!CollectionUtils.isEmpty((Collection)similar)) {
                    msg = msg + ", did you mean " + (similar.size() == 1 ? "[" + (String)similar.get(0) + "]" : "any of " + String.valueOf(similar)) + "?";
                }
                return new UnresolvedAttribute(source, enrichFieldName, msg);
            }
            return new ReferenceAttribute(source, null, enrichFieldName, mappedField.dataType(), Nullability.TRUE, null, false);
        }
    }

    private static class ResolveLookupTables
    extends AnalyzerRules.ParameterizedAnalyzerRule<Lookup, AnalyzerContext> {
        private ResolveLookupTables() {
        }

        @Override
        protected LogicalPlan rule(Lookup lookup, AnalyzerContext context) {
            Source source = lookup.source();
            Expression tableNameExpression = lookup.tableName();
            String tableName = BytesRefs.toString((Object)tableNameExpression.fold(FoldContext.small()));
            Map<String, Map<String, Column>> tables = context.configuration().tables();
            LocalRelation localRelation = null;
            if (!tables.containsKey(tableName)) {
                Object message = "Unknown table [" + tableName + "]";
                List potentialMatches = StringUtils.findSimilar((String)tableName, tables.keySet());
                if (!CollectionUtils.isEmpty((Collection)potentialMatches)) {
                    message = UnresolvedAttribute.errorMessage((String)tableName, (List)potentialMatches).replace("column", "table");
                }
                tableNameExpression = new UnresolvedAttribute(tableNameExpression.source(), tableName, (String)message);
            } else {
                localRelation = this.tableMapAsRelation(source, tables.get(tableName));
            }
            return new Lookup(source, lookup.child(), tableNameExpression, lookup.matchFields(), localRelation);
        }

        private LocalRelation tableMapAsRelation(Source source, Map<String, Column> mapTable) {
            Block[] blocks = new Block[mapTable.size()];
            ArrayList<Attribute> attributes = new ArrayList<Attribute>(blocks.length);
            int i = 0;
            for (Map.Entry<String, Column> entry : mapTable.entrySet()) {
                String name = entry.getKey();
                Column column = entry.getValue();
                EsField field = new EsField(name, column.type(), Map.of(), false, false, EsField.TimeSeriesFieldType.UNKNOWN);
                attributes.add((Attribute)new FieldAttribute(source, null, null, name, field));
                blocks[i++] = column.values();
            }
            LocalSupplier supplier = LocalSupplier.of(blocks.length > 0 ? new Page(blocks) : new Page(0, new Block[0]));
            return new LocalRelation(source, attributes, supplier);
        }
    }

    private static class ResolveFunctions
    extends AnalyzerRules.ParameterizedAnalyzerRule<LogicalPlan, AnalyzerContext> {
        private ResolveFunctions() {
        }

        @Override
        protected LogicalPlan rule(LogicalPlan plan, AnalyzerContext context) {
            EsqlFunctionRegistry snapshotRegistry = context.functionRegistry().snapshotRegistry();
            return (LogicalPlan)((Object)plan.transformExpressionsOnly(UnresolvedFunction.class, uf -> ResolveFunctions.resolveFunction(uf, context.configuration(), snapshotRegistry)));
        }

        public static org.elasticsearch.xpack.esql.core.expression.function.Function resolveFunction(UnresolvedFunction uf, Configuration configuration, EsqlFunctionRegistry functionRegistry) {
            UnresolvedFunction f = null;
            if (uf.analyzed()) {
                f = uf;
            } else {
                String functionName = functionRegistry.resolveAlias(uf.name());
                if (!functionRegistry.functionExists(functionName)) {
                    f = uf.missing(functionName, functionRegistry.listFunctions());
                } else {
                    FunctionDefinition def = functionRegistry.resolveFunction(functionName);
                    f = uf.buildResolved(configuration, def);
                }
            }
            return f;
        }
    }

    private static class ResolveInference
    extends ParameterizedRule<LogicalPlan, LogicalPlan, AnalyzerContext> {
        private ResolveInference() {
        }

        @Override
        public LogicalPlan apply(LogicalPlan plan, AnalyzerContext context) {
            return (LogicalPlan)((Object)((LogicalPlan)plan.transformDown(InferencePlan.class, p -> this.resolveInferencePlan((InferencePlan<?>)p, context))).transformExpressionsOnly(InferenceFunction.class, f -> this.resolveInferenceFunction((InferenceFunction<?>)((Object)f), context)));
        }

        private LogicalPlan resolveInferencePlan(InferencePlan<?> plan, AnalyzerContext context) {
            assert (plan.inferenceId().resolved() && plan.inferenceId().foldable());
            String inferenceId = BytesRefs.toString((Object)plan.inferenceId().fold(FoldContext.small()));
            ResolvedInference resolvedInference = context.inferenceResolution().getResolvedInference(inferenceId);
            if (resolvedInference == null) {
                String error = context.inferenceResolution().getError(inferenceId);
                return plan.withInferenceResolutionError(inferenceId, error);
            }
            if (resolvedInference.taskType() != plan.taskType()) {
                String error = "cannot use inference endpoint [" + inferenceId + "] with task type [" + String.valueOf(resolvedInference.taskType()) + "] within a " + plan.nodeName() + " command. Only inference endpoints with the task type [" + String.valueOf(plan.taskType()) + "] are supported.";
                return plan.withInferenceResolutionError(inferenceId, error);
            }
            return plan;
        }

        private InferenceFunction<?> resolveInferenceFunction(InferenceFunction<?> inferenceFunction, AnalyzerContext context) {
            if (inferenceFunction.inferenceId().resolved() && inferenceFunction.inferenceId().foldable() && DataType.isString((DataType)inferenceFunction.inferenceId().dataType())) {
                String inferenceId = BytesRefs.toString((Object)inferenceFunction.inferenceId().fold(FoldContext.small()));
                ResolvedInference resolvedInference = context.inferenceResolution().getResolvedInference(inferenceId);
                if (resolvedInference == null) {
                    String error = context.inferenceResolution().getError(inferenceId);
                    return inferenceFunction.withInferenceResolutionError(inferenceId, error);
                }
                if (resolvedInference.taskType() != inferenceFunction.taskType()) {
                    String error = "cannot use inference endpoint [" + inferenceId + "] with task type [" + String.valueOf(resolvedInference.taskType()) + "] within a " + context.functionRegistry().snapshotRegistry().functionName(((Object)inferenceFunction).getClass()) + " function. Only inference endpoints with the task type [" + String.valueOf(inferenceFunction.taskType()) + "] are supported.";
                    return inferenceFunction.withInferenceResolutionError(inferenceId, error);
                }
            }
            return inferenceFunction;
        }
    }

    private static class DateMillisToNanosInEsRelation
    extends Rule<LogicalPlan, LogicalPlan> {
        private DateMillisToNanosInEsRelation() {
        }

        @Override
        public LogicalPlan apply(LogicalPlan plan) {
            return (LogicalPlan)plan.transformUp(EsRelation.class, relation -> {
                if (relation.indexMode() == IndexMode.LOOKUP) {
                    return relation;
                }
                return (LogicalPlan)((Object)((Object)relation.transformExpressionsUp(FieldAttribute.class, f -> {
                    InvalidMappedField imf;
                    EsField patt0$temp = f.field();
                    if (patt0$temp instanceof InvalidMappedField && (imf = (InvalidMappedField)patt0$temp).types().stream().allMatch(DataType::isDate)) {
                        HashMap<ResolveUnionTypes.TypeResolutionKey, Expression> typeResolutions = new HashMap<ResolveUnionTypes.TypeResolutionKey, Expression>();
                        ToDateNanos convert = new ToDateNanos(f.source(), (Expression)f);
                        imf.types().forEach(type -> Analyzer.typeResolutions(f, convert, type, imf, typeResolutions));
                        MultiTypeEsField resolvedField = ResolveUnionTypes.resolvedMultiTypeEsField(f, typeResolutions);
                        return new FieldAttribute(f.source(), f.parentName(), f.qualifier(), f.name(), (EsField)resolvedField, f.nullable(), f.id(), f.synthetic());
                    }
                    return f;
                })));
            });
        }
    }

    public static class ResolveRefs
    extends AnalyzerRules.ParameterizedAnalyzerRule<LogicalPlan, AnalyzerContext> {
        private static final DataType[] GEO_TYPES = new DataType[]{DataType.GEO_POINT, DataType.GEO_SHAPE};
        private static final DataType[] NON_GEO_TYPES = new DataType[]{DataType.KEYWORD, DataType.TEXT, DataType.IP, DataType.LONG, DataType.INTEGER, DataType.FLOAT, DataType.DOUBLE, DataType.DATETIME};

        @Override
        protected LogicalPlan rule(LogicalPlan plan, AnalyzerContext context) {
            if (!plan.childrenResolved()) {
                return plan;
            }
            ArrayList<Attribute> childrenOutput = new ArrayList<Attribute>();
            for (LogicalPlan child : plan.children()) {
                List<Attribute> output = child.output();
                childrenOutput.addAll(output);
            }
            LogicalPlan logicalPlan = plan;
            Objects.requireNonNull(logicalPlan);
            Object object = logicalPlan;
            int n = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Aggregate.class, Completion.class, Drop.class, Rename.class, Keep.class, Fork.class, Eval.class, Enrich.class, MvExpand.class, Lookup.class, LookupJoin.class, Insist.class, Fuse.class, Rerank.class}, object, n)) {
                case 0 -> {
                    Aggregate a = (Aggregate)object;
                    yield this.resolveAggregate(a, childrenOutput);
                }
                case 1 -> {
                    Completion c = (Completion)object;
                    yield this.resolveCompletion(c, childrenOutput);
                }
                case 2 -> {
                    Drop d = (Drop)object;
                    yield this.resolveDrop(d, childrenOutput);
                }
                case 3 -> {
                    Rename r = (Rename)object;
                    yield this.resolveRename(r, childrenOutput);
                }
                case 4 -> {
                    Keep p = (Keep)object;
                    yield this.resolveKeep(p, childrenOutput);
                }
                case 5 -> {
                    Fork f = (Fork)object;
                    yield this.resolveFork(f, context);
                }
                case 6 -> {
                    Eval p = (Eval)object;
                    yield this.resolveEval(p, childrenOutput);
                }
                case 7 -> {
                    Enrich p = (Enrich)object;
                    yield this.resolveEnrich(p, childrenOutput);
                }
                case 8 -> {
                    MvExpand p = (MvExpand)object;
                    yield this.resolveMvExpand(p, childrenOutput);
                }
                case 9 -> {
                    Lookup l = (Lookup)object;
                    yield this.resolveLookup(l, childrenOutput);
                }
                case 10 -> {
                    LookupJoin j = (LookupJoin)object;
                    yield this.resolveLookupJoin(j, context);
                }
                case 11 -> {
                    Insist i = (Insist)object;
                    yield this.resolveInsist(i, childrenOutput, context);
                }
                case 12 -> {
                    Fuse fuse = (Fuse)object;
                    yield this.resolveFuse(fuse, childrenOutput);
                }
                case 13 -> {
                    Rerank r = (Rerank)object;
                    yield this.resolveRerank(r, childrenOutput);
                }
                default -> (LogicalPlan)((Object)plan.transformExpressionsOnly(UnresolvedAttribute.class, ua -> this.maybeResolveAttribute((UnresolvedAttribute)ua, (List<Attribute>)childrenOutput)));
            };
        }

        private Aggregate resolveAggregate(Aggregate aggregate, List<Attribute> childrenOutput) {
            Holder changed = new Holder((Object)false);
            List<Expression> groupings = aggregate.groupings();
            List<? extends NamedExpression> aggregates = aggregate.aggregates();
            if (!Resolvables.resolved(groupings)) {
                ArrayList<Expression> newGroupings = new ArrayList<Expression>(groupings.size());
                for (Expression g : groupings) {
                    Expression resolved = (Expression)g.transformUp(UnresolvedAttribute.class, ua -> this.maybeResolveAttribute((UnresolvedAttribute)ua, childrenOutput));
                    if (resolved != g) {
                        changed.set((Object)true);
                    }
                    newGroupings.add(resolved);
                }
                groupings = newGroupings;
                if (((Boolean)changed.get()).booleanValue()) {
                    aggregate = aggregate.with(aggregate.child(), newGroupings, aggregate.aggregates());
                    changed.set((Object)false);
                }
            }
            if (!Resolvables.resolved(groupings) || !Resolvables.resolved(aggregates)) {
                ArrayList<Attribute> resolved = new ArrayList<Attribute>();
                for (Expression e : groupings) {
                    Attribute attr = Expressions.attribute((Expression)e);
                    if (attr == null || !attr.resolved()) continue;
                    resolved.add(attr);
                }
                List<Attribute> resolvedList = NamedExpressions.mergeOutputAttributes(resolved, childrenOutput);
                ArrayList<NamedExpression> newAggregates = new ArrayList<NamedExpression>();
                boolean groupingResolved = Resolvables.resolved(groupings);
                int size = groupingResolved ? aggregates.size() : aggregates.size() - groupings.size();
                for (int i = 0; i < aggregates.size(); ++i) {
                    NamedExpression maybeResolvedAgg = aggregates.get(i);
                    if (i < size) {
                        maybeResolvedAgg = (NamedExpression)maybeResolvedAgg.transformUp(UnresolvedAttribute.class, ua -> {
                            UnresolvedAttribute ne = ua;
                            Attribute maybeResolved = this.maybeResolveAttribute((UnresolvedAttribute)ua, resolvedList);
                            if (groupingResolved || maybeResolved.resolved()) {
                                changed.set((Object)true);
                                ne = maybeResolved;
                            }
                            return ne;
                        });
                    }
                    newAggregates.add(maybeResolvedAgg);
                }
                aggregate = (Boolean)changed.get() != false ? aggregate.with(aggregate.child(), groupings, newAggregates) : aggregate;
            }
            return aggregate;
        }

        private LogicalPlan resolveCompletion(Completion p, List<Attribute> childrenOutput) {
            Attribute targetField = p.targetField();
            Expression prompt = p.prompt();
            if (targetField instanceof UnresolvedAttribute) {
                UnresolvedAttribute ua2 = (UnresolvedAttribute)targetField;
                targetField = new ReferenceAttribute(ua2.source(), null, ua2.name(), DataType.KEYWORD);
            }
            if (!prompt.resolved()) {
                prompt = (Expression)prompt.transformUp(UnresolvedAttribute.class, ua -> this.maybeResolveAttribute((UnresolvedAttribute)ua, childrenOutput));
            }
            return new Completion(p.source(), p.child(), p.inferenceId(), prompt, targetField);
        }

        private LogicalPlan resolveMvExpand(MvExpand p, List<Attribute> childrenOutput) {
            NamedExpression namedExpression = p.target();
            if (namedExpression instanceof UnresolvedAttribute) {
                UnresolvedAttribute ua = (UnresolvedAttribute)namedExpression;
                Attribute resolved = this.maybeResolveAttribute(ua, childrenOutput);
                if (resolved == ua) {
                    return p;
                }
                return new MvExpand(p.source(), p.child(), (NamedExpression)resolved, (Attribute)(resolved.resolved() ? new ReferenceAttribute(resolved.source(), resolved.qualifier(), resolved.name(), resolved.dataType(), resolved.nullable(), null, false) : resolved));
            }
            return p;
        }

        private LogicalPlan resolveLookup(Lookup l, List<Attribute> childrenOutput) {
            if (l.localRelation() == null) {
                return l;
            }
            ArrayList<Attribute> matchFields = new ArrayList<Attribute>(l.matchFields().size());
            List<Attribute> localOutput = l.localRelation().output();
            boolean modified = false;
            Iterator<Attribute> iterator = l.matchFields().iterator();
            while (iterator.hasNext()) {
                UnresolvedAttribute ua;
                Attribute matchField;
                Attribute matchFieldChildReference = matchField = iterator.next();
                if (matchField instanceof UnresolvedAttribute && !(ua = (UnresolvedAttribute)matchField).customMessage()) {
                    modified = true;
                    Attribute joinedAttribute = this.maybeResolveAttribute(ua, localOutput);
                    if (joinedAttribute instanceof UnresolvedAttribute) {
                        UnresolvedAttribute lua = (UnresolvedAttribute)joinedAttribute;
                        matchFieldChildReference = lua.withUnresolvedMessage(lua.unresolvedMessage().replace("Unknown column", "Unknown column in lookup target"));
                    } else {
                        Attribute attr;
                        matchFieldChildReference = attr = this.maybeResolveAttribute(ua, childrenOutput);
                        if (!(attr instanceof UnresolvedAttribute)) {
                            boolean dataTypesOk = joinedAttribute.dataType().equals((Object)attr.dataType());
                            if (!dataTypesOk) {
                                boolean bl = dataTypesOk = joinedAttribute.dataType() == DataType.NULL || attr.dataType() == DataType.NULL;
                            }
                            if (!dataTypesOk) {
                                boolean bl = dataTypesOk = joinedAttribute.dataType().equals((Object)DataType.KEYWORD) && attr.dataType().equals((Object)DataType.TEXT);
                            }
                            if (!dataTypesOk) {
                                matchFieldChildReference = new UnresolvedAttribute(attr.source(), attr.name(), attr.id(), "column type mismatch, table column was [" + joinedAttribute.dataType().typeName() + "] and original column was [" + attr.dataType().typeName() + "]");
                            }
                        }
                    }
                }
                matchFields.add(matchFieldChildReference);
            }
            if (modified) {
                return new Lookup(l.source(), l.child(), l.tableName(), matchFields, l.localRelation());
            }
            return l;
        }

        private Expression resolveJoinFiltersAndSwapIfNeeded(Expression joinOnCondition, AttributeSet leftChildOutput, AttributeSet rightChildOutput, List<Attribute> leftJoinKeysToPopulate, List<Attribute> rightJoinKeysToPopulate, AnalyzerContext context) {
            if (joinOnCondition == null) {
                return joinOnCondition;
            }
            List<Expression> filters = Predicates.splitAnd(joinOnCondition);
            ArrayList childrenOutput = new ArrayList(leftChildOutput);
            childrenOutput.addAll(rightChildOutput);
            ArrayList<Expression> resolvedFilters = new ArrayList<Expression>(filters.size());
            for (Expression filter : filters) {
                Expression filterResolved = (Expression)filter.transformUp(UnresolvedAttribute.class, ua -> this.maybeResolveAttribute((UnresolvedAttribute)ua, childrenOutput));
                if (filterResolved.anyMatch(UnresolvedAttribute.class::isInstance)) {
                    resolvedFilters.add(filterResolved);
                    continue;
                }
                Expression result = this.resolveAndOrientJoinCondition(filterResolved, leftChildOutput, rightChildOutput, leftJoinKeysToPopulate, rightJoinKeysToPopulate, context);
                resolvedFilters.add(result);
            }
            return Predicates.combineAndWithSource(resolvedFilters, joinOnCondition.source());
        }

        private Expression resolveAndOrientJoinCondition(Expression condition, AttributeSet leftChildOutput, AttributeSet rightChildOutput, List<Attribute> leftJoinKeysToPopulate, List<Attribute> rightJoinKeysToPopulate, AnalyzerContext context) {
            EsqlBinaryComparison comp;
            Expression expression;
            if (condition instanceof EsqlBinaryComparison && (expression = (comp = (EsqlBinaryComparison)condition).left()) instanceof Attribute) {
                Attribute leftAttr = (Attribute)expression;
                expression = comp.right();
                if (expression instanceof Attribute) {
                    Attribute rightAttr = (Attribute)expression;
                    boolean leftIsFromLeft = leftChildOutput.contains((Object)leftAttr);
                    boolean rightIsFromRight = rightChildOutput.contains((Object)rightAttr);
                    if (leftIsFromLeft && rightIsFromRight) {
                        leftJoinKeysToPopulate.add(leftAttr);
                        rightJoinKeysToPopulate.add(rightAttr);
                        return comp;
                    }
                    boolean leftIsFromRight = rightChildOutput.contains((Object)leftAttr);
                    boolean rightIsFromLeft = leftChildOutput.contains((Object)rightAttr);
                    if (leftIsFromRight && rightIsFromLeft) {
                        leftJoinKeysToPopulate.add(rightAttr);
                        rightJoinKeysToPopulate.add(leftAttr);
                        return comp.swapLeftAndRight();
                    }
                }
            }
            if (!context.minimumVersion().onOrAfter((VersionId)ESQL_LOOKUP_JOIN_FULL_TEXT_FUNCTION)) {
                return new UnresolvedAttribute(condition.source(), "unsupported", "Lookup join on condition is not supported on the remote node, consider upgrading the remote node. Unsupported join filter expression:" + condition.sourceText());
            }
            return this.handleRightOnlyPushableFilter(condition, rightChildOutput);
        }

        private Expression handleRightOnlyPushableFilter(Expression condition, AttributeSet rightChildOutput) {
            if (this.isCompletelyRightSideAndTranslatable(condition, rightChildOutput)) {
                return condition;
            }
            return new UnresolvedAttribute(condition.source(), "unsupported", "Unsupported join filter expression:" + condition.sourceText());
        }

        private Join resolveLookupJoin(LookupJoin join, AnalyzerContext context) {
            JoinConfig config = join.config();
            JoinType type = config.type();
            if (type == JoinTypes.LEFT) {
                if (Expressions.anyMatch(join.references().stream().toList(), c -> {
                    UnresolvedAttribute ua;
                    return c instanceof UnresolvedAttribute && (ua = (UnresolvedAttribute)c).customMessage();
                })) {
                    return join;
                }
                ArrayList<Attribute> leftKeys = new ArrayList();
                List<Attribute> rightKeys = new ArrayList<Attribute>();
                Expression joinOnConditions = null;
                if (join.config().joinOnConditions() != null) {
                    joinOnConditions = this.resolveJoinFiltersAndSwapIfNeeded(join.config().joinOnConditions(), join.left().outputSet(), join.right().outputSet(), leftKeys, rightKeys, context);
                } else {
                    leftKeys = this.resolveUsingColumns(join.config().leftFields(), join.left().output(), "left");
                    rightKeys = this.resolveUsingColumns(join.config().rightFields(), join.right().output(), "right");
                }
                config = new JoinConfig(type, leftKeys, rightKeys, joinOnConditions);
                return new LookupJoin(join.source(), join.left(), join.right(), config, join.isRemote());
            }
            UnresolvedAttribute errorAttribute = new UnresolvedAttribute(join.source(), "unsupported", "Unsupported join type");
            return join.withConfig(new JoinConfig(type, Collections.singletonList(errorAttribute), Collections.emptyList(), null));
        }

        private boolean isCompletelyRightSideAndTranslatable(Expression expression, AttributeSet rightOutputSet) {
            return rightOutputSet.containsAll((Collection)expression.references()) && this.isTranslatable(expression);
        }

        private boolean isTranslatable(Expression expression) {
            return TranslationAware.translatable(expression, LucenePushdownPredicates.DEFAULT) != TranslationAware.Translatable.NO;
        }

        private LogicalPlan resolveFork(Fork fork, AnalyzerContext context) {
            boolean changed = false;
            ArrayList<LogicalPlan> newSubPlans = new ArrayList<LogicalPlan>();
            List<Attribute> outputUnion = Fork.outputUnion(fork.children());
            List<String> forkColumns = outputUnion.stream().map(NamedExpression::name).toList();
            Set<String> unsupportedAttributeNames = Fork.outputUnsupportedAttributeNames(fork.children());
            for (LogicalPlan logicalPlan : fork.children()) {
                Source source = logicalPlan.source();
                ArrayList<Attribute> missing = new ArrayList<Attribute>();
                Set currentNames = logicalPlan.outputSet().names();
                for (Attribute attr2 : outputUnion) {
                    if (currentNames.contains(attr2.name())) continue;
                    missing.add(attr2);
                }
                List<Alias> aliases = missing.stream().map(attr -> {
                    DataType attrType;
                    DataType dataType = attrType = attr.dataType() == DataType.UNSUPPORTED ? DataType.KEYWORD : attr.dataType();
                    if (attrType.isCounter()) {
                        attrType = attrType.noCounter();
                    }
                    return new Alias(source, attr.name(), (Expression)new Literal(source, null, attrType));
                }).toList();
                if (aliases.size() > 0) {
                    logicalPlan = new Eval(source, logicalPlan, aliases);
                    changed = true;
                }
                List<String> subPlanColumns = logicalPlan.output().stream().map(NamedExpression::name).toList();
                if (!(logicalPlan instanceof Project) || !subPlanColumns.equals(forkColumns)) {
                    changed = true;
                    ArrayList<Attribute> newOutput = new ArrayList<Attribute>();
                    for (String attrName : forkColumns) {
                        for (Attribute subAttr : logicalPlan.output()) {
                            if (!attrName.equals(subAttr.name())) continue;
                            newOutput.add(subAttr);
                        }
                    }
                    logicalPlan = this.resolveKeep(new Keep(logicalPlan.source(), logicalPlan, newOutput), logicalPlan.output());
                }
                newSubPlans.add(logicalPlan);
            }
            if (!changed) {
                return fork;
            }
            ArrayList<Attribute> newOutput = new ArrayList<Attribute>();
            for (Attribute attr3 : outputUnion) {
                newOutput.add((Attribute)new ReferenceAttribute(attr3.source(), null, attr3.name(), attr3.dataType(), Nullability.FALSE, null, attr3.synthetic()));
            }
            return fork.replaceSubPlansAndOutput(newSubPlans, newOutput);
        }

        private LogicalPlan resolveRerank(Rerank rerank, List<Attribute> childrenOutput) {
            Alias field2;
            ArrayList<Alias> newFields = new ArrayList<Alias>();
            boolean changed = false;
            boolean castRerankFieldsAsString = rerank.rerankFields().size() < 2;
            for (Alias field2 : rerank.rerankFields()) {
                Alias resolved = (Alias)field2.transformUp(UnresolvedAttribute.class, ua -> this.resolveAttribute((UnresolvedAttribute)ua, childrenOutput));
                if (resolved.resolved() && castRerankFieldsAsString && rerank.isValidRerankField(resolved) && !DataType.isString((DataType)resolved.dataType())) {
                    resolved = resolved.replaceChild((Expression)new ToString(resolved.child().source(), resolved.child()));
                }
                newFields.add(resolved);
                changed |= resolved != field2;
            }
            if (changed) {
                rerank = rerank.withRerankFields(newFields);
            }
            if ((field2 = rerank.scoreAttribute()) instanceof UnresolvedAttribute) {
                UnresolvedAttribute ua2 = (UnresolvedAttribute)field2;
                Object resolved = this.resolveAttribute(ua2, childrenOutput);
                if (!resolved.resolved() || resolved.dataType() != DataType.DOUBLE) {
                    resolved = ua2.name().equals("_score") ? MetadataAttribute.create((Source)Source.EMPTY, (String)"_score") : new ReferenceAttribute(resolved.source(), null, resolved.name(), DataType.DOUBLE);
                }
                rerank = rerank.withScoreAttribute((Attribute)resolved);
            }
            return rerank;
        }

        private List<Attribute> resolveUsingColumns(List<Attribute> cols, List<Attribute> output, String side) {
            ArrayList<Attribute> resolved = new ArrayList<Attribute>(cols.size());
            for (Attribute col : cols) {
                if (col instanceof UnresolvedAttribute) {
                    UnresolvedAttribute ua = (UnresolvedAttribute)col;
                    Attribute resolvedField = this.maybeResolveAttribute(ua, output);
                    if (resolvedField instanceof UnresolvedAttribute) {
                        UnresolvedAttribute ucol = (UnresolvedAttribute)resolvedField;
                        String message = ua.unresolvedMessage();
                        String match = "column [" + ucol.name() + "]";
                        resolvedField = ucol.withUnresolvedMessage(message.replace(match, match + " in " + side + " side of join"));
                    }
                    resolved.add(resolvedField);
                    continue;
                }
                throw new IllegalStateException("Surprised to discover column [ " + col.name() + "] already resolved when resolving JOIN keys");
            }
            return resolved;
        }

        private LogicalPlan resolveInsist(Insist insist, List<Attribute> childrenOutput, AnalyzerContext context) {
            ArrayList<Attribute> list = new ArrayList<Attribute>();
            List<IndexResolution> resolutions = this.collectIndexResolutions(insist, context);
            for (Attribute attribute : insist.insistedAttributes()) {
                list.add(this.resolveInsistAttribute(attribute, childrenOutput, resolutions));
            }
            return insist.withAttributes(list);
        }

        private List<IndexResolution> collectIndexResolutions(LogicalPlan plan, AnalyzerContext context) {
            ArrayList<IndexResolution> resolutions = new ArrayList<IndexResolution>();
            plan.forEachDown(EsRelation.class, e -> {
                IndexResolution resolution = context.indexResolution().get(new IndexPattern(e.source(), e.indexPattern()));
                if (resolution != null) {
                    resolutions.add(resolution);
                }
            });
            return resolutions;
        }

        private Attribute resolveInsistAttribute(Attribute attribute, List<Attribute> childrenOutput, List<IndexResolution> indices) {
            Attribute resolvedCol = this.maybeResolveAttribute((UnresolvedAttribute)attribute, childrenOutput);
            if (resolvedCol instanceof UnresolvedAttribute) {
                return ResolveRefs.insistKeyword(attribute);
            }
            if (resolvedCol instanceof FieldAttribute) {
                FieldAttribute fa = (FieldAttribute)resolvedCol;
                if (indices.stream().anyMatch(r -> r.get().isPartiallyUnmappedField(fa.name()))) {
                    return fa.dataType() == DataType.KEYWORD ? ResolveRefs.insistKeyword((Attribute)fa) : ResolveRefs.invalidInsistAttribute(fa);
                }
            }
            return resolvedCol;
        }

        private static Attribute invalidInsistAttribute(FieldAttribute fa) {
            InvalidMappedField invalidMappedField;
            String name = fa.name();
            EsField esField = fa.field();
            if (esField instanceof InvalidMappedField) {
                InvalidMappedField imf = (InvalidMappedField)esField;
                invalidMappedField = new InvalidMappedField(name, InvalidMappedField.makeErrorsMessageIncludingInsistKeyword((Map)imf.getTypesToIndices()));
            } else {
                invalidMappedField = new InvalidMappedField(name, Strings.format((String)"mapped as [2] incompatible types: [keyword] enforced by INSIST command, and [%s] in index mappings", (Object[])new Object[]{fa.dataType().typeName()}));
            }
            InvalidMappedField field = invalidMappedField;
            return new FieldAttribute(fa.source(), null, fa.qualifier(), name, (EsField)field);
        }

        private static FieldAttribute insistKeyword(Attribute attribute) {
            return new FieldAttribute(attribute.source(), null, attribute.qualifier(), attribute.name(), (EsField)new PotentiallyUnmappedKeywordEsField(attribute.name()));
        }

        private LogicalPlan resolveFuse(Fuse fuse, List<Attribute> childrenOutput) {
            Attribute discriminator;
            Source source = fuse.source();
            Attribute score = fuse.score();
            if (score instanceof UnresolvedAttribute) {
                score = this.maybeResolveAttribute((UnresolvedAttribute)score, childrenOutput);
            }
            if ((discriminator = fuse.discriminator()) instanceof UnresolvedAttribute) {
                discriminator = this.maybeResolveAttribute((UnresolvedAttribute)discriminator, childrenOutput);
            }
            List<NamedExpression> keys = fuse.keys().stream().map(attr -> attr instanceof UnresolvedAttribute ? this.maybeResolveAttribute((UnresolvedAttribute)attr, childrenOutput) : attr).toList();
            if (score instanceof UnresolvedAttribute || score.resolved() && score.dataType() != DataType.DOUBLE || discriminator instanceof UnresolvedAttribute || discriminator.resolved() && !DataType.isString((DataType)discriminator.dataType()) || !keys.stream().allMatch(attr -> attr.resolved() && DataType.isString((DataType)attr.dataType()))) {
                return new Fuse(fuse.source(), fuse.child(), score, discriminator, keys, fuse.fuseType(), fuse.options());
            }
            FuseScoreEval scoreEval = new FuseScoreEval(source, fuse.child(), score, discriminator, fuse.fuseType(), fuse.options());
            Literal aggFilter = new Literal(source, (Object)true, DataType.BOOLEAN);
            ArrayList<Alias> aggregates = new ArrayList<Alias>();
            aggregates.add(new Alias(source, score.name(), (Expression)new Sum(source, (Expression)score, (Expression)aggFilter, (Expression)AggregateFunction.NO_WINDOW, (Expression)SummationMode.COMPENSATED_LITERAL)));
            for (Attribute attr2 : childrenOutput) {
                Values valuesAgg;
                if (attr2.name().equals(score.name()) || !(valuesAgg = new Values(source, (Expression)attr2, (Expression)aggFilter, (Expression)AggregateFunction.NO_WINDOW)).resolved()) continue;
                aggregates.add(new Alias(source, attr2.name(), (Expression)valuesAgg));
            }
            return this.resolveAggregate(new Aggregate(source, scoreEval, new ArrayList<NamedExpression>(keys), aggregates), childrenOutput);
        }

        private Attribute maybeResolveAttribute(UnresolvedAttribute ua, List<Attribute> childrenOutput) {
            return ResolveRefs.maybeResolveAttribute(ua, childrenOutput, this.log);
        }

        private static Attribute maybeResolveAttribute(UnresolvedAttribute ua, List<Attribute> childrenOutput, Logger logger) {
            if (ua.customMessage()) {
                return ua;
            }
            return ResolveRefs.resolveAttribute(ua, childrenOutput, logger);
        }

        private Attribute resolveAttribute(UnresolvedAttribute ua, List<Attribute> childrenOutput) {
            return ResolveRefs.resolveAttribute(ua, childrenOutput, this.log);
        }

        private static Attribute resolveAttribute(UnresolvedAttribute ua, List<Attribute> childrenOutput, Logger logger) {
            UnresolvedAttribute resolved = ua;
            List<Attribute> named = Analyzer.resolveAgainstList(ua, childrenOutput);
            if (named.size() == 1) {
                resolved = named.get(0);
                if (logger != null && logger.isTraceEnabled() && resolved.resolved()) {
                    logger.trace("Resolved {} to {}", new Object[]{ua, resolved});
                }
            } else if (named.size() > 0) {
                resolved = ua.withUnresolvedMessage("Resolved [" + String.valueOf(ua) + "] unexpectedly to multiple attributes " + String.valueOf(named));
            }
            return resolved;
        }

        private LogicalPlan resolveEval(Eval eval, List<Attribute> childOutput) {
            ArrayList<Attribute> allResolvedInputs = new ArrayList<Attribute>(childOutput);
            ArrayList<Alias> newFields = new ArrayList<Alias>();
            boolean changed = false;
            for (Alias field : eval.fields()) {
                Alias result = (Alias)field.transformUp(UnresolvedAttribute.class, ua -> this.resolveAttribute((UnresolvedAttribute)ua, (List<Attribute>)allResolvedInputs));
                changed |= result != field;
                newFields.add(result);
                if (!result.resolved()) continue;
                Attribute existing = allResolvedInputs.stream().filter(attr -> attr.name().equals(result.name())).findFirst().orElse(null);
                if (existing != null) {
                    allResolvedInputs.remove(existing);
                }
                allResolvedInputs.add(result.toAttribute());
            }
            return changed ? new Eval(eval.source(), eval.child(), newFields) : eval;
        }

        private LogicalPlan resolveKeep(Project p, List<Attribute> childOutput) {
            ArrayList<Object> resolvedProjections = new ArrayList<Attribute>();
            List<? extends NamedExpression> projections = p.projections();
            if (projections.isEmpty() || projections.size() == 1 && projections.get(0) instanceof UnresolvedStar) {
                resolvedProjections.addAll(childOutput);
            } else {
                LinkedHashMap<Attribute, Integer> priorities = new LinkedHashMap<Attribute, Integer>();
                for (NamedExpression namedExpression : projections) {
                    int priority;
                    List<Attribute> resolved;
                    if (namedExpression instanceof UnresolvedStar) {
                        resolved = childOutput;
                        priority = 4;
                    } else if (namedExpression instanceof UnresolvedNamePattern) {
                        UnresolvedNamePattern up = (UnresolvedNamePattern)namedExpression;
                        resolved = Analyzer.resolveAgainstList(up, childOutput);
                        priority = 3;
                    } else if (namedExpression instanceof UnsupportedAttribute) {
                        resolved = List.of(namedExpression.toAttribute());
                        priority = 2;
                    } else if (namedExpression instanceof UnresolvedAttribute) {
                        UnresolvedAttribute ua = (UnresolvedAttribute)namedExpression;
                        resolved = Analyzer.resolveAgainstList(ua, childOutput);
                        priority = 1;
                    } else if (namedExpression.resolved()) {
                        resolved = List.of(namedExpression.toAttribute());
                        priority = 0;
                    } else {
                        throw new EsqlIllegalArgumentException("unexpected projection: " + String.valueOf(namedExpression));
                    }
                    for (Attribute attr : resolved) {
                        Integer previousPrio = (Integer)priorities.get(attr);
                        if (previousPrio != null && previousPrio < priority) continue;
                        priorities.remove(attr);
                        priorities.put(attr, priority);
                    }
                }
                resolvedProjections = new ArrayList(priorities.keySet());
            }
            return new EsqlProject(p.source(), p.child(), resolvedProjections);
        }

        private LogicalPlan resolveDrop(Drop drop, List<Attribute> childOutput) {
            ArrayList<Attribute> resolvedProjections = new ArrayList<Attribute>(childOutput);
            for (NamedExpression ne : drop.removals()) {
                List<NamedExpression> resolved;
                if (ne instanceof UnresolvedNamePattern) {
                    UnresolvedNamePattern np = (UnresolvedNamePattern)ne;
                    resolved = Analyzer.resolveAgainstList(np, childOutput);
                } else if (ne instanceof UnresolvedAttribute) {
                    UnresolvedAttribute ua = (UnresolvedAttribute)ne;
                    resolved = Analyzer.resolveAgainstList(ua, childOutput);
                } else {
                    resolved = Collections.singletonList(ne);
                }
                resolvedProjections.removeIf(resolved::contains);
                resolved.forEach(r -> {
                    if (!r.resolved() && !(r instanceof UnsupportedAttribute)) {
                        resolvedProjections.add((Attribute)r);
                    }
                });
            }
            return new EsqlProject(drop.source(), drop.child(), resolvedProjections);
        }

        private LogicalPlan resolveRename(Rename rename, List<Attribute> childrenOutput) {
            List<NamedExpression> projections = ResolveRefs.projectionsForRename(rename, childrenOutput, this.log);
            return new EsqlProject(rename.source(), rename.child(), projections);
        }

        public static List<NamedExpression> projectionsForRename(Rename rename, List<Attribute> childrenOutput, Logger logger) {
            ArrayList<Attribute> projections = new ArrayList<Attribute>(childrenOutput);
            int renamingsCount = rename.renamings().size();
            ArrayList unresolved = new ArrayList(renamingsCount);
            HashMap reverseAliasing = new HashMap(renamingsCount);
            rename.renamings().forEach(alias -> {
                Expression patt0$temp = alias.child();
                if (patt0$temp instanceof UnresolvedAttribute) {
                    UnresolvedAttribute ua = (UnresolvedAttribute)patt0$temp;
                    if (!alias.name().equals(ua.name())) {
                        projections.removeIf(x -> x.name().equals(alias.name()));
                        childrenOutput.removeIf(x -> x.name().equals(alias.name()));
                        Attribute resolved = ResolveRefs.maybeResolveAttribute(ua, childrenOutput, logger);
                        if (resolved instanceof UnsupportedAttribute || resolved.resolved()) {
                            Alias realiased = alias.replaceChildren(List.of(resolved));
                            projections.replaceAll(arg_0 -> ResolveRefs.lambda$projectionsForRename$17(resolved, (NamedExpression)realiased, arg_0));
                            childrenOutput.removeIf(x -> x.equals((Object)resolved));
                            reverseAliasing.put(resolved.name(), alias.name());
                        } else {
                            boolean updated = false;
                            if (reverseAliasing.containsValue(resolved.name())) {
                                ListIterator<Alias> li = projections.listIterator();
                                while (li.hasNext()) {
                                    Alias a;
                                    Object patt1$temp = li.next();
                                    if (!(patt1$temp instanceof Alias) || !(a = (Alias)patt1$temp).name().equals(resolved.name())) continue;
                                    reverseAliasing.put(resolved.name(), alias.name());
                                    li.set(alias.replaceChildren(a.children()));
                                    updated = true;
                                    break;
                                }
                            }
                            if (!updated) {
                                Attribute u = resolved;
                                String previousAliasName = (String)reverseAliasing.get(resolved.name());
                                if (previousAliasName != null) {
                                    String message = LoggerMessageFormat.format(null, (String)"Column [{}] renamed to [{}] and is no longer available [{}]", (Object[])new Object[]{resolved.name(), previousAliasName, alias.sourceText()});
                                    u = ua.withUnresolvedMessage(message);
                                }
                                unresolved.add(u);
                            }
                        }
                    }
                }
            });
            projections.addAll(unresolved);
            return projections;
        }

        private LogicalPlan resolveEnrich(Enrich enrich, List<Attribute> childrenOutput) {
            Attribute attribute = enrich.matchField().toAttribute();
            if (attribute instanceof UnresolvedAttribute) {
                UnresolvedAttribute ua = (UnresolvedAttribute)attribute;
                Attribute resolved = this.maybeResolveAttribute(ua, childrenOutput);
                if (resolved.equals((Object)ua)) {
                    return enrich;
                }
                if (resolved.resolved() && enrich.policy() != null) {
                    DataType dataType = resolved.dataType();
                    String matchType = enrich.policy().getType();
                    DataType[] allowed = this.allowedEnrichTypes(matchType);
                    if (!Arrays.asList(allowed).contains(dataType)) {
                        String suffix = "only [" + Arrays.stream(allowed).map(DataType::typeName).collect(Collectors.joining(", ")) + "] allowed for type [" + matchType + "]";
                        resolved = ua.withUnresolvedMessage("Unsupported type [" + resolved.dataType().typeName() + "] for enrich matching field [" + ua.name() + "]; " + suffix);
                    }
                }
                return new Enrich(enrich.source(), enrich.child(), enrich.mode(), enrich.policyName(), (NamedExpression)resolved, enrich.policy(), enrich.concreteIndices(), enrich.enrichFields());
            }
            return enrich;
        }

        private DataType[] allowedEnrichTypes(String matchType) {
            return matchType.equals("geo_match") ? GEO_TYPES : NON_GEO_TYPES;
        }

        private static /* synthetic */ NamedExpression lambda$projectionsForRename$17(Attribute resolved, NamedExpression realiased, NamedExpression x) {
            return x.equals((Object)resolved) ? realiased : x;
        }
    }

    private static class ImplicitCasting
    extends ParameterizedRule<LogicalPlan, LogicalPlan, AnalyzerContext> {
        private ImplicitCasting() {
        }

        @Override
        public LogicalPlan apply(LogicalPlan plan, AnalyzerContext context) {
            return (LogicalPlan)((Object)plan.transformExpressionsUp(org.elasticsearch.xpack.esql.core.expression.function.Function.class, e -> ImplicitCasting.cast(e, context.functionRegistry().snapshotRegistry())));
        }

        private static Expression cast(org.elasticsearch.xpack.esql.core.expression.function.Function f, EsqlFunctionRegistry registry) {
            if (f instanceof In) {
                In in = (In)f;
                return ImplicitCasting.processIn(in);
            }
            if (f instanceof VectorFunction) {
                return ImplicitCasting.processVectorFunction(f, registry);
            }
            if (f instanceof EsqlScalarFunction || f instanceof GroupingFunction) {
                return ImplicitCasting.processScalarOrGroupingFunction(f, registry);
            }
            if (f instanceof EsqlArithmeticOperation || f instanceof BinaryComparison) {
                return ImplicitCasting.processBinaryOperator((BinaryOperator)f);
            }
            return f;
        }

        private static Expression processScalarOrGroupingFunction(org.elasticsearch.xpack.esql.core.expression.function.Function f, EsqlFunctionRegistry registry) {
            List args = f.arguments();
            List<DataType> targetDataTypes = registry.getDataTypeForStringLiteralConversion(f.getClass());
            if (targetDataTypes == null || targetDataTypes.isEmpty()) {
                return f;
            }
            ArrayList<Expression> newChildren = new ArrayList<Expression>(args.size());
            boolean childrenChanged = false;
            DataType targetDataType = DataType.NULL;
            DataType targetNumericType = null;
            boolean castNumericArgs = true;
            for (int i = 0; i < args.size(); ++i) {
                Expression arg = (Expression)args.get(i);
                if (arg.resolved()) {
                    DataType dataType = arg.dataType();
                    if (dataType == DataType.KEYWORD) {
                        if (arg.foldable() && !(arg instanceof EsqlScalarFunction)) {
                            Expression e;
                            if (i < targetDataTypes.size()) {
                                targetDataType = targetDataTypes.get(i);
                            }
                            if (targetDataType != DataType.NULL && targetDataType != DataType.UNSUPPORTED && (e = ImplicitCasting.castStringLiteral(arg, targetDataType)) != arg) {
                                childrenChanged = true;
                                newChildren.add(e);
                                continue;
                            }
                        }
                    } else if (dataType.isNumeric() && ImplicitCasting.canCastMixedNumericTypes(f) && castNumericArgs) {
                        if (targetNumericType == null) {
                            targetNumericType = dataType;
                        } else if (dataType != targetNumericType) {
                            castNumericArgs = ImplicitCasting.canCastNumeric(dataType, targetNumericType);
                        }
                    }
                }
                newChildren.add((Expression)args.get(i));
            }
            org.elasticsearch.xpack.esql.core.expression.function.Function resultF = childrenChanged ? (Expression)f.replaceChildren(newChildren) : f;
            return targetNumericType != null && castNumericArgs ? ImplicitCasting.castMixedNumericTypes((EsqlScalarFunction)resultF, targetNumericType) : resultF;
        }

        private static Expression processBinaryOperator(BinaryOperator<?, ?, ?, ?> o) {
            Expression left = o.left();
            Expression right = o.right();
            if (!left.resolved() || !right.resolved()) {
                return o;
            }
            ArrayList<Expression> newChildren = new ArrayList<Expression>(2);
            boolean childrenChanged = false;
            DataType targetDataType = DataType.NULL;
            Literal from = Literal.NULL;
            if (left.dataType() == DataType.KEYWORD && left.foldable() && !(left instanceof EsqlScalarFunction)) {
                if (ImplicitCasting.supportsStringImplicitCasting(right.dataType())) {
                    targetDataType = right.dataType();
                    from = left;
                } else if (ImplicitCasting.supportsImplicitTemporalCasting(right, o)) {
                    targetDataType = DataType.DATETIME;
                    from = left;
                }
            }
            if (right.dataType() == DataType.KEYWORD && right.foldable() && !(right instanceof EsqlScalarFunction)) {
                if (ImplicitCasting.supportsStringImplicitCasting(left.dataType())) {
                    targetDataType = left.dataType();
                    from = right;
                } else if (ImplicitCasting.supportsImplicitTemporalCasting(left, o)) {
                    targetDataType = DataType.DATETIME;
                    from = right;
                }
            }
            if (from != Literal.NULL) {
                Expression e = ImplicitCasting.castStringLiteral((Expression)from, targetDataType);
                newChildren.add(from == left ? e : left);
                newChildren.add(from == right ? e : right);
                childrenChanged = true;
            }
            return childrenChanged ? o.replaceChildren(newChildren) : o;
        }

        private static Expression processIn(In in) {
            Expression left = in.value();
            List<Expression> right = in.list();
            if (!left.resolved() || !ImplicitCasting.supportsStringImplicitCasting(left.dataType())) {
                return in;
            }
            DataType targetDataType = left.dataType();
            ArrayList<Expression> newChildren = new ArrayList<Expression>(right.size() + 1);
            boolean childrenChanged = false;
            for (Expression value : right) {
                if (value.resolved() && value.dataType() == DataType.KEYWORD && value.foldable()) {
                    Expression e = ImplicitCasting.castStringLiteral(value, targetDataType);
                    newChildren.add(e);
                    childrenChanged = true;
                    continue;
                }
                newChildren.add(value);
            }
            newChildren.add(left);
            return childrenChanged ? in.replaceChildren(newChildren) : in;
        }

        private static boolean canCastMixedNumericTypes(org.elasticsearch.xpack.esql.core.expression.function.Function f) {
            return f instanceof Coalesce || f instanceof Case || f instanceof Greatest || f instanceof Least;
        }

        private static boolean canCastNumeric(DataType from, DataType to) {
            DataType commonType = EsqlDataTypeConverter.commonType(from, to);
            return commonType == to;
        }

        private static Expression castMixedNumericTypes(EsqlScalarFunction f, DataType targetNumericType) {
            ArrayList<Object> newChildren = new ArrayList<Object>(f.children().size());
            boolean childrenChanged = false;
            block6: for (Expression e : f.children()) {
                if (e.resolved()) {
                    DataType childDataType = e.dataType();
                    if (!childDataType.isNumeric() || childDataType == targetNumericType || !ImplicitCasting.canCastNumeric(childDataType, targetNumericType)) {
                        newChildren.add(e);
                        continue;
                    }
                    childrenChanged = true;
                    switch (targetNumericType) {
                        case INTEGER: {
                            newChildren.add(new ToInteger(e.source(), e));
                            continue block6;
                        }
                        case LONG: {
                            newChildren.add(new ToLong(e.source(), e));
                            continue block6;
                        }
                        case DOUBLE: {
                            newChildren.add(new ToDouble(e.source(), e));
                            continue block6;
                        }
                        case UNSIGNED_LONG: {
                            newChildren.add(new ToUnsignedLong(e.source(), e));
                            continue block6;
                        }
                    }
                    throw new EsqlIllegalArgumentException("unexpected data type: " + String.valueOf(targetNumericType));
                }
                newChildren.add(e);
            }
            return childrenChanged ? (Expression)f.replaceChildren(newChildren) : f;
        }

        private static boolean supportsImplicitTemporalCasting(Expression e, BinaryOperator<?, ?, ?, ?> o) {
            return DataType.isTemporalAmount((DataType)e.dataType()) && o instanceof DateTimeArithmeticOperation;
        }

        private static boolean supportsStringImplicitCasting(DataType type) {
            return type == DataType.DATETIME || type == DataType.DATE_NANOS || type == DataType.IP || type == DataType.VERSION || type == DataType.BOOLEAN;
        }

        private static UnresolvedAttribute unresolvedAttribute(Expression value, String type, Exception e) {
            String string;
            String name = BytesRefs.toString((Object)value.fold(FoldContext.small()));
            Object[] objectArray = new Object[3];
            objectArray[0] = name;
            objectArray[1] = type;
            if (e instanceof ParsingException) {
                ParsingException pe = (ParsingException)((Object)e);
                string = pe.getErrorMessage();
            } else {
                string = e.getMessage();
            }
            objectArray[2] = string;
            String message = LoggerMessageFormat.format(null, (String)"Cannot convert string [{}] to [{}], error [{}]", (Object[])objectArray);
            return new UnresolvedAttribute(value.source(), name, message);
        }

        private static Expression castStringLiteralToTemporalAmount(Expression from) {
            try {
                TemporalAmount result = EsqlDataTypeConverter.maybeParseTemporalAmount(BytesRefs.toString((Object)from.fold(FoldContext.small())).strip());
                if (result == null) {
                    return from;
                }
                DataType target = result instanceof Duration ? DataType.TIME_DURATION : DataType.DATE_PERIOD;
                return new Literal(from.source(), (Object)result, target);
            }
            catch (Exception e) {
                return ImplicitCasting.unresolvedAttribute(from, String.valueOf(DataType.DATE_PERIOD) + " or " + String.valueOf(DataType.TIME_DURATION), e);
            }
        }

        private static Expression castStringLiteral(Expression from, DataType target) {
            assert (from.foldable());
            try {
                return DataType.isTemporalAmount((DataType)target) ? ImplicitCasting.castStringLiteralToTemporalAmount(from) : new Literal(from.source(), EsqlDataTypeConverter.convert(from.fold(FoldContext.small()), target), target);
            }
            catch (Exception e) {
                return ImplicitCasting.unresolvedAttribute(from, target.toString(), e);
            }
        }

        private static Expression processVectorFunction(org.elasticsearch.xpack.esql.core.expression.function.Function vectorFunction, EsqlFunctionRegistry registry) {
            List args = vectorFunction.arguments();
            List<DataType> targetDataTypes = registry.getDataTypeForStringLiteralConversion(vectorFunction.getClass());
            ArrayList<Object> newArgs = new ArrayList<Object>();
            for (int i = 0; i < args.size(); ++i) {
                Expression arg = (Expression)args.get(i);
                if (targetDataTypes.get(i) == DataType.DENSE_VECTOR && arg.resolved()) {
                    DataType dataType = arg.dataType();
                    if (dataType == DataType.KEYWORD) {
                        Expression exp;
                        if (arg.foldable() && (exp = ImplicitCasting.castStringLiteral(arg, DataType.DENSE_VECTOR)) != arg) {
                            newArgs.add(exp);
                            continue;
                        }
                    } else if (dataType.isNumeric()) {
                        newArgs.add(new ToDenseVector(vectorFunction.source(), arg));
                        continue;
                    }
                }
                newArgs.add(arg);
            }
            return (Expression)vectorFunction.replaceChildren(newArgs);
        }
    }

    private static class ImplicitCastAggregateMetricDoubles
    extends Rule<LogicalPlan, LogicalPlan> {
        private ImplicitCastAggregateMetricDoubles() {
        }

        @Override
        public LogicalPlan apply(LogicalPlan plan) {
            return (LogicalPlan)plan.transformUp(Aggregate.class, p -> !p.childrenResolved() ? p : this.doRule((Aggregate)p));
        }

        private LogicalPlan doRule(Aggregate plan) {
            HashMap unionFields = new HashMap();
            Holder aborted = new Holder((Object)Boolean.FALSE);
            LogicalPlan newPlan = (LogicalPlan)((Object)plan.transformExpressionsOnly(AggregateFunction.class, aggFunc -> {
                FieldAttribute fa;
                EsField patt1$temp;
                Expression patt0$temp = aggFunc.field();
                if (patt0$temp instanceof FieldAttribute && (patt1$temp = (fa = (FieldAttribute)patt0$temp).field()) instanceof InvalidMappedField) {
                    InvalidMappedField mtf = (InvalidMappedField)patt1$temp;
                    if (!mtf.types().contains(DataType.AGGREGATE_METRIC_DOUBLE) || !mtf.types().stream().allMatch(f -> f == DataType.AGGREGATE_METRIC_DOUBLE || f.isNumeric())) {
                        aborted.set((Object)Boolean.TRUE);
                        return aggFunc;
                    }
                    Map<String, Expression> typeConverters = this.typeConverters((AggregateFunction)aggFunc, fa, mtf);
                    if (typeConverters == null) {
                        aborted.set((Object)Boolean.TRUE);
                        return aggFunc;
                    }
                    FieldAttribute newField = unionFields.computeIfAbsent(Attribute.rawTemporaryName((String[])new String[]{fa.name(), aggFunc.functionName(), aggFunc.sourceText()}), newName -> new FieldAttribute(fa.source(), fa.parentName(), fa.qualifier(), newName, (EsField)MultiTypeEsField.resolveFrom((InvalidMappedField)mtf, (Map)typeConverters), fa.nullable(), null, true));
                    ArrayList<FieldAttribute> children = new ArrayList<FieldAttribute>(aggFunc.children());
                    children.set(0, newField);
                    return (Expression)aggFunc.replaceChildren(children);
                }
                return aggFunc;
            }));
            if (unionFields.isEmpty() || ((Boolean)aborted.get()).booleanValue()) {
                return plan;
            }
            return ResolveUnionTypes.addGeneratedFieldsToEsRelations(newPlan, unionFields.values().stream().toList());
        }

        private Map<String, Expression> typeConverters(AggregateFunction aggFunc, FieldAttribute fa, InvalidMappedField mtf) {
            AggregateMetricDoubleBlockBuilder.Metric metric = ImplicitCastAggregateMetricDoubles.getMetric(aggFunc);
            if (metric == null) {
                return null;
            }
            HashMap<String, Expression> typeConverter = new HashMap<String, Expression>();
            for (DataType type : mtf.types()) {
                EsqlScalarFunction convert;
                if (metric == AggregateMetricDoubleBlockBuilder.Metric.COUNT) {
                    convert = new ToAggregateMetricDouble(fa.source(), (Expression)fa);
                } else if (type == DataType.AGGREGATE_METRIC_DOUBLE) {
                    convert = FromAggregateMetricDouble.withMetric(aggFunc.source(), (Expression)fa, metric);
                } else if (type.isNumeric()) {
                    convert = new ToDouble(fa.source(), (Expression)fa);
                } else {
                    return null;
                }
                Expression expression = ResolveUnionTypes.typeSpecificConvert(convert, fa.source(), type, mtf);
                typeConverter.put(type.typeName(), expression);
            }
            return typeConverter;
        }

        private static AggregateMetricDoubleBlockBuilder.Metric getMetric(AggregateFunction aggFunc) {
            if (aggFunc instanceof Max || aggFunc instanceof MaxOverTime) {
                return AggregateMetricDoubleBlockBuilder.Metric.MAX;
            }
            if (aggFunc instanceof Min || aggFunc instanceof MinOverTime) {
                return AggregateMetricDoubleBlockBuilder.Metric.MIN;
            }
            if (aggFunc instanceof Sum || aggFunc instanceof SumOverTime) {
                return AggregateMetricDoubleBlockBuilder.Metric.SUM;
            }
            if (aggFunc instanceof Count || aggFunc instanceof CountOverTime) {
                return AggregateMetricDoubleBlockBuilder.Metric.COUNT;
            }
            if (aggFunc instanceof Avg || aggFunc instanceof AvgOverTime) {
                return AggregateMetricDoubleBlockBuilder.Metric.COUNT;
            }
            if (aggFunc instanceof Present || aggFunc instanceof PresentOverTime) {
                return AggregateMetricDoubleBlockBuilder.Metric.COUNT;
            }
            if (aggFunc instanceof Absent || aggFunc instanceof AbsentOverTime) {
                return AggregateMetricDoubleBlockBuilder.Metric.COUNT;
            }
            return null;
        }
    }

    private static class ResolveUnionTypesInUnionAll
    extends Rule<LogicalPlan, LogicalPlan> {
        private ResolveUnionTypesInUnionAll() {
        }

        @Override
        public LogicalPlan apply(LogicalPlan plan) {
            HashMap<AbstractConvertFunction, Attribute> convertFunctionsToAttributes = new HashMap<AbstractConvertFunction, Attribute>();
            ArrayList<Attribute> updatedUnionAllOutput = new ArrayList<Attribute>();
            LogicalPlan planWithConvertFunctionsPushedDown = (LogicalPlan)plan.transformUp(UnionAll.class, unionAll -> unionAll.childrenResolved() ? ResolveUnionTypesInUnionAll.maybePushDownConvertFunctions(unionAll, plan, convertFunctionsToAttributes) : unionAll);
            LogicalPlan planWithConvertFunctionsReplaced = ResolveUnionTypesInUnionAll.replaceConvertFunctions(planWithConvertFunctionsPushedDown, convertFunctionsToAttributes);
            LogicalPlan planWithImplicitCasting = (LogicalPlan)planWithConvertFunctionsReplaced.transformUp(UnionAll.class, unionAll -> unionAll.resolved() ? ResolveUnionTypesInUnionAll.implicitCastingUnionAllOutput(unionAll, planWithConvertFunctionsReplaced, updatedUnionAllOutput) : unionAll);
            return updatedUnionAllOutput.isEmpty() ? planWithImplicitCasting : ResolveUnionTypesInUnionAll.updateAttributesReferencingUpdatedUnionAllOutput(planWithImplicitCasting, updatedUnionAllOutput);
        }

        private static LogicalPlan maybePushDownConvertFunctions(UnionAll unionAll, LogicalPlan plan, Map<AbstractConvertFunction, Attribute> convertFunctionsToAttributes) {
            Map<String, Set<AbstractConvertFunction>> oldOutputToConvertFunctions = ResolveUnionTypesInUnionAll.collectConvertFunctions(unionAll, plan);
            if (oldOutputToConvertFunctions.isEmpty()) {
                return unionAll;
            }
            ArrayList<LogicalPlan> newChildren = new ArrayList<LogicalPlan>(unionAll.children().size());
            HashMap<String, AbstractConvertFunction> newOutputToConvertFunctions = new HashMap<String, AbstractConvertFunction>();
            boolean outputChanged = false;
            for (LogicalPlan child : unionAll.children()) {
                List<Attribute> childOutput = child.output();
                ArrayList<Alias> newAliases = new ArrayList<Alias>();
                ArrayList<Attribute> newChildOutput = new ArrayList<Attribute>(childOutput.size());
                for (Attribute oldAttr : childOutput) {
                    newChildOutput.add(oldAttr);
                    if (!oldOutputToConvertFunctions.containsKey(oldAttr.name())) continue;
                    Set<AbstractConvertFunction> converts = oldOutputToConvertFunctions.get(oldAttr.name());
                    for (AbstractConvertFunction convert : converts) {
                        String newAliasName = Attribute.rawTemporaryName((String[])new String[]{oldAttr.name(), "converted_to", convert.dataType().typeName()});
                        Alias newAlias = new Alias(oldAttr.source(), newAliasName, (Expression)convert.replaceChildren(Collections.singletonList(oldAttr)));
                        newAliases.add(newAlias);
                        newChildOutput.add(newAlias.toAttribute());
                        outputChanged = true;
                        newOutputToConvertFunctions.putIfAbsent(newAliasName, convert);
                    }
                }
                newChildren.add(ResolveUnionTypesInUnionAll.maybePushDownConvertFunctionsToChild(child, newAliases, newChildOutput));
            }
            return outputChanged ? ResolveUnionTypesInUnionAll.rebuildUnionAll(unionAll, newChildren, newOutputToConvertFunctions, convertFunctionsToAttributes) : unionAll;
        }

        private static Map<String, Set<AbstractConvertFunction>> collectConvertFunctions(UnionAll unionAll, LogicalPlan plan) {
            HashMap<String, Set<AbstractConvertFunction>> convertFunctions = new HashMap<String, Set<AbstractConvertFunction>>();
            plan.forEachExpressionDown(AbstractConvertFunction.class, f -> {
                Expression patt0$temp = f.field();
                if (patt0$temp instanceof Attribute) {
                    Attribute attr = (Attribute)patt0$temp;
                    unionAll.output().stream().filter(a -> a.name().equals(attr.name()) && a.id() == attr.id()).findFirst().ifPresent(unionAllAttr -> convertFunctions.computeIfAbsent(attr.name(), k -> new HashSet()).add(f));
                }
            });
            return convertFunctions;
        }

        private static LogicalPlan maybePushDownConvertFunctionsToChild(LogicalPlan child, List<Alias> aliases, List<Attribute> output) {
            if (!aliases.isEmpty() && child instanceof EsqlProject) {
                EsqlProject esqlProject = (EsqlProject)child;
                LogicalPlan childOfProject = esqlProject.child();
                Eval eval = new Eval(childOfProject.source(), childOfProject, aliases);
                return new EsqlProject(esqlProject.source(), eval, output);
            }
            return child;
        }

        private static LogicalPlan rebuildUnionAll(UnionAll unionAll, List<LogicalPlan> newChildren, Map<String, AbstractConvertFunction> newOutputToConvertFunctions, Map<AbstractConvertFunction, Attribute> convertFunctionsToAttributes) {
            List<String> newChildrenOutputNames = newChildren.getFirst().output().stream().map(NamedExpression::name).toList();
            Holder childrenMatch = new Holder((Object)true);
            newChildren.stream().skip(1L).forEach(childPlan -> {
                List<String> names = childPlan.output().stream().map(NamedExpression::name).toList();
                if (!names.equals(newChildrenOutputNames)) {
                    childrenMatch.set((Object)false);
                }
            });
            if (!((Boolean)childrenMatch.get()).booleanValue()) {
                return unionAll;
            }
            ArrayList<Attribute> newOutput = new ArrayList<Attribute>(newChildrenOutputNames.size());
            List<Attribute> oldOutput = unionAll.output();
            for (String attrName : newChildrenOutputNames) {
                Attribute oldAttr = null;
                for (Attribute attr : oldOutput) {
                    if (!attr.name().equals(attrName)) continue;
                    oldAttr = attr;
                    break;
                }
                if (oldAttr != null) {
                    newOutput.add(oldAttr);
                    continue;
                }
                AbstractConvertFunction convert = newOutputToConvertFunctions.get(attrName);
                if (convert != null) {
                    ReferenceAttribute newAttr = new ReferenceAttribute(convert.source(), null, attrName, convert.dataType(), convert.nullable(), null, true);
                    newOutput.add((Attribute)newAttr);
                    convertFunctionsToAttributes.putIfAbsent(convert, (Attribute)newAttr);
                    continue;
                }
                return unionAll;
            }
            return new UnionAll(unionAll.source(), newChildren, newOutput);
        }

        private static LogicalPlan replaceConvertFunctions(LogicalPlan plan, Map<AbstractConvertFunction, Attribute> convertFunctionsToAttributes) {
            if (convertFunctionsToAttributes.isEmpty()) {
                return plan;
            }
            return (LogicalPlan)((Object)plan.transformExpressionsUp(AbstractConvertFunction.class, convertFunction -> {
                Expression patt0$temp = convertFunction.field();
                if (patt0$temp instanceof Attribute) {
                    Attribute attr = (Attribute)patt0$temp;
                    for (Map.Entry entry : convertFunctionsToAttributes.entrySet()) {
                        Attribute candidateAttr;
                        Expression patt1$temp;
                        AbstractConvertFunction candidate = (AbstractConvertFunction)entry.getKey();
                        Attribute replacement = (Attribute)entry.getValue();
                        if (candidate != convertFunction || !((patt1$temp = candidate.field()) instanceof Attribute) || (candidateAttr = (Attribute)patt1$temp).id() != attr.id()) continue;
                        return replacement;
                    }
                }
                return convertFunction;
            }));
        }

        private static LogicalPlan implicitCastingUnionAllOutput(UnionAll unionAll, LogicalPlan plan, List<Attribute> updatedUnionAllOutput) {
            Map<Attribute, List<LogicalPlan>> outputToPlans = ResolveUnionTypesInUnionAll.outputToPlans(unionAll, plan);
            List<List<Attribute>> outputs = unionAll.children().stream().map(QueryPlan::output).toList();
            List<DataType> commonTypes = ResolveUnionTypesInUnionAll.commonTypes(outputs);
            HashMap<Integer, DataType> indexToCommonType = new HashMap<Integer, DataType>();
            ArrayList<LogicalPlan> newChildren = new ArrayList<LogicalPlan>(unionAll.children().size());
            boolean outputChanged = false;
            for (LogicalPlan child : unionAll.children()) {
                ArrayList<Alias> newAliases = new ArrayList<Alias>();
                List<Attribute> oldChildOutput = child.output();
                ArrayList<Attribute> newChildOutput = new ArrayList<Attribute>(oldChildOutput.size());
                for (int i = 0; i < oldChildOutput.size(); ++i) {
                    Attribute oldOutput = oldChildOutput.get(i);
                    DataType targetType = commonTypes.get(i);
                    Attribute resolved = ResolveUnionTypesInUnionAll.resolveAttribute(oldOutput, targetType, i, outputs, unionAll, outputToPlans, newAliases, indexToCommonType);
                    newChildOutput.add(resolved);
                    if (resolved == oldOutput) continue;
                    outputChanged = true;
                }
                newChildren.add(ResolveUnionTypesInUnionAll.maybePushDownConvertFunctionsToChild(child, newAliases, newChildOutput));
            }
            indexToCommonType.forEach(commonTypes::set);
            return outputChanged ? ResolveUnionTypesInUnionAll.rebuildUnionAllOutput(unionAll, newChildren, commonTypes, updatedUnionAllOutput) : unionAll;
        }

        private static Map<Attribute, List<LogicalPlan>> outputToPlans(UnionAll unionAll, LogicalPlan plan) {
            HashMap<Attribute, List<LogicalPlan>> outputToPlans = new HashMap<Attribute, List<LogicalPlan>>();
            plan.forEachDown(p -> p.forEachExpression(Attribute.class, attr -> {
                if (!(p instanceof UnionAll) && !(p instanceof Project)) {
                    unionAll.output().stream().filter(a -> a.name().equals(attr.name()) && a.id() == attr.id()).findFirst().ifPresent(unionAllAttr -> outputToPlans.computeIfAbsent((Attribute)attr, k -> new ArrayList()).add(p));
                }
            }));
            return outputToPlans;
        }

        private static List<DataType> commonTypes(List<List<Attribute>> outputs) {
            int columnCount = outputs.get(0).size();
            ArrayList<DataType> commonTypes = new ArrayList<DataType>(columnCount);
            for (int i = 0; i < columnCount; ++i) {
                DataType type = outputs.get(0).get(i).dataType();
                for (List<Attribute> out : outputs) {
                    type = ResolveUnionTypesInUnionAll.commonType(type, out.get(i).dataType());
                }
                commonTypes.add(type);
            }
            return commonTypes;
        }

        private static DataType commonType(DataType t1, DataType t2) {
            if (t1 == null || t2 == null) {
                return null;
            }
            t1 = t1.isCounter() ? t1.noCounter() : t1;
            DataType dataType = t2 = t2.isCounter() ? t2.noCounter() : t2;
            if (t1 == t2) {
                return t1;
            }
            if (t1.isDate() && t2.isDate()) {
                return DataType.DATE_NANOS;
            }
            return null;
        }

        private static Attribute resolveAttribute(Attribute oldAttr, DataType targetType, int columnIndex, List<List<Attribute>> outputs, UnionAll unionAll, Map<Attribute, List<LogicalPlan>> outputToPlans, List<Alias> newAliases, Map<Integer, DataType> indexToCommonType) {
            AbstractConvertFunction converter;
            BiFunction<Source, Expression, AbstractConvertFunction> converterFactory;
            if (targetType == null) {
                return ResolveUnionTypesInUnionAll.createUnsupportedOrNull(oldAttr, columnIndex, outputs, unionAll, outputToPlans, newAliases, indexToCommonType);
            }
            if (targetType != DataType.NULL && oldAttr.dataType() != targetType && (converterFactory = EsqlDataTypeConverter.converterFunctionFactory(targetType)) != null && (converter = converterFactory.apply(oldAttr.source(), (Expression)oldAttr)) != null) {
                Alias alias = new Alias(oldAttr.source(), oldAttr.name(), (Expression)converter);
                newAliases.add(alias);
                return alias.toAttribute();
            }
            return oldAttr;
        }

        private static Attribute createUnsupportedOrNull(Attribute oldAttr, int columnIndex, List<List<Attribute>> outputs, UnionAll unionAll, Map<Attribute, List<LogicalPlan>> outputToPlans, List<Alias> newAliases, Map<Integer, DataType> indexToCommonType) {
            Attribute unionAttr = unionAll.output().get(columnIndex);
            if (outputToPlans.containsKey(unionAttr)) {
                List<String> dataTypes = ResolveUnionTypesInUnionAll.collectIncompatibleTypes(columnIndex, outputs);
                UnsupportedAttribute unsupported = new UnsupportedAttribute(oldAttr.source(), oldAttr.name(), new UnsupportedEsField(oldAttr.name(), dataTypes), "Column [" + oldAttr.name() + "] has conflicting data types in subqueries: " + String.valueOf(dataTypes), oldAttr.id());
                newAliases.add(new Alias(oldAttr.source(), oldAttr.name(), (Expression)unsupported));
                indexToCommonType.putIfAbsent(columnIndex, DataType.UNSUPPORTED);
                return unsupported;
            }
            Alias nullAlias = new Alias(oldAttr.source(), oldAttr.name(), (Expression)new Literal(oldAttr.source(), null, DataType.KEYWORD));
            newAliases.add(nullAlias);
            indexToCommonType.putIfAbsent(columnIndex, DataType.KEYWORD);
            return nullAlias.toAttribute();
        }

        private static List<String> collectIncompatibleTypes(int columnIndex, List<List<Attribute>> outputs) {
            ArrayList<String> dataTypes = new ArrayList<String>();
            for (List<Attribute> out : outputs) {
                FieldAttribute fa;
                EsField esField;
                Attribute attr = out.get(columnIndex);
                if (attr instanceof FieldAttribute && (esField = (fa = (FieldAttribute)attr).field()) instanceof InvalidMappedField) {
                    InvalidMappedField imf = (InvalidMappedField)esField;
                    dataTypes.addAll(imf.types().stream().map(DataType::typeName).toList());
                    continue;
                }
                dataTypes.add(attr.dataType().typeName());
            }
            return dataTypes;
        }

        private static UnionAll rebuildUnionAllOutput(UnionAll unionAll, List<LogicalPlan> newChildren, List<DataType> commonTypes, List<Attribute> updatedUnionAllOutput) {
            List<Attribute> oldOutput = unionAll.output();
            ArrayList<Attribute> newOutput = new ArrayList<Attribute>(oldOutput.size());
            for (int i = 0; i < oldOutput.size(); ++i) {
                Attribute oldAttr = oldOutput.get(i);
                DataType commonType = commonTypes.get(i);
                if (oldAttr.dataType() != commonType) {
                    ReferenceAttribute newAttr = new ReferenceAttribute(oldAttr.source(), null, oldAttr.name(), commonType, oldAttr.nullable(), oldAttr.id(), oldAttr.synthetic());
                    newOutput.add((Attribute)newAttr);
                    updatedUnionAllOutput.add((Attribute)newAttr);
                    continue;
                }
                newOutput.add(oldAttr);
            }
            return new UnionAll(unionAll.source(), newChildren, newOutput);
        }

        private static LogicalPlan updateAttributesReferencingUpdatedUnionAllOutput(LogicalPlan plan, List<Attribute> updatedUnionAllOutput) {
            Map<NameId, Attribute> idToUpdatedAttr = updatedUnionAllOutput.stream().collect(Collectors.toMap(NamedExpression::id, attr -> attr));
            return (LogicalPlan)((Object)plan.transformExpressionsUp(Attribute.class, expr -> {
                Attribute updated = (Attribute)idToUpdatedAttr.get(expr.id());
                return updated != null && expr.dataType() != updated.dataType() ? updated : expr;
            }));
        }
    }

    private static class AddImplicitLimit
    extends ParameterizedRule<LogicalPlan, LogicalPlan, AnalyzerContext> {
        private AddImplicitLimit() {
        }

        @Override
        public LogicalPlan apply(LogicalPlan logicalPlan, AnalyzerContext context) {
            int limit;
            boolean isTsAggregate;
            List limits = logicalPlan.collectFirstChildren(Limit.class::isInstance);
            boolean bl = isTsAggregate = !logicalPlan.collectFirstChildren(lp -> lp instanceof TimeSeriesAggregate).stream().toList().isEmpty();
            if (limits.isEmpty()) {
                limit = context.configuration().resultTruncationDefaultSize(isTsAggregate);
                if (!isTsAggregate) {
                    HeaderWarning.addWarning((String)"No limit defined, adding default limit of [{}]", (Object[])new Object[]{limit});
                }
            } else {
                limit = context.configuration().resultTruncationMaxSize(isTsAggregate);
            }
            Source source = logicalPlan.source();
            return new Limit(source, (Expression)new Literal(source, (Object)limit, DataType.INTEGER), logicalPlan);
        }
    }

    private static class AddImplicitForkLimit
    extends ParameterizedRule<LogicalPlan, LogicalPlan, AnalyzerContext> {
        private final AddImplicitLimit addImplicitLimit = new AddImplicitLimit();

        private AddImplicitForkLimit() {
        }

        @Override
        public LogicalPlan apply(LogicalPlan logicalPlan, AnalyzerContext context) {
            return (LogicalPlan)logicalPlan.transformUp(Fork.class, fork -> this.addImplicitLimitToForkSubQueries((Fork)fork, context));
        }

        private LogicalPlan addImplicitLimitToForkSubQueries(Fork fork, AnalyzerContext ctx) {
            ArrayList<LogicalPlan> newSubPlans = new ArrayList<LogicalPlan>();
            for (LogicalPlan subPlan : fork.children()) {
                newSubPlans.add(this.addImplicitLimit.apply(subPlan, ctx));
            }
            return fork.replaceSubPlans(newSubPlans);
        }
    }

    private static class UnionTypesCleanup
    extends Rule<LogicalPlan, LogicalPlan> {
        private UnionTypesCleanup() {
        }

        @Override
        public LogicalPlan apply(LogicalPlan plan) {
            LogicalPlan planWithCheckedUnionTypes = (LogicalPlan)plan.transformUp(LogicalPlan.class, p -> (LogicalPlan)((Object)((Object)p.transformExpressionsOnly(FieldAttribute.class, UnionTypesCleanup::checkUnresolved))));
            return planWithCheckedUnionTypes.resolved() ? UnionTypesCleanup.planWithoutSyntheticAttributes(planWithCheckedUnionTypes) : planWithCheckedUnionTypes;
        }

        static Attribute checkUnresolved(FieldAttribute fa) {
            EsField esField = fa.field();
            if (esField instanceof InvalidMappedField) {
                InvalidMappedField imf = (InvalidMappedField)esField;
                String unresolvedMessage = "Cannot use field [" + fa.name() + "] due to ambiguities being " + imf.errorMessage();
                List types = imf.getTypesToIndices().keySet().stream().toList();
                return new UnsupportedAttribute(fa.source(), fa.name(), new UnsupportedEsField(imf.getName(), types), unresolvedMessage, fa.id());
            }
            return fa;
        }

        private static LogicalPlan planWithoutSyntheticAttributes(LogicalPlan plan) {
            List<Attribute> output = plan.output();
            ArrayList<Attribute> newOutput = new ArrayList<Attribute>(output.size());
            for (Attribute attr : output) {
                if (attr.synthetic() && attr != NO_FIELDS.getFirst()) continue;
                newOutput.add(attr);
            }
            return newOutput.size() == output.size() ? plan : new Project(Source.EMPTY, plan, newOutput);
        }
    }
}

