/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.vectors;

import java.util.Iterator;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.index.fielddata.ScriptDocValues;
import org.elasticsearch.script.field.vectors.RankVectors;

public class RankVectorsScriptDocValues
extends ScriptDocValues<BytesRef> {
    public static final String MISSING_VECTOR_FIELD_MESSAGE = "A document doesn't have a value for a rank-vectors field!";
    private final int dims;
    protected final RankVectorsSupplier dvSupplier;

    public RankVectorsScriptDocValues(RankVectorsSupplier supplier, int dims) {
        super(supplier);
        this.dvSupplier = supplier;
        this.dims = dims;
    }

    public int dims() {
        return this.dims;
    }

    private RankVectors getCheckedVector() {
        RankVectors vector = this.dvSupplier.getInternal();
        if (vector == null) {
            throw new IllegalArgumentException(MISSING_VECTOR_FIELD_MESSAGE);
        }
        return vector;
    }

    public Iterator<float[]> getVectorValues() {
        return this.getCheckedVector().getVectors();
    }

    public float[] getMagnitudes() {
        return this.getCheckedVector().getMagnitudes();
    }

    @Override
    public BytesRef get(int index) {
        throw new UnsupportedOperationException("accessing a rank-vectors field's value through 'get' or 'value' is not supported, use 'vectorValues' or 'magnitudes' instead.");
    }

    @Override
    public int size() {
        RankVectors mdv = this.dvSupplier.getInternal();
        if (mdv != null) {
            return mdv.size();
        }
        return 0;
    }

    public static interface RankVectorsSupplier
    extends ScriptDocValues.Supplier<BytesRef> {
        @Override
        default public BytesRef getInternal(int index) {
            throw new UnsupportedOperationException();
        }

        public RankVectors getInternal();
    }
}

