/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.fieldcomparator;

import java.io.IOException;
import org.apache.lucene.index.DocValuesSkipper;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.search.DocIdSetIterator;

class SecondarySortIterator
extends DocIdSetIterator {
    final NumericDocValues values;
    final DocValuesSkipper valueSkipper;
    final DocValuesSkipper primaryFieldSkipper;
    final long minValue;
    final long maxValue;
    int docID = -1;
    boolean skipperMatch;
    int primaryFieldUpTo = -1;
    int valueFieldUpTo = -1;

    SecondarySortIterator(NumericDocValues values, DocValuesSkipper valueSkipper, DocValuesSkipper primaryFieldSkipper, long minValue, long maxValue) {
        this.values = values;
        this.valueSkipper = valueSkipper;
        this.primaryFieldSkipper = primaryFieldSkipper;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.valueFieldUpTo = valueSkipper.maxDocID(0);
        this.primaryFieldUpTo = primaryFieldSkipper.maxDocID(0);
    }

    public int docID() {
        return this.docID;
    }

    public int nextDoc() throws IOException {
        return this.advance(this.docID + 1);
    }

    public int advance(int target) throws IOException {
        this.skipperMatch = false;
        if ((target = this.values.advance(target)) == Integer.MAX_VALUE) {
            this.docID = target;
            return this.docID;
        }
        while (true) {
            long value;
            if (target > this.valueFieldUpTo) {
                this.valueSkipper.advance(target);
                this.valueFieldUpTo = this.valueSkipper.maxDocID(0);
                long minValue = this.valueSkipper.minValue(0);
                long maxValue = this.valueSkipper.maxValue(0);
                if (minValue > this.maxValue || maxValue < this.minValue) {
                    for (int level = 1; level < this.valueSkipper.numLevels(); ++level) {
                        minValue = this.valueSkipper.minValue(level);
                        maxValue = this.valueSkipper.maxValue(level);
                        if (minValue <= this.maxValue && maxValue >= this.minValue) break;
                        this.valueFieldUpTo = this.valueSkipper.maxDocID(level);
                    }
                    int upTo = this.valueFieldUpTo;
                    if (maxValue < this.minValue) {
                        this.primaryFieldSkipper.advance(target);
                        this.primaryFieldUpTo = this.primaryFieldSkipper.maxDocID(0);
                        if (this.primaryFieldSkipper.minValue(0) == this.primaryFieldSkipper.maxValue(0)) {
                            for (int level = 1; level < this.primaryFieldSkipper.numLevels() && this.primaryFieldSkipper.minValue(level) == this.primaryFieldSkipper.maxValue(level); ++level) {
                                this.primaryFieldUpTo = this.primaryFieldSkipper.maxDocID(level);
                            }
                        }
                        if (this.primaryFieldUpTo > upTo) {
                            upTo = this.primaryFieldUpTo;
                        }
                    }
                    if ((target = this.values.advance(upTo + 1)) == Integer.MAX_VALUE) {
                        this.docID = target;
                        return this.docID;
                    }
                } else if (minValue >= this.minValue && maxValue <= this.maxValue) {
                    assert (this.valueSkipper.docCount(0) == this.valueSkipper.maxDocID(0) - this.valueSkipper.minDocID(0) + 1);
                    this.skipperMatch = true;
                    this.docID = target;
                    return this.docID;
                }
            }
            if ((value = this.values.longValue()) < this.minValue && target > this.primaryFieldUpTo) {
                this.primaryFieldSkipper.advance(target);
                this.primaryFieldUpTo = this.primaryFieldSkipper.maxDocID(0);
                if (this.primaryFieldSkipper.minValue(0) == this.primaryFieldSkipper.maxValue(0)) {
                    for (int level = 1; level < this.primaryFieldSkipper.numLevels() && this.primaryFieldSkipper.minValue(level) == this.primaryFieldSkipper.maxValue(level); ++level) {
                        this.primaryFieldUpTo = this.primaryFieldSkipper.maxDocID(level);
                    }
                    target = this.values.advance(this.primaryFieldUpTo + 1);
                    if (target != Integer.MAX_VALUE) continue;
                    this.docID = target;
                    return this.docID;
                }
                target = this.values.nextDoc();
                if (target != Integer.MAX_VALUE) continue;
                this.docID = target;
                return this.docID;
            }
            if (value >= this.minValue && value <= this.maxValue) {
                this.docID = target;
                return this.docID;
            }
            target = this.values.nextDoc();
            if (target == Integer.MAX_VALUE) break;
        }
        this.docID = target;
        return this.docID;
    }

    public int docIDRunEnd() throws IOException {
        if (this.skipperMatch) {
            return this.valueFieldUpTo + 1;
        }
        return super.docIDRunEnd();
    }

    public long cost() {
        return this.values.cost();
    }
}

