/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.fieldcomparator;

import java.io.IOException;
import java.util.function.Function;
import org.apache.lucene.index.DocValuesSkipper;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.LeafFieldComparator;
import org.apache.lucene.search.LongValues;
import org.apache.lucene.search.Pruning;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.util.BitSet;
import org.elasticsearch.common.time.DateUtils;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.fielddata.DenseLongValues;
import org.elasticsearch.index.fielddata.FieldData;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.index.fielddata.LeafNumericFieldData;
import org.elasticsearch.index.fielddata.SortedNumericLongValues;
import org.elasticsearch.index.fielddata.fieldcomparator.SecondarySortIterator;
import org.elasticsearch.index.fielddata.plain.SortedNumericIndexFieldData;
import org.elasticsearch.lucene.comparators.XLongComparator;
import org.elasticsearch.lucene.comparators.XNumericComparator;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.MultiValueMode;
import org.elasticsearch.search.sort.BucketedSort;
import org.elasticsearch.search.sort.SortOrder;

public class LongValuesComparatorSource
extends IndexFieldData.XFieldComparatorSource {
    final IndexNumericFieldData indexFieldData;
    private final Function<SortedNumericLongValues, SortedNumericLongValues> converter;
    private final IndexNumericFieldData.NumericType targetNumericType;

    public LongValuesComparatorSource(IndexNumericFieldData indexFieldData, @Nullable Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested, IndexNumericFieldData.NumericType targetNumericType) {
        this(indexFieldData, missingValue, sortMode, nested, null, targetNumericType);
    }

    public LongValuesComparatorSource(IndexNumericFieldData indexFieldData, @Nullable Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested, Function<SortedNumericLongValues, SortedNumericLongValues> converter, IndexNumericFieldData.NumericType targetNumericType) {
        super(missingValue, sortMode, nested);
        this.indexFieldData = indexFieldData;
        this.converter = converter;
        this.targetNumericType = targetNumericType;
    }

    @Override
    public SortField.Type reducedType() {
        return SortField.Type.LONG;
    }

    private SortedNumericLongValues loadDocValues(LeafReaderContext context) {
        LeafNumericFieldData data = (LeafNumericFieldData)this.indexFieldData.load(context);
        SortedNumericLongValues values = data instanceof SortedNumericIndexFieldData.NanoSecondFieldData ? ((SortedNumericIndexFieldData.NanoSecondFieldData)data).getLongValuesAsNanos() : data.getLongValues();
        return this.converter != null ? this.converter.apply(values) : values;
    }

    DenseLongValues getLongValues(LeafReaderContext context, long missingValue) throws IOException {
        SortedNumericLongValues values = this.loadDocValues(context);
        if (this.nested == null) {
            return FieldData.replaceMissing(this.sortMode.select(values), missingValue);
        }
        BitSet rootDocs = this.nested.rootDocs(context);
        DocIdSetIterator innerDocs = this.nested.innerDocs(context);
        int maxChildren = this.nested.getNestedSort() != null ? this.nested.getNestedSort().getMaxChildren() : Integer.MAX_VALUE;
        return this.sortMode.select(values, missingValue, rootDocs, innerDocs, maxChildren);
    }

    public FieldComparator<?> newComparator(String fieldname, int numHits, Pruning enableSkipping, boolean reversed) {
        assert (this.indexFieldData == null || fieldname.equals(this.indexFieldData.getFieldName()));
        final long lMissingValue = (Long)this.missingObject(this.missingValue, reversed);
        return new XLongComparator(numHits, fieldname, lMissingValue, reversed, enableSkipping){

            @Override
            public LeafFieldComparator getLeafComparator(LeafReaderContext context) throws IOException {
                final int maxDoc = context.reader().maxDoc();
                return new XLongComparator.LongLeafComparator(context){

                    @Override
                    protected NumericDocValues getNumericDocValues(LeafReaderContext context, String field) throws IOException {
                        return LongValuesComparatorSource.wrap(LongValuesComparatorSource.this.getLongValues(context, lMissingValue), maxDoc);
                    }

                    @Override
                    protected XNumericComparator.CompetitiveDISIBuilder buildCompetitiveDISIBuilder(LeafReaderContext context) throws IOException {
                        Sort indexSort = context.reader().getMetaData().sort();
                        if (indexSort == null) {
                            return super.buildCompetitiveDISIBuilder(context);
                        }
                        SortField[] sortFields = indexSort.getSort();
                        if (sortFields.length != 2) {
                            return super.buildCompetitiveDISIBuilder(context);
                        }
                        if (!sortFields[1].getField().equals(field)) {
                            return super.buildCompetitiveDISIBuilder(context);
                        }
                        final DocValuesSkipper skipper = context.reader().getDocValuesSkipper(field);
                        final DocValuesSkipper primaryFieldSkipper = context.reader().getDocValuesSkipper(sortFields[0].getField());
                        if (primaryFieldSkipper == null || skipper.docCount() != maxDoc || primaryFieldSkipper.docCount() != maxDoc) {
                            return super.buildCompetitiveDISIBuilder(context);
                        }
                        return new XNumericComparator.CompetitiveDISIBuilder(this){

                            @Override
                            protected int docCount() {
                                return skipper.docCount();
                            }

                            @Override
                            protected void doUpdateCompetitiveIterator() {
                                this.competitiveIterator.update(new SecondarySortIterator(docValues, skipper, primaryFieldSkipper, this.minValueAsLong, this.maxValueAsLong));
                            }
                        };
                    }
                };
            }
        };
    }

    @Override
    public BucketedSort newBucketedSort(BigArrays bigArrays, final SortOrder sortOrder, DocValueFormat format, int bucketSize, BucketedSort.ExtraData extra) {
        return new BucketedSort.ForLongs(bigArrays, sortOrder, format, bucketSize, extra){
            private final long lMissingValue;
            {
                super(bigArrays, sortOrder3, format, bucketSize, extra);
                this.lMissingValue = (Long)LongValuesComparatorSource.this.missingObject(LongValuesComparatorSource.this.missingValue, sortOrder == SortOrder.DESC);
            }

            @Override
            public BucketedSort.ForLongs.Leaf forLeaf(final LeafReaderContext ctx) throws IOException {
                return new BucketedSort.ForLongs.Leaf(ctx){
                    private final LongValues docValues;
                    private long docValue;
                    {
                        super(this, ctx2);
                        this.docValues = LongValuesComparatorSource.this.getLongValues(ctx, lMissingValue);
                    }

                    @Override
                    protected boolean advanceExact(int doc) throws IOException {
                        if (this.docValues.advanceExact(doc)) {
                            this.docValue = this.docValues.longValue();
                            return true;
                        }
                        return false;
                    }

                    @Override
                    protected long docValue() {
                        return this.docValue;
                    }
                };
            }
        };
    }

    @Override
    public Object missingObject(Object missingValue, boolean reversed) {
        if (this.targetNumericType == IndexNumericFieldData.NumericType.DATE_NANOSECONDS && (LongValuesComparatorSource.sortMissingFirst(missingValue) || LongValuesComparatorSource.sortMissingLast(missingValue))) {
            boolean min = LongValuesComparatorSource.sortMissingFirst(missingValue) ^ reversed;
            return min ? 0L : DateUtils.MAX_NANOSECOND;
        }
        return super.missingObject(missingValue, reversed);
    }

    protected static NumericDocValues wrap(final DenseLongValues longValues, final int maxDoc) {
        return new NumericDocValues(){
            int doc = -1;

            public long longValue() throws IOException {
                return longValues.longValue();
            }

            public boolean advanceExact(int target) throws IOException {
                this.doc = target;
                return longValues.advanceExact(target);
            }

            public int docID() {
                return this.doc;
            }

            public int nextDoc() throws IOException {
                return this.advance(this.doc + 1);
            }

            public int advance(int target) throws IOException {
                if (target >= maxDoc) {
                    this.doc = Integer.MAX_VALUE;
                    return Integer.MAX_VALUE;
                }
                boolean hasValue = longValues.advanceExact(target);
                assert (hasValue) : "LongValuesComparatorSource#wrap called with a LongValues that has missing values";
                this.doc = target;
                return target;
            }

            public long cost() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

