/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.codec.vectors.diskbbq;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.VectorEncoding;
import org.apache.lucene.index.VectorSimilarityFunction;
import org.apache.lucene.search.AcceptDocs;
import org.apache.lucene.search.KnnCollector;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.VectorUtil;
import org.elasticsearch.index.codec.vectors.BQVectorUtils;
import org.elasticsearch.index.codec.vectors.GenericFlatVectorReaders;
import org.elasticsearch.index.codec.vectors.OptimizedScalarQuantizer;
import org.elasticsearch.index.codec.vectors.cluster.NeighborQueue;
import org.elasticsearch.index.codec.vectors.diskbbq.DocIdsWriter;
import org.elasticsearch.index.codec.vectors.diskbbq.IVFVectorsReader;
import org.elasticsearch.simdvec.ES91OSQVectorsScorer;
import org.elasticsearch.simdvec.ES92Int7VectorsScorer;
import org.elasticsearch.simdvec.ESVectorUtil;

public class ES920DiskBBQVectorsReader
extends IVFVectorsReader {
    ES920DiskBBQVectorsReader(SegmentReadState state, GenericFlatVectorReaders.LoadFlatVectorsReader getFormatReader) throws IOException {
        super(state, getFormatReader);
    }

    public IVFVectorsReader.CentroidIterator getPostingListPrefetchIterator(final IVFVectorsReader.CentroidIterator centroidIterator, final IndexInput postingListSlice) throws IOException {
        return new IVFVectorsReader.CentroidIterator(){
            IVFVectorsReader.CentroidOffsetAndLength nextOffsetAndLength;
            {
                IVFVectorsReader.CentroidOffsetAndLength centroidOffsetAndLength = this.nextOffsetAndLength = centroidIterator.hasNext() ? centroidIterator.nextPostingListOffsetAndLength() : null;
                if (this.nextOffsetAndLength != null) {
                    this.prefetch(this.nextOffsetAndLength);
                }
            }

            void prefetch(IVFVectorsReader.CentroidOffsetAndLength offsetAndLength) throws IOException {
                postingListSlice.prefetch(offsetAndLength.offset(), offsetAndLength.length());
            }

            @Override
            public boolean hasNext() {
                return this.nextOffsetAndLength != null;
            }

            @Override
            public IVFVectorsReader.CentroidOffsetAndLength nextPostingListOffsetAndLength() throws IOException {
                IVFVectorsReader.CentroidOffsetAndLength offsetAndLength = this.nextOffsetAndLength;
                if (centroidIterator.hasNext()) {
                    this.nextOffsetAndLength = centroidIterator.nextPostingListOffsetAndLength();
                    this.prefetch(this.nextOffsetAndLength);
                } else {
                    this.nextOffsetAndLength = null;
                }
                return offsetAndLength;
            }
        };
    }

    @Override
    public IVFVectorsReader.CentroidIterator getCentroidIterator(FieldInfo fieldInfo, int numCentroids, IndexInput centroids, float[] targetQuery, IndexInput postingListSlice, AcceptDocs acceptDocs, float visitRatio) throws IOException {
        IVFVectorsReader.CentroidIterator centroidIterator;
        IVFVectorsReader.FieldEntry fieldEntry = (IVFVectorsReader.FieldEntry)this.fields.get(fieldInfo.number);
        float globalCentroidDp = fieldEntry.globalCentroidDp();
        OptimizedScalarQuantizer scalarQuantizer = new OptimizedScalarQuantizer(fieldInfo.getVectorSimilarityFunction());
        int[] scratch = new int[targetQuery.length];
        OptimizedScalarQuantizer.QuantizationResult queryParams = scalarQuantizer.scalarQuantize(targetQuery, new float[targetQuery.length], scratch, (byte)7, fieldEntry.globalCentroid());
        byte[] quantized = new byte[targetQuery.length];
        for (int i = 0; i < quantized.length; ++i) {
            quantized[i] = (byte)scratch[i];
        }
        ES92Int7VectorsScorer scorer = ESVectorUtil.getES92Int7VectorsScorer((IndexInput)centroids, (int)fieldInfo.getVectorDimension());
        centroids.seek(0L);
        int numParents = centroids.readVInt();
        if (numParents > 0) {
            float centroidOversampling = (float)fieldEntry.numCentroids() / (float)(2 * numParents);
            centroidIterator = ES920DiskBBQVectorsReader.getCentroidIteratorWithParents(fieldInfo, centroids, numParents, numCentroids, scorer, quantized, queryParams, globalCentroidDp, visitRatio * centroidOversampling);
        } else {
            centroidIterator = ES920DiskBBQVectorsReader.getCentroidIteratorNoParent(fieldInfo, centroids, numCentroids, scorer, quantized, queryParams, globalCentroidDp);
        }
        return this.getPostingListPrefetchIterator(centroidIterator, postingListSlice);
    }

    @Override
    protected IVFVectorsReader.FieldEntry doReadField(IndexInput input, String rawVectorFormat, boolean useDirectIOReads, VectorSimilarityFunction similarityFunction, VectorEncoding vectorEncoding, int numCentroids, long centroidOffset, long centroidLength, long postingListOffset, long postingListLength, float[] globalCentroid, float globalCentroidDp) {
        return new IVFVectorsReader.FieldEntry(rawVectorFormat, useDirectIOReads, similarityFunction, vectorEncoding, numCentroids, centroidOffset, centroidLength, postingListOffset, postingListLength, globalCentroid, globalCentroidDp);
    }

    private static IVFVectorsReader.CentroidIterator getCentroidIteratorNoParent(FieldInfo fieldInfo, final IndexInput centroids, int numCentroids, ES92Int7VectorsScorer scorer, byte[] quantizeQuery, OptimizedScalarQuantizer.QuantizationResult queryParams, float globalCentroidDp) throws IOException {
        final NeighborQueue neighborQueue = new NeighborQueue(numCentroids, true);
        ES920DiskBBQVectorsReader.score(neighborQueue, numCentroids, 0, scorer, quantizeQuery, queryParams, globalCentroidDp, fieldInfo.getVectorSimilarityFunction(), new float[16]);
        final long offset = centroids.getFilePointer();
        return new IVFVectorsReader.CentroidIterator(){

            @Override
            public boolean hasNext() {
                return neighborQueue.size() > 0;
            }

            @Override
            public IVFVectorsReader.CentroidOffsetAndLength nextPostingListOffsetAndLength() throws IOException {
                int centroidOrdinal = neighborQueue.pop();
                centroids.seek(offset + 16L * (long)centroidOrdinal);
                long postingListOffset = centroids.readLong();
                long postingListLength = centroids.readLong();
                return new IVFVectorsReader.CentroidOffsetAndLength(postingListOffset, postingListLength);
            }
        };
    }

    private static IVFVectorsReader.CentroidIterator getCentroidIteratorWithParents(final FieldInfo fieldInfo, final IndexInput centroids, int numParents, int numCentroids, final ES92Int7VectorsScorer scorer, final byte[] quantizeQuery, final OptimizedScalarQuantizer.QuantizationResult queryParams, final float globalCentroidDp, float centroidRatio) throws IOException {
        final NeighborQueue parentsQueue = new NeighborQueue(numParents, true);
        int maxChildrenSize = centroids.readVInt();
        final NeighborQueue currentParentQueue = new NeighborQueue(maxChildrenSize, true);
        int bufferSize = (int)Math.min(Math.max(centroidRatio * (float)numCentroids, 1.0f), (float)numCentroids);
        final NeighborQueue neighborQueue = new NeighborQueue(bufferSize, true);
        final float[] scores = new float[16];
        ES920DiskBBQVectorsReader.score(parentsQueue, numParents, 0, scorer, quantizeQuery, queryParams, globalCentroidDp, fieldInfo.getVectorSimilarityFunction(), scores);
        final long centroidQuantizeSize = fieldInfo.getVectorDimension() + 12 + 4;
        final long offset = centroids.getFilePointer();
        final long childrenOffset = offset + 8L * (long)numParents;
        while (parentsQueue.size() > 0 && neighborQueue.size() < bufferSize) {
            int pop = parentsQueue.pop();
            ES920DiskBBQVectorsReader.populateOneChildrenGroup(currentParentQueue, centroids, offset + 8L * (long)pop, childrenOffset, centroidQuantizeSize, fieldInfo, scorer, quantizeQuery, queryParams, globalCentroidDp, scores);
            while (currentParentQueue.size() > 0 && neighborQueue.size() < bufferSize) {
                float score = currentParentQueue.topScore();
                int children = currentParentQueue.pop();
                neighborQueue.add(children, score);
            }
        }
        final long childrenFileOffsets = childrenOffset + centroidQuantizeSize * (long)numCentroids;
        return new IVFVectorsReader.CentroidIterator(){

            @Override
            public boolean hasNext() {
                return neighborQueue.size() > 0;
            }

            @Override
            public IVFVectorsReader.CentroidOffsetAndLength nextPostingListOffsetAndLength() throws IOException {
                int centroidOrdinal = this.nextCentroid();
                centroids.seek(childrenFileOffsets + 16L * (long)centroidOrdinal);
                long postingListOffset = centroids.readLong();
                long postingListLength = centroids.readLong();
                return new IVFVectorsReader.CentroidOffsetAndLength(postingListOffset, postingListLength);
            }

            private int nextCentroid() throws IOException {
                if (currentParentQueue.size() > 0) {
                    return neighborQueue.popAndAddRaw(currentParentQueue.popRaw());
                }
                if (parentsQueue.size() > 0) {
                    int pop = parentsQueue.pop();
                    ES920DiskBBQVectorsReader.populateOneChildrenGroup(currentParentQueue, centroids, offset + 8L * (long)pop, childrenOffset, centroidQuantizeSize, fieldInfo, scorer, quantizeQuery, queryParams, globalCentroidDp, scores);
                    return this.nextCentroid();
                }
                return neighborQueue.pop();
            }
        };
    }

    private static void populateOneChildrenGroup(NeighborQueue neighborQueue, IndexInput centroids, long parentOffset, long childrenOffset, long centroidQuantizeSize, FieldInfo fieldInfo, ES92Int7VectorsScorer scorer, byte[] quantizeQuery, OptimizedScalarQuantizer.QuantizationResult queryParams, float globalCentroidDp, float[] scores) throws IOException {
        centroids.seek(parentOffset);
        int childrenOrdinal = centroids.readInt();
        int numChildren = centroids.readInt();
        centroids.seek(childrenOffset + centroidQuantizeSize * (long)childrenOrdinal);
        ES920DiskBBQVectorsReader.score(neighborQueue, numChildren, childrenOrdinal, scorer, quantizeQuery, queryParams, globalCentroidDp, fieldInfo.getVectorSimilarityFunction(), scores);
    }

    private static void score(NeighborQueue neighborQueue, int size, int scoresOffset, ES92Int7VectorsScorer scorer, byte[] quantizeQuery, OptimizedScalarQuantizer.QuantizationResult queryCorrections, float centroidDp, VectorSimilarityFunction similarityFunction, float[] scores) throws IOException {
        int i;
        int limit = size - 16 + 1;
        for (i = 0; i < limit; i += 16) {
            scorer.scoreBulk(quantizeQuery, queryCorrections.lowerInterval(), queryCorrections.upperInterval(), queryCorrections.quantizedComponentSum(), queryCorrections.additionalCorrection(), similarityFunction, centroidDp, scores);
            for (int j = 0; j < 16; ++j) {
                neighborQueue.add(scoresOffset + i + j, scores[j]);
            }
        }
        while (i < size) {
            float score = scorer.score(quantizeQuery, queryCorrections.lowerInterval(), queryCorrections.upperInterval(), queryCorrections.quantizedComponentSum(), queryCorrections.additionalCorrection(), similarityFunction, centroidDp);
            neighborQueue.add(scoresOffset + i, score);
            ++i;
        }
    }

    @Override
    public IVFVectorsReader.PostingVisitor getPostingVisitor(FieldInfo fieldInfo, IndexInput indexInput, float[] target, Bits acceptDocs) throws IOException {
        IVFVectorsReader.FieldEntry entry = (IVFVectorsReader.FieldEntry)this.fields.get(fieldInfo.number);
        indexInput.readVInt();
        return new MemorySegmentPostingsVisitor(target, indexInput, entry, fieldInfo, acceptDocs);
    }

    @Override
    public Map<String, Long> getOffHeapByteSize(FieldInfo fieldInfo) {
        return Map.of();
    }

    private static class MemorySegmentPostingsVisitor
    implements IVFVectorsReader.PostingVisitor {
        final long quantizedByteLength;
        final IndexInput indexInput;
        final float[] target;
        final IVFVectorsReader.FieldEntry entry;
        final FieldInfo fieldInfo;
        final Bits acceptDocs;
        private final ES91OSQVectorsScorer osqVectorsScorer;
        final float[] scores = new float[16];
        final float[] correctionsLower = new float[16];
        final float[] correctionsUpper = new float[16];
        final int[] correctionsSum = new int[16];
        final float[] correctionsAdd = new float[16];
        final int[] docIdsScratch = new int[16];
        byte docEncoding;
        int docBase = 0;
        int vectors;
        boolean quantized = false;
        float centroidDp;
        final float[] centroid;
        long slicePos;
        OptimizedScalarQuantizer.QuantizationResult queryCorrections;
        final float[] scratch;
        final int[] quantizationScratch;
        final byte[] quantizedQueryScratch;
        final OptimizedScalarQuantizer quantizer;
        final DocIdsWriter idsWriter = new DocIdsWriter();
        final float[] correctiveValues = new float[3];
        final long quantizedVectorByteSize;

        MemorySegmentPostingsVisitor(float[] target, IndexInput indexInput, IVFVectorsReader.FieldEntry entry, FieldInfo fieldInfo, Bits acceptDocs) throws IOException {
            this.target = target;
            this.indexInput = indexInput;
            this.entry = entry;
            this.fieldInfo = fieldInfo;
            this.acceptDocs = acceptDocs;
            this.centroid = new float[fieldInfo.getVectorDimension()];
            this.scratch = new float[target.length];
            this.quantizationScratch = new int[target.length];
            int discretizedDimensions = BQVectorUtils.discretize(fieldInfo.getVectorDimension(), 64);
            this.quantizedQueryScratch = new byte[4 * discretizedDimensions / 8];
            this.quantizedByteLength = discretizedDimensions / 8 + 12 + 2;
            this.quantizedVectorByteSize = discretizedDimensions / 8;
            this.quantizer = new OptimizedScalarQuantizer(fieldInfo.getVectorSimilarityFunction(), 0.1f, 1);
            this.osqVectorsScorer = ESVectorUtil.getES91OSQVectorsScorer((IndexInput)indexInput, (int)fieldInfo.getVectorDimension());
        }

        @Override
        public int resetPostingsScorer(long offset) throws IOException {
            this.quantized = false;
            this.indexInput.seek(offset);
            this.indexInput.readFloats(this.centroid, 0, this.centroid.length);
            this.centroidDp = Float.intBitsToFloat(this.indexInput.readInt());
            this.vectors = this.indexInput.readVInt();
            this.docEncoding = this.indexInput.readByte();
            this.docBase = 0;
            this.slicePos = this.indexInput.getFilePointer();
            return this.vectors;
        }

        private float scoreIndividually() throws IOException {
            int doc;
            int j;
            float maxScore = Float.NEGATIVE_INFINITY;
            for (j = 0; j < 16; ++j) {
                doc = this.docIdsScratch[j];
                if (doc != -1) {
                    float qcDist;
                    this.scores[j] = qcDist = (float)this.osqVectorsScorer.quantizeScore(this.quantizedQueryScratch);
                    continue;
                }
                this.indexInput.skipBytes(this.quantizedVectorByteSize);
            }
            this.indexInput.readFloats(this.correctionsLower, 0, 16);
            this.indexInput.readFloats(this.correctionsUpper, 0, 16);
            for (j = 0; j < 16; ++j) {
                this.correctionsSum[j] = Short.toUnsignedInt(this.indexInput.readShort());
            }
            this.indexInput.readFloats(this.correctionsAdd, 0, 16);
            for (j = 0; j < 16; ++j) {
                doc = this.docIdsScratch[j];
                if (doc == -1) continue;
                this.scores[j] = this.osqVectorsScorer.score(this.queryCorrections.lowerInterval(), this.queryCorrections.upperInterval(), this.queryCorrections.quantizedComponentSum(), this.queryCorrections.additionalCorrection(), this.fieldInfo.getVectorSimilarityFunction(), this.centroidDp, this.correctionsLower[j], this.correctionsUpper[j], this.correctionsSum[j], this.correctionsAdd[j], this.scores[j]);
                if (!(this.scores[j] > maxScore)) continue;
                maxScore = this.scores[j];
            }
            return maxScore;
        }

        private static int docToBulkScore(int[] docIds, Bits acceptDocs) {
            assert (acceptDocs != null) : "acceptDocs must not be null";
            int docToScore = 16;
            for (int i = 0; i < 16; ++i) {
                if (acceptDocs.get(docIds[i])) continue;
                docIds[i] = -1;
                --docToScore;
            }
            return docToScore;
        }

        private void collectBulk(KnnCollector knnCollector, float[] scores) {
            for (int i = 0; i < 16; ++i) {
                int doc = this.docIdsScratch[i];
                if (doc == -1) continue;
                knnCollector.collect(doc, scores[i]);
            }
        }

        private void readDocIds(int count) throws IOException {
            this.idsWriter.readInts(this.indexInput, count, this.docEncoding, this.docIdsScratch);
            for (int j = 0; j < count; ++j) {
                this.docBase += this.docIdsScratch[j];
                this.docIdsScratch[j] = this.docBase;
            }
        }

        @Override
        public int visit(KnnCollector knnCollector) throws IOException {
            int i;
            this.indexInput.seek(this.slicePos);
            int scoredDocs = 0;
            int limit = this.vectors - 16 + 1;
            for (i = 0; i < limit; i += 16) {
                int docsToBulkScore;
                this.readDocIds(16);
                int n = docsToBulkScore = this.acceptDocs == null ? 16 : MemorySegmentPostingsVisitor.docToBulkScore(this.docIdsScratch, this.acceptDocs);
                if (docsToBulkScore == 0) {
                    this.indexInput.skipBytes(this.quantizedByteLength * 16L);
                    continue;
                }
                this.quantizeQueryIfNecessary();
                float maxScore = docsToBulkScore < 8 ? this.scoreIndividually() : this.osqVectorsScorer.scoreBulk(this.quantizedQueryScratch, this.queryCorrections.lowerInterval(), this.queryCorrections.upperInterval(), this.queryCorrections.quantizedComponentSum(), this.queryCorrections.additionalCorrection(), this.fieldInfo.getVectorSimilarityFunction(), this.centroidDp, this.scores);
                if (knnCollector.minCompetitiveSimilarity() < maxScore) {
                    this.collectBulk(knnCollector, this.scores);
                }
                scoredDocs += docsToBulkScore;
            }
            if (i < this.vectors) {
                this.readDocIds(this.vectors - i);
            }
            int count = 0;
            while (i < this.vectors) {
                int doc = this.docIdsScratch[count++];
                if (this.acceptDocs == null || this.acceptDocs.get(doc)) {
                    this.quantizeQueryIfNecessary();
                    float qcDist = this.osqVectorsScorer.quantizeScore(this.quantizedQueryScratch);
                    this.indexInput.readFloats(this.correctiveValues, 0, 3);
                    int quantizedComponentSum = Short.toUnsignedInt(this.indexInput.readShort());
                    float score = this.osqVectorsScorer.score(this.queryCorrections.lowerInterval(), this.queryCorrections.upperInterval(), this.queryCorrections.quantizedComponentSum(), this.queryCorrections.additionalCorrection(), this.fieldInfo.getVectorSimilarityFunction(), this.centroidDp, this.correctiveValues[0], this.correctiveValues[1], quantizedComponentSum, this.correctiveValues[2], qcDist);
                    ++scoredDocs;
                    if (knnCollector.minCompetitiveSimilarity() < score) {
                        knnCollector.collect(doc, score);
                    }
                } else {
                    this.indexInput.skipBytes(this.quantizedByteLength);
                }
                ++i;
            }
            if (scoredDocs > 0) {
                knnCollector.incVisitedCount(scoredDocs);
            }
            return scoredDocs;
        }

        private void quantizeQueryIfNecessary() {
            if (!this.quantized) {
                assert (this.fieldInfo.getVectorSimilarityFunction() != VectorSimilarityFunction.COSINE || VectorUtil.isUnitVector((float[])this.target));
                this.queryCorrections = this.quantizer.scalarQuantize(this.target, this.scratch, this.quantizationScratch, (byte)4, this.centroid);
                ESVectorUtil.transposeHalfByte((int[])this.quantizationScratch, (byte[])this.quantizedQueryScratch);
                this.quantized = true;
            }
        }
    }
}

