/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.codec.vectors;

import java.nio.ShortBuffer;
import org.apache.lucene.util.BitUtil;

public final class BFloat16 {
    public static final int BYTES = 2;

    public static short floatToBFloat16(float f) {
        return (short)(Float.floatToIntBits(f) >>> 16);
    }

    public static float truncateToBFloat16(float f) {
        return Float.intBitsToFloat(Float.floatToIntBits(f) & 0xFFFF0000);
    }

    public static float bFloat16ToFloat(short bf) {
        return Float.intBitsToFloat(bf << 16);
    }

    public static void floatToBFloat16(float[] floats, ShortBuffer bFloats) {
        for (float v : floats) {
            bFloats.put(BFloat16.floatToBFloat16(v));
        }
    }

    public static void bFloat16ToFloat(byte[] bfBytes, float[] floats) {
        assert (floats.length * 2 == bfBytes.length);
        for (int i = 0; i < floats.length; ++i) {
            floats[i] = BFloat16.bFloat16ToFloat(BitUtil.VH_LE_SHORT.get(bfBytes, i * 2));
        }
    }

    public static void bFloat16ToFloat(ShortBuffer bFloats, float[] floats) {
        for (int i = 0; i < floats.length; ++i) {
            floats[i] = BFloat16.bFloat16ToFloat(bFloats.get());
        }
    }

    private BFloat16() {
    }
}

