/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index;

import java.time.Instant;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Strings;
import org.apache.lucene.index.MergePolicy;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.IndexRouting;
import org.elasticsearch.cluster.routing.allocation.ExistingShardsAllocator;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.util.FeatureFlag;
import org.elasticsearch.core.Booleans;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexMode;
import org.elasticsearch.index.IndexSortConfig;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.IndexVersions;
import org.elasticsearch.index.MergePolicyConfig;
import org.elasticsearch.index.MergeSchedulerConfig;
import org.elasticsearch.index.TimestampBounds;
import org.elasticsearch.index.mapper.IgnoredSourceFieldMapper;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.SeqNoFieldMapper;
import org.elasticsearch.index.mapper.SourceFieldMapper;
import org.elasticsearch.index.mapper.vectors.DenseVectorFieldMapper;
import org.elasticsearch.index.translog.Translog;
import org.elasticsearch.indices.recovery.RecoverySettings;
import org.elasticsearch.node.Node;

public final class IndexSettings {
    public static final Setting<List<String>> DEFAULT_FIELD_SETTING = Setting.stringListSetting("index.query.default_field", Collections.singletonList("*"), Setting.Property.IndexScope, Setting.Property.Dynamic, Setting.Property.ServerlessPublic);
    public static final Setting<Boolean> QUERY_STRING_LENIENT_SETTING = Setting.boolSetting("index.query_string.lenient", false, Setting.Property.IndexScope, Setting.Property.ServerlessPublic);
    public static final Setting<Boolean> QUERY_STRING_ANALYZE_WILDCARD = Setting.boolSetting("indices.query.query_string.analyze_wildcard", false, Setting.Property.NodeScope);
    public static final Setting<Boolean> QUERY_STRING_ALLOW_LEADING_WILDCARD = Setting.boolSetting("indices.query.query_string.allowLeadingWildcard", true, Setting.Property.NodeScope);
    public static final Setting<Boolean> ALLOW_UNMAPPED = Setting.boolSetting("index.query.parse.allow_unmapped_fields", true, Setting.Property.IndexScope);
    public static final Setting<TimeValue> INDEX_TRANSLOG_SYNC_INTERVAL_SETTING = Setting.timeSetting("index.translog.sync_interval", TimeValue.timeValueSeconds((long)5L), TimeValue.timeValueMillis((long)100L), Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<TimeValue> INDEX_SEARCH_IDLE_AFTER = Setting.timeSetting("index.search.idle.after", TimeValue.timeValueSeconds((long)30L), TimeValue.timeValueMinutes((long)0L), Setting.Property.IndexScope, Setting.Property.Dynamic);
    public static final Setting<Translog.Durability> INDEX_TRANSLOG_DURABILITY_SETTING = Setting.enumSetting(Translog.Durability.class, "index.translog.durability", Translog.Durability.REQUEST, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<Boolean> INDEX_WARMER_ENABLED_SETTING = Setting.boolSetting("index.warmer.enabled", true, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<String> INDEX_CHECK_ON_STARTUP = new Setting<String>("index.shard.check_on_startup", "false", s -> {
        switch (s) {
            case "false": 
            case "true": 
            case "checksum": {
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown value for [index.shard.check_on_startup] must be one of [true, false, checksum] but was: " + s);
            }
        }
        return s;
    }, Setting.Property.IndexScope);
    public static final Setting<Integer> MAX_RESULT_WINDOW_SETTING = Setting.intSetting("index.max_result_window", 10000, 1, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<Integer> MAX_INNER_RESULT_WINDOW_SETTING = Setting.intSetting("index.max_inner_result_window", 100, 1, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<Integer> MAX_SCRIPT_FIELDS_SETTING = Setting.intSetting("index.max_script_fields", 32, 0, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<Integer> MAX_TOKEN_COUNT_SETTING = Setting.intSetting("index.analyze.max_token_count", 10000, 1, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<Integer> MAX_ANALYZED_OFFSET_SETTING = Setting.intSetting("index.highlight.max_analyzed_offset", 1000000, 1, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<Boolean> WEIGHT_MATCHES_MODE_ENABLED_SETTING = Setting.boolSetting("index.highlight.weight_matches_mode.enabled", true, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<Integer> MAX_TERMS_COUNT_SETTING = Setting.intSetting("index.max_terms_count", 65536, 1, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<Integer> MAX_NGRAM_DIFF_SETTING = Setting.intSetting("index.max_ngram_diff", 1, 0, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<Integer> MAX_SHINGLE_DIFF_SETTING = Setting.intSetting("index.max_shingle_diff", 3, 0, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<Integer> MAX_DOCVALUE_FIELDS_SEARCH_SETTING = Setting.intSetting("index.max_docvalue_fields_search", 100, 0, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<Integer> MAX_RESCORE_WINDOW_SETTING = Setting.intSetting("index.max_rescore_window", MAX_RESULT_WINDOW_SETTING, 1, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<Boolean> INDEX_FAST_REFRESH_SETTING = Setting.boolSetting("index.fast_refresh", false, Setting.Property.Final, Setting.Property.IndexScope);
    public static final TimeValue DEFAULT_REFRESH_INTERVAL = new TimeValue(1L, TimeUnit.SECONDS);
    public static final Setting<TimeValue> NODE_DEFAULT_REFRESH_INTERVAL_SETTING = Setting.timeSetting("node._internal.default_refresh_interval", DEFAULT_REFRESH_INTERVAL, TimeValue.MINUS_ONE, Setting.Property.NodeScope);
    public static TimeValue STATELESS_DEFAULT_REFRESH_INTERVAL = TimeValue.timeValueSeconds((long)5L);
    public static TimeValue STATELESS_MIN_NON_FAST_REFRESH_INTERVAL = TimeValue.timeValueSeconds((long)5L);
    public static final Setting<TimeValue> INDEX_REFRESH_INTERVAL_SETTING = Setting.timeSetting("index.refresh_interval", settings -> {
        if (ExistingShardsAllocator.EXISTING_SHARDS_ALLOCATOR_SETTING.get((Settings)settings).equals("stateless") && !INDEX_FAST_REFRESH_SETTING.get((Settings)settings).booleanValue()) {
            return STATELESS_DEFAULT_REFRESH_INTERVAL;
        }
        return DEFAULT_REFRESH_INTERVAL;
    }, (Setting.Validator<TimeValue>)new RefreshIntervalValidator(), Setting.Property.Dynamic, Setting.Property.IndexScope, Setting.Property.ServerlessPublic);
    private static final List<Setting<?>> REFRESH_INTERVAL_VALIDATOR_SETTINGS_LIST = List.of(ExistingShardsAllocator.EXISTING_SHARDS_ALLOCATOR_SETTING, INDEX_FAST_REFRESH_SETTING, IndexMetadata.SETTING_INDEX_VERSION_CREATED);
    public static final Setting<ByteSizeValue> INDEX_TRANSLOG_FLUSH_THRESHOLD_SIZE_SETTING = Setting.byteSizeSetting("index.translog.flush_threshold_size", ByteSizeValue.of(10L, ByteSizeUnit.GB), ByteSizeValue.ofBytes(Translog.DEFAULT_HEADER_SIZE_IN_BYTES + 1), ByteSizeValue.ofBytes(Long.MAX_VALUE), Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<TimeValue> INDEX_TRANSLOG_FLUSH_THRESHOLD_AGE_SETTING = Setting.timeSetting("index.translog.flush_threshold_age", new TimeValue(1L, TimeUnit.MINUTES), new TimeValue(1L, TimeUnit.SECONDS), new TimeValue(1L, TimeUnit.HOURS), Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<ByteSizeValue> INDEX_FLUSH_AFTER_MERGE_THRESHOLD_SIZE_SETTING = Setting.byteSizeSetting("index.flush_after_merge", ByteSizeValue.of(512L, ByteSizeUnit.MB), ByteSizeValue.ZERO, ByteSizeValue.ofBytes(Long.MAX_VALUE), Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<ByteSizeValue> INDEX_TRANSLOG_GENERATION_THRESHOLD_SIZE_SETTING = Setting.byteSizeSetting("index.translog.generation_threshold_size", ByteSizeValue.of(64L, ByteSizeUnit.MB), ByteSizeValue.ofBytes(Translog.DEFAULT_HEADER_SIZE_IN_BYTES + 1), ByteSizeValue.ofBytes(Long.MAX_VALUE), Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final TimeValue DEFAULT_GC_DELETES = TimeValue.timeValueSeconds((long)60L);
    public static final Setting<TimeValue> INDEX_GC_DELETES_SETTING = Setting.timeSetting("index.gc_deletes", DEFAULT_GC_DELETES, new TimeValue(-1L, TimeUnit.MILLISECONDS), Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<Boolean> INDEX_SOFT_DELETES_SETTING = Setting.boolSetting("index.soft_deletes.enabled", true, Setting.Property.IndexScope, Setting.Property.Final);
    public static final Setting<Long> INDEX_SOFT_DELETES_RETENTION_OPERATIONS_SETTING = Setting.longSetting("index.soft_deletes.retention.operations", 0L, 0L, Setting.Property.IndexScope, Setting.Property.Dynamic);
    public static final Setting<TimeValue> INDEX_TRANSLOG_RETENTION_AGE_SETTING = Setting.timeSetting("index.translog.retention.age", TimeValue.MINUS_ONE, TimeValue.MINUS_ONE, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<ByteSizeValue> INDEX_TRANSLOG_RETENTION_SIZE_SETTING = Setting.byteSizeSetting("index.translog.retention.size", settings -> "-1", Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<TimeValue> INDEX_SOFT_DELETES_RETENTION_LEASE_PERIOD_SETTING = Setting.timeSetting("index.soft_deletes.retention_lease.period", TimeValue.timeValueHours((long)12L), TimeValue.ZERO, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<Integer> MAX_REFRESH_LISTENERS_PER_SHARD = Setting.intSetting("index.max_refresh_listeners", 1000, 0, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<Integer> MAX_SLICES_PER_SCROLL = Setting.intSetting("index.max_slices_per_scroll", 1024, 1, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<Integer> MAX_REGEX_LENGTH_SETTING = Setting.intSetting("index.max_regex_length", 1000, 1, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<String> DEFAULT_PIPELINE = Setting.simpleString("index.default_pipeline", "_none", Setting.Property.Dynamic, Setting.Property.IndexScope, Setting.Property.ServerlessPublic);
    public static final Setting<String> FINAL_PIPELINE = Setting.simpleString("index.final_pipeline", "_none", Setting.Property.Dynamic, Setting.Property.IndexScope, Setting.Property.ServerlessPublic);
    public static final Setting<Double> FILE_BASED_RECOVERY_THRESHOLD_SETTING = Setting.doubleSetting("index.recovery.file_based_threshold", 0.1, 0.0, Setting.Property.IndexScope);
    public static final Setting<Boolean> BLOOM_FILTER_ID_FIELD_ENABLED_SETTING = Setting.boolSetting("index.bloom_filter_for_id_field.enabled", true, Setting.Property.Dynamic, Setting.Property.IndexScope, Setting.Property.DeprecatedWarning);
    public static final String LIFECYCLE_ORIGINATION_DATE = "index.lifecycle.origination_date";
    public static final Setting<Long> LIFECYCLE_ORIGINATION_DATE_SETTING = Setting.longSetting("index.lifecycle.origination_date", -1L, -1L, Setting.Property.Dynamic, Setting.Property.IndexScope, Setting.Property.ServerlessPublic);
    public static final String LIFECYCLE_PARSE_ORIGINATION_DATE = "index.lifecycle.parse_origination_date";
    public static final Setting<Boolean> LIFECYCLE_PARSE_ORIGINATION_DATE_SETTING = Setting.boolSetting("index.lifecycle.parse_origination_date", false, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final String PREFER_ILM = "index.lifecycle.prefer_ilm";
    public static final Setting<Boolean> PREFER_ILM_SETTING = Setting.boolSetting("index.lifecycle.prefer_ilm", true, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<Instant> TIME_SERIES_START_TIME = Setting.dateSetting("index.time_series.start_time", Instant.ofEpochMilli(-377705116800000L), v -> {}, Setting.Property.IndexScope, Setting.Property.Final, Setting.Property.ServerlessPublic);
    public static final Setting<Instant> TIME_SERIES_END_TIME = Setting.dateSetting("index.time_series.end_time", Instant.ofEpochMilli(253402300799999L), new Setting.Validator<Instant>(){

        @Override
        public void validate(Instant value) {
        }

        @Override
        public void validate(Instant value, Map<Setting<?>, Object> settings) {
            Instant startTime = (Instant)settings.get(TIME_SERIES_START_TIME);
            if (startTime.toEpochMilli() > value.toEpochMilli()) {
                throw new IllegalArgumentException("index.time_series.end_time must be larger than index.time_series.start_time");
            }
        }

        @Override
        public Iterator<Setting<?>> settings() {
            List<Setting<Instant>> settings = List.of(TIME_SERIES_START_TIME);
            return settings.iterator();
        }
    }, Setting.Property.IndexScope, Setting.Property.Dynamic, Setting.Property.ServerlessPublic);
    public static final Setting<Boolean> TIME_SERIES_ES87TSDB_CODEC_ENABLED_SETTING = Setting.boolSetting("index.time_series.es87tsdb_codec.enabled", true, Setting.Property.IndexScope, Setting.Property.Final);
    public static final Setting<Boolean> LOGSDB_ROUTE_ON_SORT_FIELDS = Setting.boolSetting("index.logsdb.route_on_sort_fields", false, Setting.Property.IndexScope, Setting.Property.Final);
    public static final Setting<Boolean> LOGSDB_ADD_HOST_NAME_FIELD = Setting.boolSetting("index.logsdb.add_host_name_field", false, Setting.Property.IndexScope, Setting.Property.PrivateIndex, Setting.Property.Final);
    public static final Setting<Boolean> LOGSDB_SORT_ON_HOST_NAME = Setting.boolSetting("index.logsdb.sort_on_host_name", false, Setting.Property.IndexScope, Setting.Property.PrivateIndex, Setting.Property.Final);
    public static final Setting<Boolean> LOGSDB_SORT_ON_MESSAGE_TEMPLATE = Setting.boolSetting("index.logsdb.sort_on_message_template", false, Setting.Property.IndexScope, Setting.Property.PrivateIndex, Setting.Property.Final);
    public static final boolean DOC_VALUES_SKIPPER = new FeatureFlag("doc_values_skipper").isEnabled();
    public static final Setting<Boolean> USE_DOC_VALUES_SKIPPER = Setting.boolSetting("index.mapping.use_doc_values_skipper", true, Setting.Property.IndexScope, Setting.Property.Final);
    public static final boolean TSDB_SYNTHETIC_ID_FEATURE_FLAG = new FeatureFlag("tsdb_synthetic_id").isEnabled();
    public static final Setting<Boolean> USE_SYNTHETIC_ID = Setting.boolSetting("index.mapping.use_synthetic_id", false, new Setting.Validator<Boolean>(){

        @Override
        public void validate(Boolean enabled) {
            if (enabled.booleanValue() && !TSDB_SYNTHETIC_ID_FEATURE_FLAG) {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "The setting [%s] is only permitted when the feature flag is enabled.", USE_SYNTHETIC_ID.getKey()));
            }
        }

        @Override
        public void validate(Boolean enabled, Map<Setting<?>, Object> settings) {
            IndexMode indexMode;
            if (enabled.booleanValue() && (indexMode = (IndexMode)((Object)settings.get(MODE))) != IndexMode.TIME_SERIES) {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "The setting [%s] is only permitted when [%s] is set to [%s]. Current mode: [%s].", USE_SYNTHETIC_ID.getKey(), MODE.getKey(), IndexMode.TIME_SERIES.name(), indexMode.name()));
            }
        }

        @Override
        public Iterator<Setting<?>> settings() {
            List<Setting<IndexMode>> list = List.of(MODE);
            return list.iterator();
        }
    }, Setting.Property.IndexScope, Setting.Property.Final);
    public static final Setting<IndexMode> MODE = Setting.enumSetting(IndexMode.class, "index.mode", IndexMode.STANDARD, new Setting.Validator<IndexMode>(){

        @Override
        public void validate(IndexMode value) {
        }

        @Override
        public void validate(IndexMode value, Map<Setting<?>, Object> settings) {
            value.validateWithOtherSettings(settings);
        }

        @Override
        public Iterator<Setting<?>> settings() {
            return IndexMode.VALIDATE_WITH_SETTINGS.iterator();
        }
    }, Setting.Property.IndexScope, Setting.Property.Final, Setting.Property.ServerlessPublic);
    public static final Setting<SourceFieldMapper.Mode> INDEX_MAPPER_SOURCE_MODE_SETTING = Setting.enumSetting(SourceFieldMapper.Mode.class, settings -> {
        IndexMode indexMode = MODE.get((Settings)settings);
        return indexMode.defaultSourceMode().name();
    }, "index.mapping.source.mode", value -> {}, Setting.Property.Final, Setting.Property.IndexScope, Setting.Property.ServerlessPublic);
    public static final Setting<Boolean> RECOVERY_USE_SYNTHETIC_SOURCE_SETTING = Setting.boolSetting("index.recovery.use_synthetic_source", settings -> {
        boolean isNewIndexVersion = IndexMetadata.SETTING_INDEX_VERSION_CREATED.get((Settings)settings).onOrAfter(IndexVersions.USE_SYNTHETIC_SOURCE_FOR_RECOVERY_BY_DEFAULT);
        boolean isIndexVersionInBackportRange = IndexMetadata.SETTING_INDEX_VERSION_CREATED.get((Settings)settings).between(IndexVersions.USE_SYNTHETIC_SOURCE_FOR_RECOVERY_BY_DEFAULT_BACKPORT, IndexVersions.UPGRADE_TO_LUCENE_10_0_0);
        boolean useSyntheticRecoverySource = isNewIndexVersion || isIndexVersionInBackportRange;
        return String.valueOf(useSyntheticRecoverySource && Objects.equals((Object)INDEX_MAPPER_SOURCE_MODE_SETTING.get((Settings)settings), (Object)SourceFieldMapper.Mode.SYNTHETIC));
    }, new Setting.Validator<Boolean>(){

        @Override
        public void validate(Boolean value) {
        }

        @Override
        public void validate(Boolean enabled, Map<Setting<?>, Object> settings) {
            SourceFieldMapper.Mode sourceMode;
            if (!enabled.booleanValue()) {
                return;
            }
            IndexMode indexMode = (IndexMode)((Object)settings.get(MODE));
            if (indexMode.defaultSourceMode() != SourceFieldMapper.Mode.SYNTHETIC && (sourceMode = (SourceFieldMapper.Mode)((Object)settings.get(INDEX_MAPPER_SOURCE_MODE_SETTING))) != SourceFieldMapper.Mode.SYNTHETIC) {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "The setting [%s] is only permitted when [%s] is set to [%s]. Current mode: [%s].", RECOVERY_USE_SYNTHETIC_SOURCE_SETTING.getKey(), INDEX_MAPPER_SOURCE_MODE_SETTING.getKey(), SourceFieldMapper.Mode.SYNTHETIC.name(), sourceMode.name()));
            }
        }

        @Override
        public Iterator<Setting<?>> settings() {
            List<Setting<IndexMode>> res = List.of(INDEX_MAPPER_SOURCE_MODE_SETTING, MODE);
            return res.iterator();
        }
    }, Setting.Property.IndexScope, Setting.Property.Final);
    public static final Setting<Boolean> USE_TIME_SERIES_DOC_VALUES_FORMAT_SETTING = Setting.boolSetting("index.use_time_series_doc_values_format", settings -> {
        if (settings == null) {
            return Boolean.FALSE.toString();
        }
        IndexMode indexMode = MODE.get((Settings)settings);
        return Boolean.toString(indexMode.useTimeSeriesDocValuesCodec());
    }, Setting.Property.IndexScope, Setting.Property.Final);
    @Deprecated
    public static final Setting<Integer> MAX_ADJACENCY_MATRIX_FILTERS_SETTING = Setting.intSetting("index.max_adjacency_matrix_filters", 100, 2, Setting.Property.Dynamic, Setting.Property.IndexScope, Setting.Property.IndexSettingDeprecatedInV7AndRemovedInV8);
    public static final Setting<Integer> IGNORE_ABOVE_SETTING = Setting.intSetting("index.mapping.ignore_above", settings -> String.valueOf(IndexSettings.getIgnoreAboveDefaultValue(settings)), 0, Integer.MAX_VALUE, Setting.Property.IndexScope, Setting.Property.ServerlessPublic);
    public static final Setting<SeqNoFieldMapper.SeqNoIndexOptions> SEQ_NO_INDEX_OPTIONS_SETTING = Setting.enumSetting(SeqNoFieldMapper.SeqNoIndexOptions.class, settings -> {
        IndexMode indexMode = MODE.get((Settings)settings);
        if ((indexMode == IndexMode.LOGSDB || indexMode == IndexMode.TIME_SERIES) && IndexMetadata.SETTING_INDEX_VERSION_CREATED.get((Settings)settings).onOrAfter(IndexVersions.SEQ_NO_WITHOUT_POINTS)) {
            return SeqNoFieldMapper.SeqNoIndexOptions.DOC_VALUES_ONLY.toString();
        }
        return SeqNoFieldMapper.SeqNoIndexOptions.POINTS_AND_DOC_VALUES.toString();
    }, "index.seq_no.index_options", value -> {}, Setting.Property.IndexScope, Setting.Property.Final);
    public static final Setting<Boolean> INDEX_MAPPING_EXCLUDE_SOURCE_VECTORS_SETTING = Setting.boolSetting("index.mapping.exclude_source_vectors", settings -> String.valueOf(IndexMetadata.SETTING_INDEX_VERSION_CREATED.get((Settings)settings).onOrAfter(IndexVersions.EXCLUDE_SOURCE_VECTORS_DEFAULT)), Setting.Property.IndexScope, Setting.Property.Final, Setting.Property.ServerlessPublic);
    private final Index index;
    private final IndexVersion version;
    private final Logger logger;
    private final String nodeName;
    private final Settings nodeSettings;
    private final int numberOfShards;
    private final IndexMode mode;
    private volatile TimestampBounds timestampBounds;
    private volatile Settings settings;
    private volatile IndexMetadata indexMetadata;
    private volatile List<String> defaultFields;
    private final boolean queryStringLenient;
    private final boolean queryStringAnalyzeWildcard;
    private final boolean queryStringAllowLeadingWildcard;
    private final boolean defaultAllowUnmappedFields;
    private volatile Translog.Durability durability;
    private volatile TimeValue syncInterval;
    private volatile TimeValue refreshInterval;
    private final boolean fastRefresh;
    private volatile ByteSizeValue flushThresholdSize;
    private volatile TimeValue flushThresholdAge;
    private volatile ByteSizeValue generationThresholdSize;
    private volatile ByteSizeValue flushAfterMergeThresholdSize;
    private final MergeSchedulerConfig mergeSchedulerConfig;
    private final MergePolicyConfig mergePolicyConfig;
    private final IndexSortConfig indexSortConfig;
    private final IndexScopedSettings scopedSettings;
    private long gcDeletesInMillis = DEFAULT_GC_DELETES.millis();
    private final boolean softDeleteEnabled;
    private volatile long softDeleteRetentionOperations;
    private final boolean es87TSDBCodecEnabled;
    private final boolean logsdbRouteOnSortFields;
    private final boolean logsdbSortOnHostName;
    private final boolean logsdbAddHostNameField;
    private volatile long retentionLeaseMillis;
    private volatile boolean warmerEnabled;
    private volatile int maxResultWindow;
    private volatile int maxInnerResultWindow;
    private volatile int maxRescoreWindow;
    private volatile int maxDocvalueFields;
    private volatile int maxScriptFields;
    private volatile int maxTokenCount;
    private volatile int maxNgramDiff;
    private volatile int maxShingleDiff;
    private volatile DenseVectorFieldMapper.FilterHeuristic hnswFilterHeuristic;
    private volatile boolean earlyTermination;
    private volatile TimeValue searchIdleAfter;
    private volatile int maxAnalyzedOffset;
    private volatile boolean weightMatchesEnabled;
    private volatile int maxTermsCount;
    private volatile String defaultPipeline;
    private volatile String requiredPipeline;
    private volatile long mappingNestedFieldsLimit;
    private volatile long mappingNestedDocsLimit;
    private volatile long mappingTotalFieldsLimit;
    private volatile boolean ignoreDynamicFieldsBeyondLimit;
    private volatile boolean ignoreDynamicFieldNamesBeyondLimit;
    private volatile long mappingDepthLimit;
    private volatile long mappingFieldNameLengthLimit;
    private volatile long mappingDimensionFieldsLimit;
    private volatile boolean skipIgnoredSourceWrite;
    private volatile boolean skipIgnoredSourceRead;
    private final SourceFieldMapper.Mode indexMappingSourceMode;
    private final boolean recoverySourceEnabled;
    private final boolean recoverySourceSyntheticEnabled;
    private final boolean useDocValuesSkipper;
    private final boolean useTimeSeriesSyntheticId;
    private final boolean useTimeSeriesDocValuesFormat;
    private volatile int maxRefreshListeners;
    private volatile int maxSlicesPerScroll;
    private volatile int maxRegexLength;
    private final IndexRouting indexRouting;
    private final SeqNoFieldMapper.SeqNoIndexOptions seqNoIndexOptions;
    private final Mapper.SourceKeepMode sourceKeepMode;

    public boolean isES87TSDBCodecEnabled() {
        return this.es87TSDBCodecEnabled;
    }

    private static int getIgnoreAboveDefaultValue(Settings settings) {
        if (settings == null) {
            return Integer.MAX_VALUE;
        }
        return Mapper.IgnoreAbove.getIgnoreAboveDefaultValue(MODE.get(settings), IndexMetadata.SETTING_INDEX_VERSION_CREATED.get(settings));
    }

    public long getRetentionLeaseMillis() {
        return this.retentionLeaseMillis;
    }

    private void setRetentionLeaseMillis(TimeValue retentionLease) {
        this.retentionLeaseMillis = retentionLease.millis();
    }

    public Mapper.SourceKeepMode sourceKeepMode() {
        return this.sourceKeepMode;
    }

    public List<String> getDefaultFields() {
        return this.defaultFields;
    }

    private void setDefaultFields(List<String> defaultFields) {
        this.defaultFields = defaultFields;
    }

    public boolean isQueryStringLenient() {
        return this.queryStringLenient;
    }

    public boolean isQueryStringAnalyzeWildcard() {
        return this.queryStringAnalyzeWildcard;
    }

    public boolean isQueryStringAllowLeadingWildcard() {
        return this.queryStringAllowLeadingWildcard;
    }

    public boolean isDefaultAllowUnmappedFields() {
        return this.defaultAllowUnmappedFields;
    }

    public boolean logsdbRouteOnSortFields() {
        return this.logsdbRouteOnSortFields;
    }

    public boolean logsdbAddHostNameField() {
        return this.logsdbAddHostNameField;
    }

    public IndexSettings(IndexMetadata indexMetadata, Settings nodeSettings) {
        this(indexMetadata, nodeSettings, IndexScopedSettings.DEFAULT_SCOPED_SETTINGS);
    }

    public IndexSettings(IndexMetadata indexMetadata, Settings nodeSettings, IndexScopedSettings indexScopedSettings) {
        boolean useSyntheticId;
        this.scopedSettings = indexScopedSettings.copy(nodeSettings, indexMetadata);
        this.nodeSettings = nodeSettings;
        this.settings = Settings.builder().put(nodeSettings).put(indexMetadata.getSettings()).build();
        this.index = indexMetadata.getIndex();
        this.version = IndexMetadata.SETTING_INDEX_VERSION_CREATED.get(this.settings);
        this.logger = Loggers.getLogger(this.getClass(), this.index, new String[0]);
        this.nodeName = Node.NODE_NAME_SETTING.get(this.settings);
        this.indexMetadata = indexMetadata;
        this.numberOfShards = this.settings.getAsInt("index.number_of_shards", null);
        this.mode = this.scopedSettings.get(MODE);
        this.timestampBounds = this.mode.getTimestampBound(indexMetadata);
        if (this.timestampBounds != null) {
            this.scopedSettings.addSettingsUpdateConsumer(TIME_SERIES_END_TIME, endTime -> {
                this.timestampBounds = TimestampBounds.updateEndTime(this.timestampBounds, endTime);
            });
        }
        this.queryStringLenient = QUERY_STRING_LENIENT_SETTING.get(this.settings);
        this.queryStringAnalyzeWildcard = QUERY_STRING_ANALYZE_WILDCARD.get(nodeSettings);
        this.queryStringAllowLeadingWildcard = QUERY_STRING_ALLOW_LEADING_WILDCARD.get(nodeSettings);
        this.defaultAllowUnmappedFields = this.scopedSettings.get(ALLOW_UNMAPPED);
        this.durability = this.scopedSettings.get(INDEX_TRANSLOG_DURABILITY_SETTING);
        this.defaultFields = this.scopedSettings.get(DEFAULT_FIELD_SETTING);
        this.syncInterval = INDEX_TRANSLOG_SYNC_INTERVAL_SETTING.get(this.settings);
        this.refreshInterval = this.scopedSettings.get(INDEX_REFRESH_INTERVAL_SETTING);
        this.fastRefresh = this.scopedSettings.get(INDEX_FAST_REFRESH_SETTING);
        if (this.fastRefresh) {
            if (!DiscoveryNode.isStateless(nodeSettings)) {
                throw new IllegalArgumentException(INDEX_FAST_REFRESH_SETTING.getKey() + " is allowed only in stateless");
            }
            if (!indexMetadata.isSystem()) {
                throw new IllegalArgumentException(INDEX_FAST_REFRESH_SETTING.getKey() + " is allowed only for system indices");
            }
        }
        this.flushThresholdSize = this.scopedSettings.get(INDEX_TRANSLOG_FLUSH_THRESHOLD_SIZE_SETTING);
        this.flushThresholdAge = this.scopedSettings.get(INDEX_TRANSLOG_FLUSH_THRESHOLD_AGE_SETTING);
        this.generationThresholdSize = this.scopedSettings.get(INDEX_TRANSLOG_GENERATION_THRESHOLD_SIZE_SETTING);
        this.flushAfterMergeThresholdSize = this.scopedSettings.get(INDEX_FLUSH_AFTER_MERGE_THRESHOLD_SIZE_SETTING);
        this.mergeSchedulerConfig = new MergeSchedulerConfig(this);
        this.gcDeletesInMillis = this.scopedSettings.get(INDEX_GC_DELETES_SETTING).getMillis();
        this.softDeleteEnabled = this.scopedSettings.get(INDEX_SOFT_DELETES_SETTING);
        assert (this.softDeleteEnabled || this.version.before(IndexVersions.V_8_0_0)) : "soft deletes must be enabled in version " + String.valueOf(this.version);
        this.softDeleteRetentionOperations = this.scopedSettings.get(INDEX_SOFT_DELETES_RETENTION_OPERATIONS_SETTING);
        this.retentionLeaseMillis = this.scopedSettings.get(INDEX_SOFT_DELETES_RETENTION_LEASE_PERIOD_SETTING).millis();
        this.warmerEnabled = this.scopedSettings.get(INDEX_WARMER_ENABLED_SETTING);
        this.maxResultWindow = this.scopedSettings.get(MAX_RESULT_WINDOW_SETTING);
        this.maxInnerResultWindow = this.scopedSettings.get(MAX_INNER_RESULT_WINDOW_SETTING);
        this.maxRescoreWindow = this.scopedSettings.get(MAX_RESCORE_WINDOW_SETTING);
        this.maxDocvalueFields = this.scopedSettings.get(MAX_DOCVALUE_FIELDS_SEARCH_SETTING);
        this.maxScriptFields = this.scopedSettings.get(MAX_SCRIPT_FIELDS_SETTING);
        this.maxTokenCount = this.scopedSettings.get(MAX_TOKEN_COUNT_SETTING);
        this.maxNgramDiff = this.scopedSettings.get(MAX_NGRAM_DIFF_SETTING);
        this.maxShingleDiff = this.scopedSettings.get(MAX_SHINGLE_DIFF_SETTING);
        this.maxRefreshListeners = this.scopedSettings.get(MAX_REFRESH_LISTENERS_PER_SHARD);
        this.maxSlicesPerScroll = this.scopedSettings.get(MAX_SLICES_PER_SCROLL);
        this.maxAnalyzedOffset = this.scopedSettings.get(MAX_ANALYZED_OFFSET_SETTING);
        this.weightMatchesEnabled = this.scopedSettings.get(WEIGHT_MATCHES_MODE_ENABLED_SETTING);
        this.maxTermsCount = this.scopedSettings.get(MAX_TERMS_COUNT_SETTING);
        this.maxRegexLength = this.scopedSettings.get(MAX_REGEX_LENGTH_SETTING);
        this.mergePolicyConfig = new MergePolicyConfig(this.logger, this);
        this.indexSortConfig = new IndexSortConfig(this);
        this.searchIdleAfter = this.scopedSettings.get(INDEX_SEARCH_IDLE_AFTER);
        this.defaultPipeline = this.scopedSettings.get(DEFAULT_PIPELINE);
        this.mappingNestedFieldsLimit = this.scopedSettings.get(MapperService.INDEX_MAPPING_NESTED_FIELDS_LIMIT_SETTING);
        this.mappingNestedDocsLimit = this.scopedSettings.get(MapperService.INDEX_MAPPING_NESTED_DOCS_LIMIT_SETTING);
        this.mappingTotalFieldsLimit = this.scopedSettings.get(MapperService.INDEX_MAPPING_TOTAL_FIELDS_LIMIT_SETTING);
        this.ignoreDynamicFieldsBeyondLimit = this.scopedSettings.get(MapperService.INDEX_MAPPING_IGNORE_DYNAMIC_BEYOND_LIMIT_SETTING);
        this.ignoreDynamicFieldNamesBeyondLimit = this.scopedSettings.get(MapperService.INDEX_MAPPING_IGNORE_DYNAMIC_BEYOND_FIELD_NAME_LENGTH_SETTING);
        this.mappingDepthLimit = this.scopedSettings.get(MapperService.INDEX_MAPPING_DEPTH_LIMIT_SETTING);
        this.mappingFieldNameLengthLimit = this.scopedSettings.get(MapperService.INDEX_MAPPING_FIELD_NAME_LENGTH_LIMIT_SETTING);
        this.mappingDimensionFieldsLimit = this.scopedSettings.get(MapperService.INDEX_MAPPING_DIMENSION_FIELDS_LIMIT_SETTING);
        this.indexRouting = IndexRouting.fromIndexMetadata(indexMetadata);
        this.sourceKeepMode = this.scopedSettings.get(Mapper.SYNTHETIC_SOURCE_KEEP_INDEX_SETTING);
        this.es87TSDBCodecEnabled = this.scopedSettings.get(TIME_SERIES_ES87TSDB_CODEC_ENABLED_SETTING);
        this.logsdbRouteOnSortFields = this.scopedSettings.get(LOGSDB_ROUTE_ON_SORT_FIELDS);
        this.logsdbSortOnHostName = this.scopedSettings.get(LOGSDB_SORT_ON_HOST_NAME);
        this.logsdbAddHostNameField = this.scopedSettings.get(LOGSDB_ADD_HOST_NAME_FIELD);
        this.skipIgnoredSourceWrite = this.scopedSettings.get(IgnoredSourceFieldMapper.SKIP_IGNORED_SOURCE_WRITE_SETTING);
        this.skipIgnoredSourceRead = this.scopedSettings.get(IgnoredSourceFieldMapper.SKIP_IGNORED_SOURCE_READ_SETTING);
        this.hnswFilterHeuristic = this.scopedSettings.get(DenseVectorFieldMapper.HNSW_FILTER_HEURISTIC);
        this.earlyTermination = this.scopedSettings.get(DenseVectorFieldMapper.HNSW_EARLY_TERMINATION);
        this.indexMappingSourceMode = this.scopedSettings.get(INDEX_MAPPER_SOURCE_MODE_SETTING);
        this.recoverySourceEnabled = RecoverySettings.INDICES_RECOVERY_SOURCE_ENABLED_SETTING.get(nodeSettings);
        this.recoverySourceSyntheticEnabled = !DiscoveryNode.isStateless(nodeSettings) && this.scopedSettings.get(RECOVERY_USE_SYNTHETIC_SOURCE_SETTING) != false;
        this.useDocValuesSkipper = DOC_VALUES_SKIPPER && this.scopedSettings.get(USE_DOC_VALUES_SKIPPER) != false;
        this.seqNoIndexOptions = this.scopedSettings.get(SEQ_NO_INDEX_OPTIONS_SETTING);
        this.useTimeSeriesDocValuesFormat = this.scopedSettings.get(USE_TIME_SERIES_DOC_VALUES_FORMAT_SETTING);
        boolean bl = useSyntheticId = TSDB_SYNTHETIC_ID_FEATURE_FLAG && this.scopedSettings.get(USE_SYNTHETIC_ID) != false;
        if (indexMetadata.useTimeSeriesSyntheticId() != useSyntheticId) {
            assert (false);
            throw new IllegalArgumentException(String.format(Locale.ROOT, "The setting [%s] is set to [%s] but index metadata has a different value [%s].", USE_SYNTHETIC_ID.getKey(), useSyntheticId, indexMetadata.useTimeSeriesSyntheticId()));
        }
        if (useSyntheticId) {
            assert (TSDB_SYNTHETIC_ID_FEATURE_FLAG);
            assert (indexMetadata.useTimeSeriesSyntheticId());
            assert (indexMetadata.getIndexMode() == IndexMode.TIME_SERIES) : indexMetadata.getIndexMode();
            assert (indexMetadata.getCreationVersion().onOrAfter(IndexVersions.TIME_SERIES_USE_SYNTHETIC_ID));
            this.useTimeSeriesSyntheticId = true;
        } else {
            this.useTimeSeriesSyntheticId = false;
        }
        if (this.recoverySourceSyntheticEnabled) {
            if (DiscoveryNode.isStateless(this.settings)) {
                throw new IllegalArgumentException("synthetic recovery source is only allowed in stateful");
            }
            if (this.version.before(IndexVersions.USE_SYNTHETIC_SOURCE_FOR_RECOVERY) && !this.version.between(IndexVersions.USE_SYNTHETIC_SOURCE_FOR_RECOVERY_BACKPORT, IndexVersions.UPGRADE_TO_LUCENE_10_0_0)) {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "The setting [%s] is unavailable on this cluster because some nodes are running older versions that do not support it. Please upgrade all nodes to the latest version and try again.", RECOVERY_USE_SYNTHETIC_SOURCE_SETTING.getKey()));
            }
        }
        this.scopedSettings.addSettingsUpdateConsumer(MergePolicyConfig.INDEX_COMPOUND_FORMAT_SETTING, this.mergePolicyConfig::setCompoundFormatThreshold);
        this.scopedSettings.addSettingsUpdateConsumer(MergePolicyConfig.INDEX_MERGE_POLICY_TYPE_SETTING, this.mergePolicyConfig::setMergePolicyType);
        this.scopedSettings.addSettingsUpdateConsumer(MergePolicyConfig.INDEX_MERGE_POLICY_DELETES_PCT_ALLOWED_SETTING, this.mergePolicyConfig::setDeletesPctAllowed);
        this.scopedSettings.addSettingsUpdateConsumer(MergePolicyConfig.INDEX_MERGE_POLICY_EXPUNGE_DELETES_ALLOWED_SETTING, this.mergePolicyConfig::setExpungeDeletesAllowed);
        this.scopedSettings.addSettingsUpdateConsumer(MergePolicyConfig.INDEX_MERGE_POLICY_FLOOR_SEGMENT_SETTING, this.mergePolicyConfig::setFloorSegmentSetting);
        this.scopedSettings.addSettingsUpdateConsumer(MergePolicyConfig.INDEX_MERGE_POLICY_MAX_MERGE_AT_ONCE_SETTING, this.mergePolicyConfig::setMaxMergesAtOnce);
        this.scopedSettings.addSettingsUpdateConsumer(MergePolicyConfig.INDEX_MERGE_POLICY_MAX_MERGE_AT_ONCE_EXPLICIT_SETTING, ignored -> {});
        this.scopedSettings.addSettingsUpdateConsumer(MergePolicyConfig.INDEX_MERGE_POLICY_MAX_MERGED_SEGMENT_SETTING, this.mergePolicyConfig::setMaxMergedSegment);
        this.scopedSettings.addSettingsUpdateConsumer(MergePolicyConfig.INDEX_MERGE_POLICY_SEGMENTS_PER_TIER_SETTING, this.mergePolicyConfig::setSegmentsPerTier);
        this.scopedSettings.addSettingsUpdateConsumer(MergePolicyConfig.INDEX_MERGE_POLICY_MERGE_FACTOR_SETTING, this.mergePolicyConfig::setMergeFactor);
        this.scopedSettings.addSettingsUpdateConsumer(MergeSchedulerConfig.MAX_THREAD_COUNT_SETTING, MergeSchedulerConfig.MAX_MERGE_COUNT_SETTING, this.mergeSchedulerConfig::setMaxThreadAndMergeCount);
        this.scopedSettings.addSettingsUpdateConsumer(MergeSchedulerConfig.AUTO_THROTTLE_SETTING, this.mergeSchedulerConfig::setAutoThrottle);
        this.scopedSettings.addSettingsUpdateConsumer(INDEX_TRANSLOG_DURABILITY_SETTING, this::setTranslogDurability);
        this.scopedSettings.addSettingsUpdateConsumer(INDEX_TRANSLOG_SYNC_INTERVAL_SETTING, this::setTranslogSyncInterval);
        this.scopedSettings.addSettingsUpdateConsumer(MAX_RESULT_WINDOW_SETTING, this::setMaxResultWindow);
        this.scopedSettings.addSettingsUpdateConsumer(MAX_INNER_RESULT_WINDOW_SETTING, this::setMaxInnerResultWindow);
        this.scopedSettings.addSettingsUpdateConsumer(MAX_RESCORE_WINDOW_SETTING, this::setMaxRescoreWindow);
        this.scopedSettings.addSettingsUpdateConsumer(MAX_DOCVALUE_FIELDS_SEARCH_SETTING, this::setMaxDocvalueFields);
        this.scopedSettings.addSettingsUpdateConsumer(MAX_SCRIPT_FIELDS_SETTING, this::setMaxScriptFields);
        this.scopedSettings.addSettingsUpdateConsumer(MAX_TOKEN_COUNT_SETTING, this::setMaxTokenCount);
        this.scopedSettings.addSettingsUpdateConsumer(MAX_NGRAM_DIFF_SETTING, this::setMaxNgramDiff);
        this.scopedSettings.addSettingsUpdateConsumer(MAX_SHINGLE_DIFF_SETTING, this::setMaxShingleDiff);
        this.scopedSettings.addSettingsUpdateConsumer(INDEX_WARMER_ENABLED_SETTING, this::setEnableWarmer);
        this.scopedSettings.addSettingsUpdateConsumer(INDEX_GC_DELETES_SETTING, this::setGCDeletes);
        this.scopedSettings.addSettingsUpdateConsumer(INDEX_TRANSLOG_FLUSH_THRESHOLD_SIZE_SETTING, this::setTranslogFlushThresholdSize);
        this.scopedSettings.addSettingsUpdateConsumer(INDEX_TRANSLOG_FLUSH_THRESHOLD_AGE_SETTING, this::setTranslogFlushThresholdAge);
        this.scopedSettings.addSettingsUpdateConsumer(INDEX_FLUSH_AFTER_MERGE_THRESHOLD_SIZE_SETTING, this::setFlushAfterMergeThresholdSize);
        this.scopedSettings.addSettingsUpdateConsumer(INDEX_TRANSLOG_GENERATION_THRESHOLD_SIZE_SETTING, this::setGenerationThresholdSize);
        this.scopedSettings.addSettingsUpdateConsumer(INDEX_REFRESH_INTERVAL_SETTING, this::setRefreshInterval);
        this.scopedSettings.addSettingsUpdateConsumer(MAX_REFRESH_LISTENERS_PER_SHARD, this::setMaxRefreshListeners);
        this.scopedSettings.addSettingsUpdateConsumer(MAX_ANALYZED_OFFSET_SETTING, this::setHighlightMaxAnalyzedOffset);
        this.scopedSettings.addSettingsUpdateConsumer(WEIGHT_MATCHES_MODE_ENABLED_SETTING, this::setWeightMatchesEnabled);
        this.scopedSettings.addSettingsUpdateConsumer(MAX_TERMS_COUNT_SETTING, this::setMaxTermsCount);
        this.scopedSettings.addSettingsUpdateConsumer(MAX_SLICES_PER_SCROLL, this::setMaxSlicesPerScroll);
        this.scopedSettings.addSettingsUpdateConsumer(DEFAULT_FIELD_SETTING, this::setDefaultFields);
        this.scopedSettings.addSettingsUpdateConsumer(INDEX_SEARCH_IDLE_AFTER, this::setSearchIdleAfter);
        this.scopedSettings.addSettingsUpdateConsumer(MAX_REGEX_LENGTH_SETTING, this::setMaxRegexLength);
        this.scopedSettings.addSettingsUpdateConsumer(DEFAULT_PIPELINE, this::setDefaultPipeline);
        this.scopedSettings.addSettingsUpdateConsumer(FINAL_PIPELINE, this::setRequiredPipeline);
        this.scopedSettings.addSettingsUpdateConsumer(INDEX_SOFT_DELETES_RETENTION_OPERATIONS_SETTING, this::setSoftDeleteRetentionOperations);
        this.scopedSettings.addSettingsUpdateConsumer(INDEX_SOFT_DELETES_RETENTION_LEASE_PERIOD_SETTING, this::setRetentionLeaseMillis);
        this.scopedSettings.addSettingsUpdateConsumer(MapperService.INDEX_MAPPING_NESTED_FIELDS_LIMIT_SETTING, this::setMappingNestedFieldsLimit);
        this.scopedSettings.addSettingsUpdateConsumer(MapperService.INDEX_MAPPING_NESTED_DOCS_LIMIT_SETTING, this::setMappingNestedDocsLimit);
        this.scopedSettings.addSettingsUpdateConsumer(MapperService.INDEX_MAPPING_IGNORE_DYNAMIC_BEYOND_LIMIT_SETTING, this::setIgnoreDynamicFieldsBeyondLimit);
        this.scopedSettings.addSettingsUpdateConsumer(MapperService.INDEX_MAPPING_IGNORE_DYNAMIC_BEYOND_FIELD_NAME_LENGTH_SETTING, this::setIgnoreDynamicFieldNamesBeyondLimit);
        this.scopedSettings.addSettingsUpdateConsumer(MapperService.INDEX_MAPPING_TOTAL_FIELDS_LIMIT_SETTING, this::setMappingTotalFieldsLimit);
        this.scopedSettings.addSettingsUpdateConsumer(MapperService.INDEX_MAPPING_DEPTH_LIMIT_SETTING, this::setMappingDepthLimit);
        this.scopedSettings.addSettingsUpdateConsumer(MapperService.INDEX_MAPPING_FIELD_NAME_LENGTH_LIMIT_SETTING, this::setMappingFieldNameLengthLimit);
        this.scopedSettings.addSettingsUpdateConsumer(MapperService.INDEX_MAPPING_DIMENSION_FIELDS_LIMIT_SETTING, this::setMappingDimensionFieldsLimit);
        this.scopedSettings.addSettingsUpdateConsumer(IgnoredSourceFieldMapper.SKIP_IGNORED_SOURCE_WRITE_SETTING, this::setSkipIgnoredSourceWrite);
        this.scopedSettings.addSettingsUpdateConsumer(IgnoredSourceFieldMapper.SKIP_IGNORED_SOURCE_READ_SETTING, this::setSkipIgnoredSourceRead);
        this.scopedSettings.addSettingsUpdateConsumer(DenseVectorFieldMapper.HNSW_FILTER_HEURISTIC, this::setHnswFilterHeuristic);
        this.scopedSettings.addSettingsUpdateConsumer(DenseVectorFieldMapper.HNSW_EARLY_TERMINATION, this::setHnswEarlyTermination);
    }

    private void setSearchIdleAfter(TimeValue searchIdleAfter) {
        this.searchIdleAfter = searchIdleAfter;
    }

    private void setTranslogFlushThresholdSize(ByteSizeValue byteSizeValue) {
        this.flushThresholdSize = byteSizeValue;
    }

    private void setTranslogFlushThresholdAge(TimeValue timeValue) {
        this.flushThresholdAge = timeValue;
    }

    private void setFlushAfterMergeThresholdSize(ByteSizeValue byteSizeValue) {
        this.flushAfterMergeThresholdSize = byteSizeValue;
    }

    private void setGenerationThresholdSize(ByteSizeValue generationThresholdSize) {
        this.generationThresholdSize = generationThresholdSize;
    }

    private void setGCDeletes(TimeValue timeValue) {
        this.gcDeletesInMillis = timeValue.getMillis();
    }

    private void setRefreshInterval(TimeValue timeValue) {
        this.refreshInterval = timeValue;
    }

    public Settings getSettings() {
        return this.settings;
    }

    public Index getIndex() {
        return this.index;
    }

    public String getUUID() {
        return this.getIndex().getUUID();
    }

    public boolean hasCustomDataPath() {
        return Strings.isNotEmpty((CharSequence)this.customDataPath());
    }

    public String customDataPath() {
        return IndexMetadata.INDEX_DATA_PATH_SETTING.get(this.settings);
    }

    public IndexVersion getIndexVersionCreated() {
        return this.version;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public IndexMetadata getIndexMetadata() {
        return this.indexMetadata;
    }

    public int getNumberOfShards() {
        return this.numberOfShards;
    }

    public int getNumberOfReplicas() {
        return this.settings.getAsInt("index.number_of_replicas", null);
    }

    public IndexMode getMode() {
        return this.mode;
    }

    public Settings getNodeSettings() {
        return this.nodeSettings;
    }

    public synchronized boolean updateIndexMetadata(IndexMetadata indexMetadata) {
        String restoreUUID;
        Settings newSettings = indexMetadata.getSettings();
        IndexVersion newIndexVersion = IndexMetadata.SETTING_INDEX_VERSION_CREATED.get(newSettings);
        if (!this.version.equals(newIndexVersion)) {
            throw new IllegalArgumentException("version mismatch on settings update expected: " + this.version.toReleaseVersion() + " but was: " + newIndexVersion.toReleaseVersion());
        }
        IndexVersion newCompatibilityVersion = IndexMetadata.SETTING_INDEX_VERSION_COMPATIBILITY.get(newSettings);
        IndexVersion compatibilityVersion = IndexMetadata.SETTING_INDEX_VERSION_COMPATIBILITY.get(this.settings);
        if (!compatibilityVersion.equals(newCompatibilityVersion)) {
            throw new IllegalArgumentException("compatibility version mismatch on settings update expected: " + compatibilityVersion.toReleaseVersion() + " but was: " + newCompatibilityVersion.toReleaseVersion());
        }
        String newUUID = newSettings.get("index.uuid", "_na_");
        if (!newUUID.equals(this.getUUID())) {
            throw new IllegalArgumentException("uuid mismatch on settings update expected: " + this.getUUID() + " but was: " + newUUID);
        }
        String newRestoreUUID = newSettings.get("index.history.uuid", "_na_");
        if (!newRestoreUUID.equals(restoreUUID = this.settings.get("index.history.uuid", "_na_"))) {
            throw new IllegalArgumentException("uuid mismatch on settings update expected: " + restoreUUID + " but was: " + newRestoreUUID);
        }
        this.indexMetadata = indexMetadata;
        Settings newIndexSettings = Settings.builder().put(this.nodeSettings).put(newSettings).build();
        if (IndexSettings.same(this.settings, newIndexSettings)) {
            return false;
        }
        this.scopedSettings.applySettings(newSettings);
        this.settings = newIndexSettings;
        return true;
    }

    public static boolean same(Settings left, Settings right) {
        if (left.equals(right)) {
            return true;
        }
        return left.getByPrefix("index.").equals(right.getByPrefix("index.")) && left.getByPrefix("archived.").equals(right.getByPrefix("archived."));
    }

    public Translog.Durability getTranslogDurability() {
        return this.durability;
    }

    private void setTranslogDurability(Translog.Durability durability) {
        this.durability = durability;
    }

    public boolean isWarmerEnabled() {
        return this.warmerEnabled;
    }

    private void setEnableWarmer(boolean enableWarmer) {
        this.warmerEnabled = enableWarmer;
    }

    public TimeValue getTranslogSyncInterval() {
        return this.syncInterval;
    }

    public void setTranslogSyncInterval(TimeValue translogSyncInterval) {
        this.syncInterval = translogSyncInterval;
    }

    public TimeValue getRefreshInterval() {
        return this.refreshInterval;
    }

    public boolean isFastRefresh() {
        return this.fastRefresh;
    }

    public ByteSizeValue getFlushThresholdSize(ByteSizeValue totalDiskSpace) {
        long onePercentOfTotalDiskSpace = totalDiskSpace.getBytes() / 100L;
        if (onePercentOfTotalDiskSpace <= ByteSizeUnit.MB.toBytes(10L)) {
            onePercentOfTotalDiskSpace = ByteSizeUnit.MB.toBytes(10L);
        }
        assert (onePercentOfTotalDiskSpace > (long)Translog.DEFAULT_HEADER_SIZE_IN_BYTES);
        if (onePercentOfTotalDiskSpace < this.flushThresholdSize.getBytes()) {
            return ByteSizeValue.of(onePercentOfTotalDiskSpace, ByteSizeUnit.BYTES);
        }
        return this.flushThresholdSize;
    }

    public TimeValue getFlushThresholdAge() {
        return this.flushThresholdAge;
    }

    public ByteSizeValue getFlushAfterMergeThresholdSize() {
        return this.flushAfterMergeThresholdSize;
    }

    public ByteSizeValue getGenerationThresholdSize() {
        return this.generationThresholdSize;
    }

    public MergeSchedulerConfig getMergeSchedulerConfig() {
        return this.mergeSchedulerConfig;
    }

    public int getMaxResultWindow() {
        return this.maxResultWindow;
    }

    private void setMaxResultWindow(int maxResultWindow) {
        this.maxResultWindow = maxResultWindow;
    }

    public int getMaxInnerResultWindow() {
        return this.maxInnerResultWindow;
    }

    private void setMaxInnerResultWindow(int maxInnerResultWindow) {
        this.maxInnerResultWindow = maxInnerResultWindow;
    }

    public int getMaxRescoreWindow() {
        return this.maxRescoreWindow;
    }

    private void setMaxRescoreWindow(int maxRescoreWindow) {
        this.maxRescoreWindow = maxRescoreWindow;
    }

    public int getMaxDocvalueFields() {
        return this.maxDocvalueFields;
    }

    private void setMaxDocvalueFields(int maxDocvalueFields) {
        this.maxDocvalueFields = maxDocvalueFields;
    }

    public int getMaxTokenCount() {
        return this.maxTokenCount;
    }

    private void setMaxTokenCount(int maxTokenCount) {
        this.maxTokenCount = maxTokenCount;
    }

    public int getMaxNgramDiff() {
        return this.maxNgramDiff;
    }

    private void setMaxNgramDiff(int maxNgramDiff) {
        this.maxNgramDiff = maxNgramDiff;
    }

    public int getMaxShingleDiff() {
        return this.maxShingleDiff;
    }

    private void setMaxShingleDiff(int maxShingleDiff) {
        this.maxShingleDiff = maxShingleDiff;
    }

    public int getHighlightMaxAnalyzedOffset() {
        return this.maxAnalyzedOffset;
    }

    private void setHighlightMaxAnalyzedOffset(int maxAnalyzedOffset) {
        this.maxAnalyzedOffset = maxAnalyzedOffset;
    }

    public boolean isWeightMatchesEnabled() {
        return this.weightMatchesEnabled;
    }

    private void setWeightMatchesEnabled(boolean value) {
        this.weightMatchesEnabled = value;
    }

    public int getMaxTermsCount() {
        return this.maxTermsCount;
    }

    private void setMaxTermsCount(int maxTermsCount) {
        this.maxTermsCount = maxTermsCount;
    }

    public int getMaxScriptFields() {
        return this.maxScriptFields;
    }

    private void setMaxScriptFields(int maxScriptFields) {
        this.maxScriptFields = maxScriptFields;
    }

    public long getGcDeletesInMillis() {
        return this.gcDeletesInMillis;
    }

    public MergePolicy getMergePolicy(boolean isTimeBasedIndex) {
        return this.mergePolicyConfig.getMergePolicy(isTimeBasedIndex);
    }

    public <T> T getValue(Setting<T> setting) {
        return this.scopedSettings.get(setting);
    }

    public int getMaxRefreshListeners() {
        return this.maxRefreshListeners;
    }

    private void setMaxRefreshListeners(int maxRefreshListeners) {
        this.maxRefreshListeners = maxRefreshListeners;
    }

    public int getMaxSlicesPerScroll() {
        return this.maxSlicesPerScroll;
    }

    private void setMaxSlicesPerScroll(int value) {
        this.maxSlicesPerScroll = value;
    }

    public int getMaxRegexLength() {
        return this.maxRegexLength;
    }

    private void setMaxRegexLength(int maxRegexLength) {
        this.maxRegexLength = maxRegexLength;
    }

    public IndexSortConfig getIndexSortConfig() {
        return this.indexSortConfig;
    }

    public IndexScopedSettings getScopedSettings() {
        return this.scopedSettings;
    }

    public boolean isExplicitRefresh() {
        return INDEX_REFRESH_INTERVAL_SETTING.exists(this.settings);
    }

    public TimeValue getSearchIdleAfter() {
        return this.searchIdleAfter;
    }

    public String getDefaultPipeline() {
        return this.defaultPipeline;
    }

    public void setDefaultPipeline(String defaultPipeline) {
        this.defaultPipeline = defaultPipeline;
    }

    public String getRequiredPipeline() {
        return this.requiredPipeline;
    }

    public void setRequiredPipeline(String requiredPipeline) {
        this.requiredPipeline = requiredPipeline;
    }

    public boolean isSoftDeleteEnabled() {
        return this.softDeleteEnabled;
    }

    private void setSoftDeleteRetentionOperations(long ops) {
        this.softDeleteRetentionOperations = ops;
    }

    public long getSoftDeleteRetentionOperations() {
        return this.softDeleteRetentionOperations;
    }

    public long getMappingNestedFieldsLimit() {
        return this.mappingNestedFieldsLimit;
    }

    private void setMappingNestedFieldsLimit(long value) {
        this.mappingNestedFieldsLimit = value;
    }

    public long getMappingNestedDocsLimit() {
        return this.mappingNestedDocsLimit;
    }

    private void setMappingNestedDocsLimit(long value) {
        this.mappingNestedDocsLimit = value;
    }

    public long getMappingTotalFieldsLimit() {
        return this.mappingTotalFieldsLimit;
    }

    private void setMappingTotalFieldsLimit(long value) {
        this.mappingTotalFieldsLimit = value;
    }

    private void setIgnoreDynamicFieldsBeyondLimit(boolean ignoreDynamicFieldsBeyondLimit) {
        this.ignoreDynamicFieldsBeyondLimit = ignoreDynamicFieldsBeyondLimit;
    }

    private void setIgnoreDynamicFieldNamesBeyondLimit(boolean ignoreDynamicFieldNamesBeyondLimit) {
        this.ignoreDynamicFieldNamesBeyondLimit = ignoreDynamicFieldNamesBeyondLimit;
    }

    public boolean isIgnoreDynamicFieldsBeyondLimit() {
        return this.ignoreDynamicFieldsBeyondLimit;
    }

    public boolean isIgnoreDynamicFieldNamesBeyondLimit() {
        return this.ignoreDynamicFieldNamesBeyondLimit;
    }

    public long getMappingDepthLimit() {
        return this.mappingDepthLimit;
    }

    private void setMappingDepthLimit(long value) {
        this.mappingDepthLimit = value;
    }

    public long getMappingFieldNameLengthLimit() {
        return this.mappingFieldNameLengthLimit;
    }

    private void setMappingFieldNameLengthLimit(long value) {
        this.mappingFieldNameLengthLimit = value;
    }

    public long getMappingDimensionFieldsLimit() {
        return this.mappingDimensionFieldsLimit;
    }

    private void setMappingDimensionFieldsLimit(long value) {
        this.mappingDimensionFieldsLimit = value;
    }

    public boolean getSkipIgnoredSourceWrite() {
        return this.skipIgnoredSourceWrite;
    }

    private void setSkipIgnoredSourceWrite(boolean value) {
        this.skipIgnoredSourceWrite = value;
    }

    public boolean getSkipIgnoredSourceRead() {
        return this.skipIgnoredSourceRead;
    }

    private void setSkipIgnoredSourceRead(boolean value) {
        this.skipIgnoredSourceRead = value;
    }

    public SourceFieldMapper.Mode getIndexMappingSourceMode() {
        return this.indexMappingSourceMode;
    }

    public IgnoredSourceFieldMapper.IgnoredSourceFormat getIgnoredSourceFormat() {
        if (this.getIndexMappingSourceMode() == SourceFieldMapper.Mode.SYNTHETIC) {
            return IgnoredSourceFieldMapper.ignoredSourceFormat(this.getIndexVersionCreated());
        }
        return IgnoredSourceFieldMapper.IgnoredSourceFormat.NO_IGNORED_SOURCE;
    }

    public boolean isRecoverySourceEnabled() {
        return this.recoverySourceEnabled;
    }

    public boolean isRecoverySourceSyntheticEnabled() {
        return this.recoverySourceSyntheticEnabled;
    }

    public boolean useDocValuesSkipper() {
        return this.useDocValuesSkipper;
    }

    public boolean useTimeSeriesSyntheticId() {
        return this.useTimeSeriesSyntheticId;
    }

    public boolean useTimeSeriesDocValuesFormat() {
        return this.useTimeSeriesDocValuesFormat;
    }

    public TimestampBounds getTimestampBounds() {
        return this.timestampBounds;
    }

    public IndexRouting getIndexRouting() {
        return this.indexRouting;
    }

    public DenseVectorFieldMapper.FilterHeuristic getHnswFilterHeuristic() {
        return this.hnswFilterHeuristic;
    }

    private void setHnswFilterHeuristic(DenseVectorFieldMapper.FilterHeuristic heuristic) {
        this.hnswFilterHeuristic = heuristic;
    }

    public boolean getHnswEarlyTermination() {
        return this.earlyTermination;
    }

    private void setHnswEarlyTermination(boolean earlyTermination) {
        this.earlyTermination = earlyTermination;
    }

    public SeqNoFieldMapper.SeqNoIndexOptions seqNoIndexOptions() {
        return this.seqNoIndexOptions;
    }

    static class RefreshIntervalValidator
    implements Setting.Validator<TimeValue> {
        static final String STATELESS_ALLOW_INDEX_REFRESH_INTERVAL_OVERRIDE = "es.stateless.allow.index.refresh_interval.override";
        private static final boolean IS_OVERRIDE_ALLOWED = Booleans.parseBoolean((String)System.getProperty("es.stateless.allow.index.refresh_interval.override", "false"));

        RefreshIntervalValidator() {
        }

        @Override
        public void validate(TimeValue value) {
        }

        @Override
        public void validate(TimeValue value, Map<Setting<?>, Object> settings) {
            String existingShardsAllocator = (String)settings.get(ExistingShardsAllocator.EXISTING_SHARDS_ALLOCATOR_SETTING);
            Boolean fastRefresh = (Boolean)settings.get(INDEX_FAST_REFRESH_SETTING);
            IndexVersion indexVersion = (IndexVersion)settings.get(IndexMetadata.SETTING_INDEX_VERSION_CREATED);
            if (existingShardsAllocator.equals("stateless") && !fastRefresh.booleanValue() && value.compareTo(TimeValue.ZERO) > 0 && value.compareTo(STATELESS_MIN_NON_FAST_REFRESH_INTERVAL) < 0 && indexVersion.after(IndexVersions.V_8_10_0) && !IS_OVERRIDE_ALLOWED) {
                throw new IllegalArgumentException("index setting [" + INDEX_REFRESH_INTERVAL_SETTING.getKey() + "=" + String.valueOf(value) + "] should be either " + String.valueOf(TimeValue.MINUS_ONE) + " or equal to or greater than " + String.valueOf(STATELESS_MIN_NON_FAST_REFRESH_INTERVAL));
            }
        }

        @Override
        public Iterator<Setting<?>> settings() {
            return REFRESH_INTERVAL_VALIDATOR_SETTINGS_LIST.iterator();
        }
    }
}

