/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation.allocator;

import java.util.Iterator;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.allocation.allocator.BalancedShardsAllocator;
import org.elasticsearch.cluster.routing.allocation.allocator.BalancerSettings;
import org.elasticsearch.cluster.routing.allocation.allocator.BalancingWeights;
import org.elasticsearch.cluster.routing.allocation.allocator.BalancingWeightsFactory;
import org.elasticsearch.cluster.routing.allocation.allocator.NodeSorters;
import org.elasticsearch.cluster.routing.allocation.allocator.WeightFunction;
import org.elasticsearch.common.collect.Iterators;

public class GlobalBalancingWeightsFactory
implements BalancingWeightsFactory {
    private final BalancerSettings balancerSettings;

    public GlobalBalancingWeightsFactory(BalancerSettings balancerSettings) {
        this.balancerSettings = balancerSettings;
    }

    @Override
    public BalancingWeights create() {
        return new GlobalBalancingWeights(this);
    }

    private class GlobalBalancingWeights
    implements BalancingWeights {
        private final WeightFunction weightFunction;
        private final boolean diskUsageIgnored;

        GlobalBalancingWeights(GlobalBalancingWeightsFactory globalBalancingWeightsFactory) {
            float diskUsageBalanceFactor = globalBalancingWeightsFactory.balancerSettings.getDiskUsageBalanceFactor();
            this.weightFunction = new WeightFunction(globalBalancingWeightsFactory.balancerSettings.getShardBalanceFactor(), globalBalancingWeightsFactory.balancerSettings.getIndexBalanceFactor(), globalBalancingWeightsFactory.balancerSettings.getWriteLoadBalanceFactor(), diskUsageBalanceFactor);
            this.diskUsageIgnored = diskUsageBalanceFactor == 0.0f;
        }

        @Override
        public WeightFunction weightFunctionForShard(ShardRouting shard) {
            return this.weightFunction;
        }

        @Override
        public WeightFunction weightFunctionForNode(RoutingNode node) {
            return this.weightFunction;
        }

        @Override
        public NodeSorters createNodeSorters(BalancedShardsAllocator.ModelNode[] modelNodes, BalancedShardsAllocator.Balancer balancer) {
            return new GlobalNodeSorters(new BalancedShardsAllocator.NodeSorter(modelNodes, this.weightFunction, balancer));
        }

        @Override
        public boolean diskUsageIgnored() {
            return this.diskUsageIgnored;
        }

        private record GlobalNodeSorters(BalancedShardsAllocator.NodeSorter nodeSorter) implements NodeSorters
        {
            @Override
            public BalancedShardsAllocator.NodeSorter sorterForShard(ShardRouting shard) {
                return this.nodeSorter;
            }

            @Override
            public Iterator<BalancedShardsAllocator.NodeSorter> iterator() {
                return Iterators.single(this.nodeSorter);
            }
        }
    }
}

