/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.ClusterInfo;
import org.elasticsearch.cluster.DiskUsage;
import org.elasticsearch.cluster.EstimatedHeapUsage;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.cluster.routing.ExpectedShardSizeEstimator;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.ShardMovementWriteLoadSimulator;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.UnassignedInfo;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.common.util.CopyOnFirstWriteMap;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.shard.ShardId;

public class ClusterInfoSimulator {
    private static final Logger logger = LogManager.getLogger(ClusterInfoSimulator.class);
    private final RoutingAllocation allocation;
    private final Map<String, DiskUsage> leastAvailableSpaceUsage;
    private final Map<String, DiskUsage> mostAvailableSpaceUsage;
    private final CopyOnFirstWriteMap<String, Long> shardSizes;
    private final Map<String, EstimatedHeapUsage> estimatedHeapUsages;
    private final ShardMovementWriteLoadSimulator shardMovementWriteLoadSimulator;

    public ClusterInfoSimulator(RoutingAllocation allocation) {
        this.allocation = allocation;
        this.leastAvailableSpaceUsage = ClusterInfoSimulator.getAdjustedDiskSpace(allocation, allocation.clusterInfo().getNodeLeastAvailableDiskUsages());
        this.mostAvailableSpaceUsage = ClusterInfoSimulator.getAdjustedDiskSpace(allocation, allocation.clusterInfo().getNodeMostAvailableDiskUsages());
        this.shardSizes = new CopyOnFirstWriteMap<String, Long>(allocation.clusterInfo().shardSizes);
        this.estimatedHeapUsages = allocation.clusterInfo().getEstimatedHeapUsages();
        this.shardMovementWriteLoadSimulator = new ShardMovementWriteLoadSimulator(allocation);
    }

    private static Map<String, DiskUsage> getAdjustedDiskSpace(RoutingAllocation allocation, Map<String, DiskUsage> diskUsage) {
        HashMap<String, DiskUsage> diskUsageCopy = new HashMap<String, DiskUsage>(diskUsage);
        for (Map.Entry<String, DiskUsage> entry : diskUsageCopy.entrySet()) {
            RoutingNode node;
            String nodeId = entry.getKey();
            DiskUsage usage = entry.getValue();
            ClusterInfo.ReservedSpace reserved = allocation.clusterInfo().getReservedSpace(nodeId, usage.path());
            if (reserved.total() == 0L || (node = allocation.routingNodes().node(nodeId)) == null) continue;
            long adjustment = 0L;
            for (ShardId shardId : reserved.shardIds()) {
                ShardRouting shard = node.getByShardId(shardId);
                if (shard == null) continue;
                long expectedSize = ExpectedShardSizeEstimator.getExpectedShardSize(shard, 0L, allocation);
                adjustment += expectedSize;
            }
            entry.setValue(ClusterInfoSimulator.updateWithFreeBytes(usage, adjustment -= reserved.total()));
        }
        return diskUsageCopy;
    }

    public void simulateShardStarted(ShardRouting shard) {
        assert (shard.initializing()) : "expected an initializing shard, but got: " + String.valueOf(shard);
        ProjectMetadata project = this.allocation.metadata().projectFor(shard.index());
        long size = ExpectedShardSizeEstimator.getExpectedShardSize(shard, shard.getExpectedShardSize(), (shardId, primary) -> this.shardSizes.get(ClusterInfo.shardIdentifierFromRouting(shardId, primary)), this.allocation.snapshotShardSizeInfo(), project, this.allocation.routingTable(project.id()));
        if (size != -1L) {
            if (shard.relocatingNodeId() != null) {
                this.modifyDiskUsage(shard.relocatingNodeId(), size);
                this.modifyDiskUsage(shard.currentNodeId(), -size);
            } else {
                if (ExpectedShardSizeEstimator.shouldReserveSpaceForInitializingShard(shard, this.allocation.metadata())) {
                    this.modifyDiskUsage(shard.currentNodeId(), -size);
                }
                this.shardSizes.put(ClusterInfo.shardIdentifierFromRouting(shard), project.getIndexSafe(shard.index()).ignoreDiskWatermarks() ? 0L : size);
            }
        }
        this.shardMovementWriteLoadSimulator.simulateShardStarted(shard);
    }

    public void simulateAlreadyStartedShard(ShardRouting startedShard, @Nullable String sourceNodeId) {
        assert (startedShard.started()) : "expected an already started shard, but got: " + String.valueOf(startedShard);
        if (logger.isDebugEnabled()) {
            logger.debug("simulated started shard {} on node [{}] as a {}", (Object)startedShard.shardId(), (Object)startedShard.currentNodeId(), sourceNodeId != null ? "relocating shard from node [" + sourceNodeId + "]" : "new shard");
        }
        long expectedShardSize = startedShard.getExpectedShardSize();
        if (sourceNodeId != null) {
            ShardRouting relocatingShard = startedShard.moveToUnassigned(new UnassignedInfo(UnassignedInfo.Reason.REINITIALIZED, "simulation")).initialize(sourceNodeId, null, expectedShardSize).moveToStarted(expectedShardSize).relocate(startedShard.currentNodeId(), expectedShardSize).getTargetRelocatingShard();
            this.simulateShardStarted(relocatingShard);
        } else {
            ShardRouting initializingShard = startedShard.moveToUnassigned(new UnassignedInfo(UnassignedInfo.Reason.REINITIALIZED, "simulation")).initialize(startedShard.currentNodeId(), null, expectedShardSize);
            this.simulateShardStarted(initializingShard);
        }
    }

    private void modifyDiskUsage(String nodeId, long freeDelta) {
        if (freeDelta == 0L) {
            return;
        }
        DiskUsage diskUsage = this.mostAvailableSpaceUsage.get(nodeId);
        if (diskUsage == null) {
            return;
        }
        String path = diskUsage.path();
        this.updateDiskUsage(this.leastAvailableSpaceUsage, nodeId, path, freeDelta);
        this.updateDiskUsage(this.mostAvailableSpaceUsage, nodeId, path, freeDelta);
    }

    private void updateDiskUsage(Map<String, DiskUsage> availableSpaceUsage, String nodeId, String path, long freeDelta) {
        DiskUsage usage = availableSpaceUsage.get(nodeId);
        if (usage != null && Objects.equals(usage.path(), path)) {
            availableSpaceUsage.put(nodeId, ClusterInfoSimulator.updateWithFreeBytes(usage, freeDelta));
        }
    }

    private static DiskUsage updateWithFreeBytes(DiskUsage usage, long delta) {
        long freeBytes = ClusterInfoSimulator.withinRange(0L, usage.totalBytes(), usage.freeBytes() + delta);
        return usage.copyWithFreeBytes(freeBytes);
    }

    private static long withinRange(long min, long max, long value) {
        return Math.max(min, Math.min(max, value));
    }

    public ClusterInfo getClusterInfo() {
        return this.allocation.clusterInfo().updateWith(this.leastAvailableSpaceUsage, this.mostAvailableSpaceUsage, this.shardSizes.toImmutableMap(), Map.of(), this.estimatedHeapUsages, this.shardMovementWriteLoadSimulator.simulatedNodeUsageStatsForThreadPools());
    }
}

