/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.bulk;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.bulk.BulkItemRequest;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkShardRequest;
import org.elasticsearch.action.bulk.BulkShardResponse;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.cluster.routing.IndexRouting;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.shard.ShardId;

public final class ShardBulkSplitHelper {
    private ShardBulkSplitHelper() {
    }

    public static Map<ShardId, BulkShardRequest> splitRequests(BulkShardRequest request, ProjectMetadata project) {
        ShardId sourceShardId = request.shardId();
        Index index = sourceShardId.getIndex();
        IndexRouting indexRouting = IndexRouting.fromIndexMetadata(project.getIndexSafe(index));
        HashMap<ShardId, List> requestsByShard = new HashMap<ShardId, List>();
        HashMap<ShardId, BulkShardRequest> bulkRequestsPerShard = new HashMap<ShardId, BulkShardRequest>();
        BulkItemRequest[] items = request.items();
        if (items.length == 0) {
            return Map.of(sourceShardId, request);
        }
        for (BulkItemRequest bulkItemRequest : items) {
            DocWriteRequest<?> docWriteRequest = bulkItemRequest.request();
            int newShardId = docWriteRequest.rerouteAtSourceDuringResharding(indexRouting);
            List shardRequests = requestsByShard.computeIfAbsent(new ShardId(index, newShardId), shardNum -> new ArrayList());
            shardRequests.add(new BulkItemRequest(bulkItemRequest.id(), bulkItemRequest.request()));
        }
        if (requestsByShard.size() == 1 && requestsByShard.containsKey(sourceShardId)) {
            return Map.of(sourceShardId, request);
        }
        for (Map.Entry entry : requestsByShard.entrySet()) {
            ShardId shardId = (ShardId)entry.getKey();
            List requests = (List)entry.getValue();
            BulkShardRequest bulkShardRequest = new BulkShardRequest(shardId, request.getRefreshPolicy(), requests.toArray(new BulkItemRequest[0]), request.isSimulated());
            bulkRequestsPerShard.put(shardId, bulkShardRequest);
        }
        return bulkRequestsPerShard;
    }

    public static Tuple<BulkShardResponse, Exception> combineResponses(BulkShardRequest originalRequest, Map<ShardId, BulkShardRequest> splitRequests, Map<ShardId, Tuple<BulkShardResponse, Exception>> responses) {
        BulkItemResponse[] bulkItemResponses = new BulkItemResponse[originalRequest.items().length];
        for (Map.Entry<ShardId, Tuple<BulkShardResponse, Exception>> entry : responses.entrySet()) {
            int n;
            ShardId shardId = entry.getKey();
            Tuple<BulkShardResponse, Exception> value = entry.getValue();
            Exception exception = (Exception)value.v2();
            if (exception != null) {
                BulkShardRequest bulkShardRequest = splitRequests.get(shardId);
                BulkItemRequest[] bulkItemRequestArray = bulkShardRequest.items();
                n = bulkItemRequestArray.length;
                for (int i = 0; i < n; ++i) {
                    BulkItemRequest item = bulkItemRequestArray[i];
                    DocWriteRequest<?> request = item.request();
                    BulkItemResponse.Failure failure = new BulkItemResponse.Failure(item.index(), request.id(), exception);
                    bulkItemResponses[item.id()] = BulkItemResponse.failure(item.id(), request.opType(), failure);
                }
                continue;
            }
            BulkItemResponse[] bulkItemResponseArray = ((BulkShardResponse)value.v1()).getResponses();
            int n2 = bulkItemResponseArray.length;
            for (n = 0; n < n2; ++n) {
                BulkItemResponse bulkItemResponse;
                bulkItemResponses[bulkItemResponse.getItemId()] = bulkItemResponse = bulkItemResponseArray[n];
            }
        }
        BulkShardResponse bulkShardResponse = new BulkShardResponse(originalRequest.shardId(), bulkItemResponses);
        bulkShardResponse.setShardInfo(((BulkShardResponse)responses.get(originalRequest.shardId()).v1()).getShardInfo());
        return new Tuple((Object)bulkShardResponse, null);
    }
}

