/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.bucket.InternalSingleBucketAggregation;
import org.elasticsearch.search.aggregations.metrics.Max;
import org.elasticsearch.search.aggregations.metrics.Min;
import org.elasticsearch.test.InternalAggregationTestCase;

public abstract class InternalSingleBucketAggregationTestCase<T extends InternalSingleBucketAggregation>
extends InternalAggregationTestCase<T> {
    private boolean hasInternalMax;
    private boolean hasInternalMin;
    public Supplier<InternalAggregations> subAggregationsSupplier;

    public void setUp() throws Exception {
        super.setUp();
        this.hasInternalMax = InternalSingleBucketAggregationTestCase.randomBoolean();
        this.hasInternalMin = InternalSingleBucketAggregationTestCase.randomBoolean();
        this.subAggregationsSupplier = () -> {
            ArrayList<Object> aggs = new ArrayList<Object>();
            if (this.hasInternalMax) {
                aggs.add(new Max("max", InternalSingleBucketAggregationTestCase.randomDouble(), InternalSingleBucketAggregationTestCase.randomNumericDocValueFormat(), Collections.emptyMap()));
            }
            if (this.hasInternalMin) {
                aggs.add(new Min("min", InternalSingleBucketAggregationTestCase.randomDouble(), InternalSingleBucketAggregationTestCase.randomNumericDocValueFormat(), Collections.emptyMap()));
            }
            return InternalAggregations.from(aggs);
        };
    }

    protected abstract T createTestInstance(String var1, long var2, InternalAggregations var4, Map<String, Object> var5);

    protected abstract void extraAssertReduced(T var1, List<T> var2);

    @Override
    protected final T createTestInstance(String name, Map<String, Object> metadata) {
        long docCount = InternalSingleBucketAggregationTestCase.between(0, Integer.MAX_VALUE);
        return this.createTestInstance(name, docCount, this.subAggregationsSupplier.get(), metadata);
    }

    @Override
    protected T mutateInstance(T instance) {
        Object name = instance.getName();
        long docCount = instance.getDocCount();
        InternalAggregations aggregations = instance.getAggregations();
        Map<String, Object> metadata = instance.getMetadata();
        switch (InternalSingleBucketAggregationTestCase.between(0, 3)) {
            case 0: {
                name = (String)name + InternalSingleBucketAggregationTestCase.randomAlphaOfLength(5);
                break;
            }
            case 1: {
                docCount += (long)InternalSingleBucketAggregationTestCase.between(1, 2000);
                break;
            }
            case 2: {
                ArrayList<Object> aggs = new ArrayList<Object>();
                aggs.add(new Max("new_max", InternalSingleBucketAggregationTestCase.randomDouble(), InternalSingleBucketAggregationTestCase.randomNumericDocValueFormat(), Collections.emptyMap()));
                aggs.add(new Min("new_min", InternalSingleBucketAggregationTestCase.randomDouble(), InternalSingleBucketAggregationTestCase.randomNumericDocValueFormat(), Collections.emptyMap()));
                aggregations = InternalAggregations.from(aggs);
                break;
            }
            default: {
                metadata = metadata == null ? Maps.newMapWithExpectedSize((int)1) : new HashMap<String, Object>(instance.getMetadata());
                metadata.put(InternalSingleBucketAggregationTestCase.randomAlphaOfLength(15), InternalSingleBucketAggregationTestCase.randomInt());
            }
        }
        return this.createTestInstance((String)name, docCount, aggregations, metadata);
    }

    @Override
    protected final void assertReduced(T reduced, List<T> inputs) {
        double expected;
        InternalSingleBucketAggregationTestCase.assertEquals((long)inputs.stream().mapToLong(InternalSingleBucketAggregation::getDocCount).sum(), (long)reduced.getDocCount());
        if (this.hasInternalMax) {
            expected = inputs.stream().mapToDouble(i -> {
                Max max = (Max)i.getAggregations().get("max");
                return max.value();
            }).max().getAsDouble();
            Max reducedMax = (Max)reduced.getAggregations().get("max");
            InternalSingleBucketAggregationTestCase.assertEquals((double)expected, (double)reducedMax.value(), (double)0.0);
        }
        if (this.hasInternalMin) {
            expected = inputs.stream().mapToDouble(i -> {
                Min min = (Min)i.getAggregations().get("min");
                return min.value();
            }).min().getAsDouble();
            Min reducedMin = (Min)reduced.getAggregations().get("min");
            InternalSingleBucketAggregationTestCase.assertEquals((double)expected, (double)reducedMin.value(), (double)0.0);
        }
        this.extraAssertReduced(reduced, inputs);
    }
}

