/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.datageneration;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.elasticsearch.datageneration.DataGeneratorSpecification;
import org.elasticsearch.datageneration.Template;
import org.elasticsearch.datageneration.datasource.DataSourceRequest;
import org.elasticsearch.datageneration.datasource.DataSourceResponse;

public class TemplateGenerator {
    private final DataGeneratorSpecification specification;
    private final DataSourceResponse.ChildFieldGenerator childFieldGenerator;
    private final Supplier<DataSourceResponse.FieldTypeGenerator.FieldTypeInfo> fieldTypeGenerator;

    public TemplateGenerator(DataGeneratorSpecification specification) {
        this.specification = specification;
        this.childFieldGenerator = specification.dataSource().get(new DataSourceRequest.ChildFieldGenerator(specification));
        this.fieldTypeGenerator = specification.dataSource().get(new DataSourceRequest.FieldTypeGenerator()).generator();
    }

    public Template generate() {
        HashMap<String, Template.Entry> map = new HashMap<String, Template.Entry>();
        this.generateChildFields(map, 0, new AtomicInteger(0));
        return new Template(map);
    }

    private void generateChildFields(Map<String, Template.Entry> mapping, int depth, AtomicInteger nestedFieldsCount) {
        HashSet<String> existingFieldNames = new HashSet<String>();
        int childFieldsCount = this.childFieldGenerator.generateChildFieldCount();
        for (int i = 0; i < childFieldsCount; ++i) {
            HashMap<String, Template.Entry> children;
            String fieldName = this.generateFieldName(existingFieldNames);
            if (depth < this.specification.maxObjectDepth() && this.childFieldGenerator.generateRegularSubObject()) {
                children = new HashMap<String, Template.Entry>();
                mapping.put(fieldName, new Template.Object(fieldName, false, children));
                this.generateChildFields(children, depth + 1, nestedFieldsCount);
                continue;
            }
            if (depth <= this.specification.maxObjectDepth() && nestedFieldsCount.get() < this.specification.nestedFieldsLimit() && this.childFieldGenerator.generateNestedSubObject()) {
                nestedFieldsCount.incrementAndGet();
                children = new HashMap();
                mapping.put(fieldName, new Template.Object(fieldName, true, children));
                this.generateChildFields(children, depth + 1, nestedFieldsCount);
                continue;
            }
            DataSourceResponse.FieldTypeGenerator.FieldTypeInfo fieldTypeInfo = this.fieldTypeGenerator.get();
            mapping.put(fieldName, new Template.Leaf(fieldName, fieldTypeInfo.fieldType().toString()));
        }
    }

    private String generateFieldName(Set<String> existingFields) {
        String fieldName = this.childFieldGenerator.generateFieldName();
        while (existingFields.contains(fieldName)) {
            fieldName = this.childFieldGenerator.generateFieldName();
        }
        existingFields.add(fieldName);
        return fieldName;
    }
}

