/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.kiota.serialization;

import com.microsoft.kiota.serialization.MultipartSerializationWriter;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.serialization.SerializationWriterFactory;
import jakarta.annotation.Nonnull;
import java.util.Objects;

public class MultipartSerializationWriterFactory
implements SerializationWriterFactory {
    private static final String validContentType = "multipart/form-data";

    @Override
    @Nonnull
    public String getValidContentType() {
        return validContentType;
    }

    @Override
    @Nonnull
    public SerializationWriter getSerializationWriter(@Nonnull String contentType) {
        Objects.requireNonNull(contentType, "parameter contentType cannot be null");
        if (contentType.isEmpty()) {
            throw new NullPointerException("contentType cannot be empty");
        }
        if (!contentType.equals(validContentType)) {
            throw new IllegalArgumentException("expected a multipart/form-data content type");
        }
        return new MultipartSerializationWriter();
    }
}

