/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.launchers;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.logstash.launchers.JavaVersion;

public class JvmOptionsParser {
    private static final String[] MANDATORY_JVM_OPTIONS = new String[]{"-Djruby.regexp.interruptible=true", "-Djruby.compile.invokedynamic=true", "-Djdk.io.File.enableADS=true", "-Dlog4j2.isThreadContextMapInheritable=true", "16-:--add-exports=jdk.compiler/com.sun.tools.javac.api=ALL-UNNAMED", "16-:--add-exports=jdk.compiler/com.sun.tools.javac.file=ALL-UNNAMED", "16-:--add-exports=jdk.compiler/com.sun.tools.javac.parser=ALL-UNNAMED", "16-:--add-exports=jdk.compiler/com.sun.tools.javac.tree=ALL-UNNAMED", "16-:--add-exports=jdk.compiler/com.sun.tools.javac.util=ALL-UNNAMED", "11-:--add-opens=java.base/java.security=ALL-UNNAMED", "11-:--add-opens=java.base/java.io=ALL-UNNAMED", "11-:--add-opens=java.base/java.nio.channels=ALL-UNNAMED", "11-:--add-opens=java.base/sun.nio.ch=ALL-UNNAMED", "11-:--add-opens=java.management/sun.management=ALL-UNNAMED"};
    private final String logstashHome;
    private static final Pattern OPTION_DEFINITION = Pattern.compile("((?<start>\\d+)(?<range>-)?(?<end>\\d+)?:)?(?<option>-.*)$");
    private static final Pattern ENV_VAR_PATTERN = Pattern.compile("\\$\\{([a-zA-Z_.][a-zA-Z0-9_.]*)(?::([^}]*))?\\}");
    private static final Pattern JAVA_VERSION = Pattern.compile("^(?:1\\.)?(?<javaMajorVersion>\\d+)(?:\\.\\d+)?$");

    JvmOptionsParser(String logstashHome) {
        this.logstashHome = logstashHome;
    }

    public static void main(String[] args) {
        if (args.length < 1 || args.length > 2) {
            throw new IllegalArgumentException("Expected two arguments specifying path to LOGSTASH_HOME and an optional LS_JVM_OPTS, but was " + Arrays.toString(args));
        }
        JvmOptionsParser.bailOnOldJava();
        JvmOptionsParser.handleJvmOptions(args, System.getenv("LS_JAVA_OPTS"));
    }

    static void bailOnOldJava() {
        if (JavaVersion.CURRENT.compareTo(JavaVersion.JAVA_17) < 0) {
            String message = String.format(Locale.ROOT, "The minimum required Java version is 17; your Java version from [%s] does not meet this requirement", System.getProperty("java.home"));
            System.err.println(message);
            System.exit(1);
        }
    }

    static void handleJvmOptions(String[] args, String lsJavaOpts) {
        JvmOptionsParser parser = new JvmOptionsParser(args[0]);
        String jvmOpts = args.length == 2 ? args[1] : null;
        try {
            Optional<Path> jvmOptions = parser.lookupJvmOptionsFile(jvmOpts);
            parser.handleJvmOptions(jvmOptions, lsJavaOpts);
        }
        catch (JvmOptionsFileParserException pex) {
            System.err.printf(Locale.ROOT, "encountered [%d] error%s parsing [%s]", pex.invalidLines().size(), pex.invalidLines().size() == 1 ? "" : "s", pex.jvmOptionsFile());
            int errorCounter = 0;
            for (Map.Entry<Integer, String> entry : pex.invalidLines().entrySet()) {
                System.err.printf(Locale.ROOT, "[%d]: encountered improperly formatted JVM option in [%s] on line number [%d]: [%s]", ++errorCounter, pex.jvmOptionsFile(), entry.getKey(), entry.getValue());
            }
        }
        catch (IOException ex) {
            System.err.println("Error accessing jvm.options file");
            System.exit(1);
        }
    }

    private Optional<Path> lookupJvmOptionsFile(String jvmOpts) {
        if (jvmOpts != null && !jvmOpts.isEmpty()) {
            return Optional.of(Paths.get(jvmOpts, new String[0]));
        }
        return Arrays.stream(new Path[]{Paths.get("/etc/logstash/jvm.options", new String[0]), Paths.get(this.logstashHome, "config/jvm.options")}).filter(p -> p.toFile().canRead()).findFirst();
    }

    private void handleJvmOptions(Optional<Path> jvmOptionsFile, String lsJavaOpts) throws IOException, JvmOptionsFileParserException {
        int javaMajorVersion = JvmOptionsParser.javaMajorVersion();
        LinkedHashSet<String> jvmOptionsContent = new LinkedHashSet<String>(this.getJvmOptionsFromFile(jvmOptionsFile, javaMajorVersion));
        if (lsJavaOpts != null && !lsJavaOpts.isEmpty()) {
            if (this.isDebugEnabled()) {
                System.err.println("Appending jvm options from environment LS_JAVA_OPTS");
            }
            Arrays.stream(lsJavaOpts.split(" ")).filter(s -> !s.isBlank()).forEach(jvmOptionsContent::add);
        }
        jvmOptionsContent.addAll(JvmOptionsParser.getMandatoryJvmOptions(javaMajorVersion));
        Set<String> jvmFinalOptions = this.nettyMaxOrderDefaultTo11(jvmOptionsContent);
        System.out.println(String.join((CharSequence)" ", jvmFinalOptions));
    }

    private Set<String> nettyMaxOrderDefaultTo11(Set<String> options) {
        boolean maxOrderAlreadyContained = options.stream().anyMatch(s -> s.startsWith("-Dio.netty.allocator.maxOrder"));
        if (maxOrderAlreadyContained) {
            return options;
        }
        LinkedHashSet<String> acc = new LinkedHashSet<String>(options);
        acc.add("-Dio.netty.allocator.maxOrder=11");
        return acc;
    }

    static Collection<String> getMandatoryJvmOptions(int javaMajorVersion) {
        return Arrays.stream(MANDATORY_JVM_OPTIONS).map(option -> JvmOptionsParser.jvmOptionFromLine(javaMajorVersion, option)).flatMap(Optional::stream).collect(Collectors.toUnmodifiableList());
    }

    /*
     * Exception decompiling
     */
    private List<String> getJvmOptionsFromFile(Optional<Path> jvmOptionsFile, int javaMajorVersion) throws IOException, JvmOptionsFileParserException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean isDebugEnabled() {
        String debug = System.getenv("DEBUG");
        if (debug == null) {
            return false;
        }
        return "1".equals(debug) || Boolean.parseBoolean(debug);
    }

    static ParseResult parse(int javaMajorVersion, BufferedReader br) throws IOException {
        ParseResult result = new ParseResult();
        int lineNumber = 0;
        while (true) {
            String line = br.readLine();
            ++lineNumber;
            if (line == null) break;
            try {
                JvmOptionsParser.jvmOptionFromLine(javaMajorVersion, line).ifPresent(result::appendOption);
            }
            catch (IllegalArgumentException e) {
                result.appendError(lineNumber, line);
            }
        }
        return result;
    }

    private static Optional<String> jvmOptionFromLine(int javaMajorVersion, String line) {
        if (line.startsWith("#") || line.matches("\\s*")) {
            return Optional.empty();
        }
        String subbedLine = JvmOptionsParser.resolveEnvVar(line, System.getenv());
        Matcher matcher = OPTION_DEFINITION.matcher(subbedLine);
        if (matcher.matches()) {
            int upper;
            String start = matcher.group("start");
            String end = matcher.group("end");
            if (start == null) {
                return Optional.of(subbedLine);
            }
            int lower = Integer.parseInt(start);
            if (matcher.group("range") == null) {
                upper = lower;
            } else if (end == null) {
                upper = Integer.MAX_VALUE;
            } else {
                upper = Integer.parseInt(end);
                if (upper < lower) {
                    throw new IllegalArgumentException("Upper bound must be greater than lower bound");
                }
            }
            if (lower <= javaMajorVersion && javaMajorVersion <= upper) {
                return Optional.of(matcher.group("option"));
            }
        } else {
            throw new IllegalArgumentException("Illegal JVM Option");
        }
        return Optional.empty();
    }

    static String resolveEnvVar(String line, Map<String, String> env) {
        Matcher matcher = ENV_VAR_PATTERN.matcher(line);
        StringBuilder sb = new StringBuilder();
        while (matcher.find()) {
            String varName = matcher.group(1);
            String defaultValue = Optional.ofNullable(matcher.group(2)).orElse("");
            String replacement = env.getOrDefault(varName, defaultValue);
            matcher.appendReplacement(sb, Matcher.quoteReplacement(replacement));
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    private static int javaMajorVersion() {
        String specVersion = System.getProperty("java.specification.version");
        Matcher specVersionMatcher = JAVA_VERSION.matcher(specVersion);
        if (!specVersionMatcher.matches()) {
            throw new IllegalStateException(String.format("Failed to extract Java major version from specification `%s`", specVersion));
        }
        return Integer.parseInt(specVersionMatcher.group("javaMajorVersion"));
    }

    static class JvmOptionsFileParserException
    extends Exception {
        private static final long serialVersionUID = 2446165130736962758L;
        private final Path jvmOptionsFile;
        private final SortedMap<Integer, String> invalidLines;

        Path jvmOptionsFile() {
            return this.jvmOptionsFile;
        }

        SortedMap<Integer, String> invalidLines() {
            return this.invalidLines;
        }

        JvmOptionsFileParserException(Path jvmOptionsFile, SortedMap<Integer, String> invalidLines) {
            this.jvmOptionsFile = jvmOptionsFile;
            this.invalidLines = invalidLines;
        }
    }

    static final class ParseResult {
        private final List<String> jvmOptions = new ArrayList<String>();
        private final SortedMap<Integer, String> invalidLines = new TreeMap<Integer, String>();

        ParseResult() {
        }

        void appendOption(String option) {
            this.jvmOptions.add(option);
        }

        void appendError(int lineNumber, String malformedLine) {
            this.invalidLines.put(lineNumber, malformedLine);
        }

        public boolean hasErrors() {
            return !this.invalidLines.isEmpty();
        }

        public SortedMap<Integer, String> getInvalidLines() {
            return this.invalidLines;
        }

        public List<String> getJvmOptions() {
            return this.jvmOptions;
        }
    }
}

