/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.action.apikey;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xpack.core.security.action.apikey.BaseUpdateApiKeyRequest;
import org.elasticsearch.xpack.core.security.authz.RoleDescriptor;

public abstract class BaseBulkUpdateApiKeyRequest
extends BaseUpdateApiKeyRequest {
    private final List<String> ids;

    public BaseBulkUpdateApiKeyRequest(List<String> ids, @Nullable List<RoleDescriptor> roleDescriptors, @Nullable Map<String, Object> metadata, @Nullable TimeValue expiration) {
        super(roleDescriptors, metadata, expiration);
        this.ids = Objects.requireNonNull(ids, "API key IDs must not be null");
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = super.validate();
        if (this.ids.isEmpty()) {
            validationException = ValidateActions.addValidationError("Field [ids] cannot be empty", validationException);
        }
        return validationException;
    }

    public List<String> getIds() {
        return this.ids;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass() || super.equals(o)) {
            return false;
        }
        BaseBulkUpdateApiKeyRequest that = (BaseBulkUpdateApiKeyRequest)o;
        return Objects.equals(this.getIds(), that.getIds()) && Objects.equals(this.metadata, that.metadata) && Objects.equals(this.expiration, that.expiration) && Objects.equals(this.roleDescriptors, that.roleDescriptors);
    }

    public int hashCode() {
        return Objects.hash(this.getIds(), this.expiration, this.metadata, this.roleDescriptors);
    }
}

