/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.vectors;

import java.util.Objects;
import java.util.concurrent.atomic.LongAccumulator;
import org.apache.lucene.search.knn.KnnSearchStrategy;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.search.vectors.AbstractMaxScoreKnnCollector;

public class IVFKnnSearchStrategy
extends KnnSearchStrategy {
    private final float visitRatio;
    private final SetOnce<AbstractMaxScoreKnnCollector> collector = new SetOnce();
    private final LongAccumulator accumulator;

    IVFKnnSearchStrategy(float visitRatio, LongAccumulator accumulator) {
        this.visitRatio = visitRatio;
        this.accumulator = accumulator;
    }

    void setCollector(AbstractMaxScoreKnnCollector collector) {
        this.collector.set(collector);
        if (this.accumulator != null) {
            collector.updateMinCompetitiveDocScore(this.accumulator.get());
        }
    }

    public float getVisitRatio() {
        return this.visitRatio;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IVFKnnSearchStrategy that = (IVFKnnSearchStrategy)o;
        return this.visitRatio == that.visitRatio;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(Float.valueOf(this.visitRatio));
    }

    @Override
    public void nextVectorsBlock() {
        if (this.accumulator == null) {
            return;
        }
        assert (this.collector.get() != null) : "Collector must be set before nextVectorsBlock is called";
        AbstractMaxScoreKnnCollector knnCollector = this.collector.get();
        long collectorScore = knnCollector.getMinCompetitiveDocScore();
        this.accumulator.accumulate(collectorScore);
        long currentScore = this.accumulator.get();
        if (currentScore > collectorScore) {
            knnCollector.updateMinCompetitiveDocScore(currentScore);
        }
    }
}

