/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.similarity;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import org.apache.lucene.search.similarities.AfterEffect;
import org.apache.lucene.search.similarities.AfterEffectB;
import org.apache.lucene.search.similarities.AfterEffectL;
import org.apache.lucene.search.similarities.BasicModel;
import org.apache.lucene.search.similarities.BasicModelG;
import org.apache.lucene.search.similarities.BasicModelIF;
import org.apache.lucene.search.similarities.BasicModelIn;
import org.apache.lucene.search.similarities.BasicModelIne;
import org.apache.lucene.search.similarities.BooleanSimilarity;
import org.apache.lucene.search.similarities.DFISimilarity;
import org.apache.lucene.search.similarities.DFRSimilarity;
import org.apache.lucene.search.similarities.Distribution;
import org.apache.lucene.search.similarities.DistributionLL;
import org.apache.lucene.search.similarities.DistributionSPL;
import org.apache.lucene.search.similarities.IBSimilarity;
import org.apache.lucene.search.similarities.Independence;
import org.apache.lucene.search.similarities.IndependenceChiSquared;
import org.apache.lucene.search.similarities.IndependenceSaturated;
import org.apache.lucene.search.similarities.IndependenceStandardized;
import org.apache.lucene.search.similarities.LMDirichletSimilarity;
import org.apache.lucene.search.similarities.LMJelinekMercerSimilarity;
import org.apache.lucene.search.similarities.Lambda;
import org.apache.lucene.search.similarities.LambdaDF;
import org.apache.lucene.search.similarities.LambdaTTF;
import org.apache.lucene.search.similarities.Normalization;
import org.apache.lucene.search.similarities.NormalizationH1;
import org.apache.lucene.search.similarities.NormalizationH2;
import org.apache.lucene.search.similarities.NormalizationH3;
import org.apache.lucene.search.similarities.NormalizationZ;
import org.elasticsearch.common.logging.DeprecationCategory;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.IndexVersions;
import org.elasticsearch.lucene.similarity.LegacyBM25Similarity;

final class SimilarityProviders {
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(SimilarityProviders.class);
    static final String DISCOUNT_OVERLAPS = "discount_overlaps";
    private static final Map<String, BasicModel> BASIC_MODELS = Map.of("g", new BasicModelG(), "if", new BasicModelIF(), "in", new BasicModelIn(), "ine", new BasicModelIne());
    private static final Map<String, String> LEGACY_BASIC_MODELS = Map.of("be", "g", "d", "ine", "p", "ine");
    private static final Map<String, AfterEffect> AFTER_EFFECTS = Map.of("b", new AfterEffectB(), "l", new AfterEffectL());
    private static final Map<String, String> LEGACY_AFTER_EFFECTS = Map.of("no", "l");
    private static final Map<String, Independence> INDEPENDENCE_MEASURES = Map.of("standardized", new IndependenceStandardized(), "saturated", new IndependenceSaturated(), "chisquared", new IndependenceChiSquared());
    private static final Map<String, Distribution> DISTRIBUTIONS = Map.of("ll", new DistributionLL(), "spl", new DistributionSPL());
    private static final Map<String, Lambda> LAMBDAS = Map.of("df", new LambdaDF(), "ttf", new LambdaTTF());

    private SimilarityProviders() {
    }

    private static BasicModel parseBasicModel(IndexVersion indexCreatedVersion, Settings settings) {
        String replacement;
        String basicModel = settings.get("basic_model");
        BasicModel model = BASIC_MODELS.get(basicModel);
        if (model == null && (replacement = LEGACY_BASIC_MODELS.get(basicModel)) != null) {
            if (indexCreatedVersion.onOrAfter(IndexVersions.V_7_0_0)) {
                throw new IllegalArgumentException("Basic model [" + basicModel + "] isn't supported anymore, please use another model.");
            }
            deprecationLogger.warn(DeprecationCategory.INDICES, basicModel + "_similarity_model_replaced", "Basic model [" + basicModel + "] isn't supported anymore and has arbitrarily been replaced with [" + replacement + "].", new Object[0]);
            model = BASIC_MODELS.get(replacement);
            assert (model != null);
        }
        if (model == null) {
            throw new IllegalArgumentException("Unsupported BasicModel [" + basicModel + "], expected one of " + String.valueOf(BASIC_MODELS.keySet()));
        }
        return model;
    }

    private static AfterEffect parseAfterEffect(IndexVersion indexCreatedVersion, Settings settings) {
        String replacement;
        String afterEffect = settings.get("after_effect");
        AfterEffect effect = AFTER_EFFECTS.get(afterEffect);
        if (effect == null && (replacement = LEGACY_AFTER_EFFECTS.get(afterEffect)) != null) {
            if (indexCreatedVersion.onOrAfter(IndexVersions.V_7_0_0)) {
                throw new IllegalArgumentException("After effect [" + afterEffect + "] isn't supported anymore, please use another effect.");
            }
            deprecationLogger.warn(DeprecationCategory.INDICES, afterEffect + "_after_effect_replaced", "After effect [" + afterEffect + "] isn't supported anymore and has arbitrarily been replaced with [" + replacement + "].", new Object[0]);
            effect = AFTER_EFFECTS.get(replacement);
            assert (effect != null);
        }
        if (effect == null) {
            throw new IllegalArgumentException("Unsupported AfterEffect [" + afterEffect + "], expected one of " + String.valueOf(AFTER_EFFECTS.keySet()));
        }
        return effect;
    }

    private static Normalization parseNormalization(Settings settings) {
        String normalization = settings.get("normalization");
        if ("no".equals(normalization)) {
            return new Normalization.NoNormalization();
        }
        if ("h1".equals(normalization)) {
            float c = settings.getAsFloat("normalization.h1.c", Float.valueOf(1.0f)).floatValue();
            return new NormalizationH1(c);
        }
        if ("h2".equals(normalization)) {
            float c = settings.getAsFloat("normalization.h2.c", Float.valueOf(1.0f)).floatValue();
            return new NormalizationH2(c);
        }
        if ("h3".equals(normalization)) {
            float c = settings.getAsFloat("normalization.h3.c", Float.valueOf(800.0f)).floatValue();
            return new NormalizationH3(c);
        }
        if ("z".equals(normalization)) {
            float z = settings.getAsFloat("normalization.z.z", Float.valueOf(0.3f)).floatValue();
            return new NormalizationZ(z);
        }
        throw new IllegalArgumentException("Unsupported Normalization [" + normalization + "]");
    }

    private static Independence parseIndependence(Settings settings) {
        String name = settings.get("independence_measure");
        Independence measure = INDEPENDENCE_MEASURES.get(name);
        if (measure == null) {
            throw new IllegalArgumentException("Unsupported IndependenceMeasure [" + name + "], expected one of " + String.valueOf(INDEPENDENCE_MEASURES.keySet()));
        }
        return measure;
    }

    private static Distribution parseDistribution(Settings settings) {
        String rawDistribution = settings.get("distribution");
        Distribution distribution = DISTRIBUTIONS.get(rawDistribution);
        if (distribution == null) {
            throw new IllegalArgumentException("Unsupported Distribution [" + rawDistribution + "]");
        }
        return distribution;
    }

    private static Lambda parseLambda(Settings settings) {
        String rawLambda = settings.get("lambda");
        Lambda lambda = LAMBDAS.get(rawLambda);
        if (lambda == null) {
            throw new IllegalArgumentException("Unsupported Lambda [" + rawLambda + "]");
        }
        return lambda;
    }

    static void assertSettingsIsSubsetOf(String type, IndexVersion version, Settings settings, String ... supportedSettings) {
        HashSet<String> unknownSettings = new HashSet<String>(settings.keySet());
        unknownSettings.removeAll(Arrays.asList(supportedSettings));
        unknownSettings.remove("type");
        if (!unknownSettings.isEmpty()) {
            if (version.onOrAfter(IndexVersions.V_7_0_0)) {
                throw new IllegalArgumentException("Unknown settings for similarity of type [" + type + "]: " + String.valueOf(unknownSettings));
            }
            deprecationLogger.warn(DeprecationCategory.INDICES, "unknown_similarity_setting", "Unknown settings for similarity of type [" + type + "]: " + String.valueOf(unknownSettings), new Object[0]);
        }
    }

    public static LegacyBM25Similarity createBM25Similarity(Settings settings, IndexVersion indexCreatedVersion) {
        SimilarityProviders.assertSettingsIsSubsetOf("BM25", indexCreatedVersion, settings, "k1", "b", DISCOUNT_OVERLAPS);
        float k1 = settings.getAsFloat("k1", Float.valueOf(1.2f)).floatValue();
        float b = settings.getAsFloat("b", Float.valueOf(0.75f)).floatValue();
        boolean discountOverlaps = settings.getAsBoolean(DISCOUNT_OVERLAPS, true);
        return new LegacyBM25Similarity(k1, b, discountOverlaps);
    }

    public static BooleanSimilarity createBooleanSimilarity(Settings settings, IndexVersion indexCreatedVersion) {
        SimilarityProviders.assertSettingsIsSubsetOf("boolean", indexCreatedVersion, settings, new String[0]);
        return new BooleanSimilarity();
    }

    public static DFRSimilarity createDfrSimilarity(Settings settings, IndexVersion indexCreatedVersion) {
        SimilarityProviders.assertSettingsIsSubsetOf("DFR", indexCreatedVersion, settings, "basic_model", "after_effect", "normalization", "normalization.h1.c", "normalization.h2.c", "normalization.h3.c", "normalization.z.z");
        return new DFRSimilarity(SimilarityProviders.parseBasicModel(indexCreatedVersion, settings), SimilarityProviders.parseAfterEffect(indexCreatedVersion, settings), SimilarityProviders.parseNormalization(settings));
    }

    public static DFISimilarity createDfiSimilarity(Settings settings, IndexVersion indexCreatedVersion) {
        SimilarityProviders.assertSettingsIsSubsetOf("DFI", indexCreatedVersion, settings, "independence_measure");
        return new DFISimilarity(SimilarityProviders.parseIndependence(settings));
    }

    public static IBSimilarity createIBSimilarity(Settings settings, IndexVersion indexCreatedVersion) {
        SimilarityProviders.assertSettingsIsSubsetOf("IB", indexCreatedVersion, settings, "distribution", "lambda", "normalization", "normalization.h1.c", "normalization.h2.c", "normalization.h3.c", "normalization.z.z");
        return new IBSimilarity(SimilarityProviders.parseDistribution(settings), SimilarityProviders.parseLambda(settings), SimilarityProviders.parseNormalization(settings));
    }

    public static LMDirichletSimilarity createLMDirichletSimilarity(Settings settings, IndexVersion indexCreatedVersion) {
        SimilarityProviders.assertSettingsIsSubsetOf("LMDirichlet", indexCreatedVersion, settings, "mu");
        float mu = settings.getAsFloat("mu", Float.valueOf(2000.0f)).floatValue();
        return new LMDirichletSimilarity(mu);
    }

    public static LMJelinekMercerSimilarity createLMJelinekMercerSimilarity(Settings settings, IndexVersion indexCreatedVersion) {
        SimilarityProviders.assertSettingsIsSubsetOf("LMJelinekMercer", indexCreatedVersion, settings, "lambda");
        float lambda = settings.getAsFloat("lambda", Float.valueOf(0.1f)).floatValue();
        return new LMJelinekMercerSimilarity(lambda);
    }
}

