/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.shard;

import java.io.IOException;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;

public record ShardFieldStats(int numSegments, int totalFields, long fieldUsages, long postingsInMemoryBytes, long liveDocsBytes) implements ToXContentFragment
{
    public static final long FIXED_BITSET_BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(FixedBitSet.class);
    public static final ConstructingObjectParser<ShardFieldStats, Void> PARSER = new ConstructingObjectParser("shard_field_stats", true, args -> (ShardFieldStats)args[0]);
    protected static final ConstructingObjectParser<ShardFieldStats, Void> SHARD_FIELD_STATS_PARSER = new ConstructingObjectParser("shard_field_stats_fields", true, args -> new ShardFieldStats((Integer)args[0], (Integer)args[1], (Long)args[2], (Long)args[3], (Long)args[4]));

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("shard_field_stats");
        builder.field("num_segments", this.numSegments);
        builder.field("total_fields", this.totalFields);
        builder.field("field_usages", this.fieldUsages);
        builder.humanReadableField("postings_in_memory_bytes", "postings_in_memory", ByteSizeValue.ofBytes(this.postingsInMemoryBytes));
        builder.humanReadableField("live_docs_bytes", "live_docs", ByteSizeValue.ofBytes(this.liveDocsBytes));
        builder.endObject();
        return builder;
    }

    static {
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), SHARD_FIELD_STATS_PARSER, new ParseField("shard_field_stats", new String[0]));
        SHARD_FIELD_STATS_PARSER.declareInt(ConstructingObjectParser.constructorArg(), new ParseField("num_segments", new String[0]));
        SHARD_FIELD_STATS_PARSER.declareInt(ConstructingObjectParser.constructorArg(), new ParseField("total_fields", new String[0]));
        SHARD_FIELD_STATS_PARSER.declareLong(ConstructingObjectParser.constructorArg(), new ParseField("field_usages", new String[0]));
        SHARD_FIELD_STATS_PARSER.declareLong(ConstructingObjectParser.constructorArg(), new ParseField("postings_in_memory_bytes", new String[0]));
        SHARD_FIELD_STATS_PARSER.declareLong(ConstructingObjectParser.constructorArg(), new ParseField("live_docs_bytes", new String[0]));
    }

    static final class Fields {
        static final String SHARD_FIELD_STATS = "shard_field_stats";
        static final String NUM_SEGMENTS = "num_segments";
        static final String TOTAL_FIELDS = "total_fields";
        static final String FIELD_USAGES = "field_usages";
        static final String POSTINGS_IN_MEMORY_BYTES = "postings_in_memory_bytes";
        static final String POSTINGS_IN_MEMORY = "postings_in_memory";
        static final String LIVE_DOCS_BYTES = "live_docs_bytes";
        static final String LIVE_DOCS = "live_docs";

        Fields() {
        }
    }
}

