/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.engine;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.lucene.index.CodecReader;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FilterCodecReader;
import org.apache.lucene.index.FilterDirectoryReader;
import org.apache.lucene.index.FilterLeafReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.FixedBitSet;
import org.elasticsearch.common.lucene.Lucene;

public final class LazySoftDeletesDirectoryReaderWrapper
extends FilterDirectoryReader {
    private final IndexReader.CacheHelper readerCacheHelper;

    public LazySoftDeletesDirectoryReaderWrapper(DirectoryReader in, String field) throws IOException {
        super(in, new LazySoftDeletesSubReaderWrapper(field));
        this.readerCacheHelper = in.getReaderCacheHelper() == null ? null : new DelegatingCacheHelper(in.getReaderCacheHelper());
    }

    @Override
    protected DirectoryReader doWrapDirectoryReader(DirectoryReader in) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public IndexReader.CacheHelper getReaderCacheHelper() {
        return this.readerCacheHelper;
    }

    static LeafReader wrap(LeafReader reader, String field) {
        SegmentReader segmentReader = Lucene.segmentReader(reader);
        SegmentCommitInfo segmentInfo = segmentReader.getSegmentInfo();
        int numSoftDeletes = segmentInfo.getSoftDelCount();
        if (numSoftDeletes == 0) {
            return reader;
        }
        int maxDoc = reader.maxDoc();
        int numDocs = maxDoc - segmentInfo.getDelCount() - segmentInfo.getSoftDelCount();
        LazyBits lazyBits = new LazyBits(maxDoc, field, reader, numSoftDeletes, numDocs);
        return reader instanceof CodecReader ? new LazySoftDeletesFilterCodecReader((CodecReader)reader, lazyBits, numDocs) : new LazySoftDeletesFilterLeafReader(reader, lazyBits, numDocs);
    }

    static int applySoftDeletes(DocIdSetIterator iterator, FixedBitSet bits) throws IOException {
        int docID;
        assert (iterator != null);
        int newDeletes = 0;
        while ((docID = iterator.nextDoc()) != Integer.MAX_VALUE) {
            if (!bits.get(docID)) continue;
            bits.clear(docID);
            ++newDeletes;
        }
        return newDeletes;
    }

    private static DocIdSetIterator getDocValuesDocIdSetIterator(String field, LeafReader reader) throws IOException {
        FieldInfo fieldInfo = reader.getFieldInfos().fieldInfo(field);
        if (fieldInfo != null) {
            return switch (fieldInfo.getDocValuesType()) {
                case DocValuesType.NONE -> null;
                case DocValuesType.NUMERIC -> reader.getNumericDocValues(field);
                case DocValuesType.BINARY -> reader.getBinaryDocValues(field);
                case DocValuesType.SORTED -> reader.getSortedDocValues(field);
                case DocValuesType.SORTED_NUMERIC -> reader.getSortedNumericDocValues(field);
                case DocValuesType.SORTED_SET -> reader.getSortedSetDocValues(field);
                default -> throw new AssertionError();
            };
        }
        return null;
    }

    private static class LazySoftDeletesSubReaderWrapper
    extends FilterDirectoryReader.SubReaderWrapper {
        private final String field;

        LazySoftDeletesSubReaderWrapper(String field) {
            Objects.requireNonNull(field, "Field must not be null");
            this.field = field;
        }

        @Override
        protected LeafReader[] wrap(List<? extends LeafReader> readers) {
            ArrayList<LeafReader> wrapped = new ArrayList<LeafReader>(readers.size());
            for (LeafReader leafReader : readers) {
                LeafReader wrap = this.wrap(leafReader);
                assert (wrap != null);
                if (wrap.numDocs() == 0) continue;
                wrapped.add(wrap);
            }
            return wrapped.toArray(new LeafReader[0]);
        }

        @Override
        public LeafReader wrap(LeafReader reader) {
            return LazySoftDeletesDirectoryReaderWrapper.wrap(reader, this.field);
        }
    }

    private static class DelegatingCacheHelper
    extends FilterDirectoryReader.DelegatingCacheHelper {
        DelegatingCacheHelper(IndexReader.CacheHelper delegate) {
            super(delegate);
        }
    }

    public static class LazyBits
    implements Bits {
        private final int maxDoc;
        private final String field;
        private final LeafReader reader;
        private final int numSoftDeletes;
        private final int numDocs;
        volatile Bits materializedBits;

        public LazyBits(int maxDoc, String field, LeafReader reader, int numSoftDeletes, int numDocs) {
            this.maxDoc = maxDoc;
            this.field = field;
            this.reader = reader;
            this.numSoftDeletes = numSoftDeletes;
            this.numDocs = numDocs;
            this.materializedBits = null;
            assert (numSoftDeletes > 0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean get(int index) {
            if (this.materializedBits == null) {
                LazyBits lazyBits = this;
                synchronized (lazyBits) {
                    try {
                        if (this.materializedBits == null) {
                            this.materializedBits = this.init();
                        }
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
            }
            return this.materializedBits.get(index);
        }

        @Override
        public int length() {
            return this.maxDoc;
        }

        private Bits init() throws IOException {
            FixedBitSet bits;
            assert (Thread.holdsLock(this));
            DocIdSetIterator iterator = LazySoftDeletesDirectoryReaderWrapper.getDocValuesDocIdSetIterator(this.field, this.reader);
            assert (iterator != null);
            Bits liveDocs = this.reader.getLiveDocs();
            if (liveDocs != null) {
                bits = FixedBitSet.copyOf(liveDocs);
            } else {
                bits = new FixedBitSet(this.maxDoc);
                bits.set(0, this.maxDoc);
            }
            int numComputedSoftDeletes = LazySoftDeletesDirectoryReaderWrapper.applySoftDeletes(iterator, bits);
            assert (numComputedSoftDeletes == this.numSoftDeletes) : "numComputedSoftDeletes: " + numComputedSoftDeletes + " expected: " + this.numSoftDeletes;
            int numDeletes = this.reader.numDeletedDocs() + numComputedSoftDeletes;
            int computedNumDocs = this.reader.maxDoc() - numDeletes;
            assert (computedNumDocs == this.numDocs) : "computedNumDocs: " + computedNumDocs + " expected: " + this.numDocs;
            return bits;
        }

        public boolean initialized() {
            return this.materializedBits != null;
        }
    }

    public static final class LazySoftDeletesFilterCodecReader
    extends FilterCodecReader {
        private final LeafReader reader;
        private final LazyBits bits;
        private final int numDocs;
        private final IndexReader.CacheHelper readerCacheHelper;

        public LazySoftDeletesFilterCodecReader(CodecReader reader, LazyBits bits, int numDocs) {
            super(reader);
            this.reader = reader;
            this.bits = bits;
            this.numDocs = numDocs;
            this.readerCacheHelper = reader.getReaderCacheHelper() == null ? null : new DelegatingCacheHelper(reader.getReaderCacheHelper());
        }

        @Override
        public LazyBits getLiveDocs() {
            return this.bits;
        }

        @Override
        public int numDocs() {
            return this.numDocs;
        }

        @Override
        public IndexReader.CacheHelper getCoreCacheHelper() {
            return this.reader.getCoreCacheHelper();
        }

        @Override
        public IndexReader.CacheHelper getReaderCacheHelper() {
            return this.readerCacheHelper;
        }
    }

    public static final class LazySoftDeletesFilterLeafReader
    extends FilterLeafReader {
        private final LeafReader reader;
        private final LazyBits bits;
        private final int numDocs;
        private final IndexReader.CacheHelper readerCacheHelper;

        public LazySoftDeletesFilterLeafReader(LeafReader reader, LazyBits bits, int numDocs) {
            super(reader);
            this.reader = reader;
            this.bits = bits;
            this.numDocs = numDocs;
            this.readerCacheHelper = reader.getReaderCacheHelper() == null ? null : new DelegatingCacheHelper(reader.getReaderCacheHelper());
        }

        @Override
        public LazyBits getLiveDocs() {
            return this.bits;
        }

        @Override
        public int numDocs() {
            return this.numDocs;
        }

        @Override
        public IndexReader.CacheHelper getCoreCacheHelper() {
            return this.reader.getCoreCacheHelper();
        }

        @Override
        public IndexReader.CacheHelper getReaderCacheHelper() {
            return this.readerCacheHelper;
        }
    }
}

