/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.resolve;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.Build;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRunnable;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.OriginalIndices;
import org.elasticsearch.action.RemoteClusterActionType;
import org.elasticsearch.action.admin.indices.resolve.ResolveClusterActionRequest;
import org.elasticsearch.action.admin.indices.resolve.ResolveClusterActionResponse;
import org.elasticsearch.action.admin.indices.resolve.ResolveClusterInfo;
import org.elasticsearch.action.admin.indices.resolve.ResolveIndexAction;
import org.elasticsearch.action.search.TransportSearchHelper;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.ListenerTimeouts;
import org.elasticsearch.action.support.RefCountingRunnable;
import org.elasticsearch.client.internal.RemoteClusterClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.search.SearchService;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.ConnectTransportException;
import org.elasticsearch.transport.RemoteClusterService;
import org.elasticsearch.transport.TransportService;

public class TransportResolveClusterAction
extends HandledTransportAction<ResolveClusterActionRequest, ResolveClusterActionResponse> {
    private static final Logger logger = LogManager.getLogger(TransportResolveClusterAction.class);
    public static final String NAME = "indices:admin/resolve/cluster";
    public static final ActionType<ResolveClusterActionResponse> TYPE = new ActionType("indices:admin/resolve/cluster");
    public static final RemoteClusterActionType<ResolveClusterActionResponse> REMOTE_TYPE = new RemoteClusterActionType<ResolveClusterActionResponse>("indices:admin/resolve/cluster", ResolveClusterActionResponse::new);
    private static final String DUMMY_INDEX_FOR_OLDER_CLUSTERS = "*:dummy*";
    private static final String REMOTE_CONNECTION_TIMEOUT_ERROR = "Request timed out before receiving a response from the remote cluster";
    private final Executor searchCoordinationExecutor;
    private final ClusterService clusterService;
    private final RemoteClusterService remoteClusterService;
    private final IndexNameExpressionResolver indexNameExpressionResolver;
    private final boolean ccsCheckCompatibility;
    private final ThreadPool threadPool;

    @Inject
    public TransportResolveClusterAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super(NAME, transportService, actionFilters, ResolveClusterActionRequest::new, EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.searchCoordinationExecutor = threadPool.executor("search_coordination");
        this.clusterService = clusterService;
        this.remoteClusterService = transportService.getRemoteClusterService();
        this.indexNameExpressionResolver = indexNameExpressionResolver;
        this.ccsCheckCompatibility = SearchService.CCS_VERSION_CHECK_SETTING.get(clusterService.getSettings());
        this.threadPool = threadPool;
    }

    @Override
    protected void doExecute(Task task, ResolveClusterActionRequest request, ActionListener<ResolveClusterActionResponse> listener) {
        this.searchCoordinationExecutor.execute(ActionRunnable.wrap(listener, l -> this.doExecuteForked(task, request, (ActionListener<ResolveClusterActionResponse>)l)));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doExecuteForked(Task task, final ResolveClusterActionRequest request, ActionListener<ResolveClusterActionResponse> listener) {
        OriginalIndices localIndices;
        Map<String, OriginalIndices> remoteClusterIndices;
        if (this.ccsCheckCompatibility) {
            TransportSearchHelper.checkCCSVersionCompatibility(request);
        }
        assert (task instanceof CancellableTask);
        final CancellableTask resolveClusterTask = (CancellableTask)task;
        ClusterState clusterState = this.clusterService.state();
        final ConcurrentHashMap<String, ResolveClusterInfo> clusterInfoMap = new ConcurrentHashMap<String, ResolveClusterInfo>();
        if (request.clusterInfoOnly()) {
            if (!request.queryingCluster()) {
                ResolveClusterInfo resolveClusterInfo = new ResolveClusterInfo(true, false, null, Build.current());
                clusterInfoMap.put("", resolveClusterInfo);
                listener.onResponse(new ResolveClusterActionResponse(clusterInfoMap));
                return;
            }
            String[] dummyIndexExpr = new String[]{DUMMY_INDEX_FOR_OLDER_CLUSTERS};
            remoteClusterIndices = this.remoteClusterService.groupIndices(IndicesOptions.DEFAULT, dummyIndexExpr, false);
            if (remoteClusterIndices.isEmpty()) {
                listener.onResponse(new ResolveClusterActionResponse(Map.of()));
                return;
            }
        } else {
            remoteClusterIndices = this.remoteClusterService.groupIndices(request.indicesOptions(), request.indices(), false);
        }
        if ((localIndices = remoteClusterIndices.remove("")) != null) {
            try {
                boolean matchingIndices = this.hasMatchingIndices(localIndices, request.indicesOptions(), clusterState);
                clusterInfoMap.put("", new ResolveClusterInfo(true, false, matchingIndices, Build.current()));
            }
            catch (IndexNotFoundException e) {
                clusterInfoMap.put("", new ResolveClusterInfo(true, (Boolean)false, e.getMessage()));
            }
        } else if (request.isLocalIndicesRequested()) {
            clusterInfoMap.put("", new ResolveClusterInfo(true, false, false, Build.current()));
        }
        AtomicBoolean finishedOrCancelled = new AtomicBoolean();
        resolveClusterTask.addListener(() -> {
            if (finishedOrCancelled.compareAndSet(false, true)) {
                TransportResolveClusterAction.releaseResourcesOnCancel(clusterInfoMap);
            }
        });
        try (final RefCountingRunnable refs = new RefCountingRunnable(() -> {
            finishedOrCancelled.set(true);
            if (resolveClusterTask.notifyIfCancelled(listener)) {
                TransportResolveClusterAction.releaseResourcesOnCancel(clusterInfoMap);
            } else {
                listener.onResponse(new ResolveClusterActionResponse(clusterInfoMap));
            }
        });){
            for (Map.Entry<String, OriginalIndices> remoteIndices : remoteClusterIndices.entrySet()) {
                ActionListener<ResolveClusterActionResponse> resultsListener;
                resolveClusterTask.ensureNotCancelled();
                final String clusterAlias = remoteIndices.getKey();
                final OriginalIndices originalIndices = remoteIndices.getValue();
                final boolean skipUnavailable = this.remoteClusterService.isSkipUnavailable(clusterAlias).orElse(true);
                final RemoteClusterClient remoteClusterClient = this.remoteClusterService.getRemoteClusterClient(clusterAlias, this.searchCoordinationExecutor, RemoteClusterService.DisconnectedStrategy.RECONNECT_IF_DISCONNECTED);
                ResolveClusterActionRequest remoteRequest = new ResolveClusterActionRequest(originalIndices.indices(), request.indicesOptions(), request.clusterInfoOnly(), false);
                remoteRequest.setParentTask(this.clusterService.localNode().getId(), task.getId());
                ActionListener<ResolveClusterActionResponse> remoteListener = new ActionListener<ResolveClusterActionResponse>(this){

                    @Override
                    public void onResponse(ResolveClusterActionResponse response) {
                        if (resolveClusterTask.isCancelled()) {
                            TransportResolveClusterAction.releaseResourcesOnCancel(clusterInfoMap);
                            return;
                        }
                        ResolveClusterInfo info = response.getResolveClusterInfo().get("");
                        if (info != null) {
                            clusterInfoMap.put(clusterAlias, new ResolveClusterInfo(info, skipUnavailable, request.clusterInfoOnly()));
                        }
                        if (resolveClusterTask.isCancelled()) {
                            TransportResolveClusterAction.releaseResourcesOnCancel(clusterInfoMap);
                        }
                    }

                    @Override
                    public void onFailure(Exception failure) {
                        if (resolveClusterTask.isCancelled()) {
                            TransportResolveClusterAction.releaseResourcesOnCancel(clusterInfoMap);
                            return;
                        }
                        if (ExceptionsHelper.isRemoteUnavailableException(failure)) {
                            String errorMessage = failure.getMessage();
                            if (errorMessage.equals(TransportResolveClusterAction.REMOTE_CONNECTION_TIMEOUT_ERROR)) {
                                clusterInfoMap.put(clusterAlias, new ResolveClusterInfo(false, (Boolean)skipUnavailable, errorMessage));
                            } else {
                                clusterInfoMap.put(clusterAlias, new ResolveClusterInfo(false, skipUnavailable));
                            }
                        } else {
                            Throwable errorMessage = ExceptionsHelper.unwrap(failure, ElasticsearchSecurityException.class);
                            if (errorMessage instanceof ElasticsearchSecurityException) {
                                ElasticsearchSecurityException ese = (ElasticsearchSecurityException)errorMessage;
                                clusterInfoMap.put(clusterAlias, new ResolveClusterInfo(false, (Boolean)skipUnavailable, ese.getMessage()));
                            } else {
                                errorMessage = ExceptionsHelper.unwrap(failure, IndexNotFoundException.class);
                                if (errorMessage instanceof IndexNotFoundException) {
                                    IndexNotFoundException infe = (IndexNotFoundException)errorMessage;
                                    clusterInfoMap.put(clusterAlias, new ResolveClusterInfo(true, (Boolean)skipUnavailable, infe.getMessage()));
                                } else {
                                    Throwable cause = ExceptionsHelper.unwrapCause(failure);
                                    if (cause instanceof UnsupportedOperationException && cause.getMessage().contains("ResolveClusterAction requires at least version")) {
                                        ResolveIndexAction.Request resolveIndexRequest = new ResolveIndexAction.Request(originalIndices.indices(), originalIndices.indicesOptions());
                                        ActionListener<ResolveIndexAction.Response> resolveIndexActionListener = 1.createResolveIndexActionListener(clusterAlias, request.clusterInfoOnly(), skipUnavailable, clusterInfoMap, resolveClusterTask);
                                        remoteClusterClient.execute(ResolveIndexAction.REMOTE_TYPE, resolveIndexRequest, ActionListener.releaseAfter(resolveIndexActionListener, refs.acquire()));
                                    } else {
                                        clusterInfoMap.put(clusterAlias, new ResolveClusterInfo(false, (Boolean)skipUnavailable, cause.toString()));
                                        logger.warn(() -> Strings.format("Failure from _resolve/cluster lookup against cluster %s: ", clusterAlias), (Throwable)failure);
                                    }
                                }
                            }
                        }
                        if (resolveClusterTask.isCancelled()) {
                            TransportResolveClusterAction.releaseResourcesOnCancel(clusterInfoMap);
                        }
                    }

                    private static ActionListener<ResolveIndexAction.Response> createResolveIndexActionListener(final String clusterAlias2, final boolean clusterInfoOnly, final boolean skipUnavailable2, final Map<String, ResolveClusterInfo> clusterInfoMap2, final CancellableTask resolveClusterTask2) {
                        return new ActionListener<ResolveIndexAction.Response>(){

                            @Override
                            public void onResponse(ResolveIndexAction.Response response) {
                                if (resolveClusterTask2.isCancelled()) {
                                    TransportResolveClusterAction.releaseResourcesOnCancel(clusterInfoMap2);
                                    return;
                                }
                                Boolean matchingIndices = null;
                                if (!clusterInfoOnly) {
                                    matchingIndices = response.getIndices().size() > 0 || response.getAliases().size() > 0 || response.getDataStreams().size() > 0;
                                }
                                clusterInfoMap2.put(clusterAlias2, new ResolveClusterInfo(true, skipUnavailable2, matchingIndices, null));
                            }

                            @Override
                            public void onFailure(Exception e) {
                                ResolveClusterInfo resolveClusterInfo;
                                if (resolveClusterTask2.isCancelled()) {
                                    TransportResolveClusterAction.releaseResourcesOnCancel(clusterInfoMap2);
                                    return;
                                }
                                if (ExceptionsHelper.isRemoteUnavailableException(e)) {
                                    resolveClusterInfo = new ResolveClusterInfo(false, skipUnavailable2);
                                } else {
                                    Throwable throwable = ExceptionsHelper.unwrap(e, ElasticsearchSecurityException.class);
                                    if (throwable instanceof ElasticsearchSecurityException) {
                                        ElasticsearchSecurityException ese = (ElasticsearchSecurityException)throwable;
                                        resolveClusterInfo = new ResolveClusterInfo(false, (Boolean)skipUnavailable2, ese.getMessage());
                                    } else {
                                        throwable = ExceptionsHelper.unwrap(e, IndexNotFoundException.class);
                                        if (throwable instanceof IndexNotFoundException) {
                                            IndexNotFoundException ie = (IndexNotFoundException)throwable;
                                            resolveClusterInfo = new ResolveClusterInfo(true, (Boolean)skipUnavailable2, ie.getMessage());
                                        } else {
                                            String errorMessage = ExceptionsHelper.unwrapCause(e).getMessage();
                                            resolveClusterInfo = new ResolveClusterInfo(false, (Boolean)skipUnavailable2, errorMessage);
                                            logger.warn(() -> Strings.format("Failure from _resolve/index lookup against cluster %s: ", clusterAlias2), (Throwable)e);
                                        }
                                    }
                                }
                                clusterInfoMap2.put(clusterAlias2, resolveClusterInfo);
                            }
                        };
                    }
                };
                TimeValue timeout = request.getTimeout();
                if (timeout != null) {
                    ActionListener<ResolveClusterActionResponse> releaserListener = ActionListener.releaseAfter(remoteListener, refs.acquire());
                    resultsListener = ListenerTimeouts.wrapWithTimeout(this.threadPool, timeout, this.searchCoordinationExecutor, releaserListener, ignored -> releaserListener.onFailure(new ConnectTransportException(null, REMOTE_CONNECTION_TIMEOUT_ERROR)));
                } else {
                    resultsListener = ActionListener.releaseAfter(remoteListener, refs.acquire());
                }
                remoteClusterClient.execute(REMOTE_TYPE, remoteRequest, resultsListener);
            }
            return;
        }
    }

    private boolean hasMatchingIndices(OriginalIndices localIndices, IndicesOptions indicesOptions, ClusterState clusterState) {
        ArrayList<ResolveIndexAction.ResolvedIndex> indices = new ArrayList<ResolveIndexAction.ResolvedIndex>();
        ArrayList<ResolveIndexAction.ResolvedAlias> aliases = new ArrayList<ResolveIndexAction.ResolvedAlias>();
        ArrayList<ResolveIndexAction.ResolvedDataStream> dataStreams = new ArrayList<ResolveIndexAction.ResolvedDataStream>();
        ResolveIndexAction.TransportAction.resolveIndices(localIndices.indices(), indicesOptions, clusterState.projectState(), this.indexNameExpressionResolver, indices, aliases, dataStreams);
        return TransportResolveClusterAction.hasNonClosedMatchingIndex(indices) || aliases.size() > 0 || dataStreams.size() > 0;
    }

    static boolean hasNonClosedMatchingIndex(List<ResolveIndexAction.ResolvedIndex> indices) {
        boolean indexMatches = false;
        for (ResolveIndexAction.ResolvedIndex index : indices) {
            String[] attributes = index.getAttributes();
            if (attributes != null) {
                for (String attribute : attributes) {
                    if (attribute.equals("closed")) {
                        indexMatches = false;
                        break;
                    }
                    indexMatches = true;
                }
            }
            if (!indexMatches) continue;
            break;
        }
        return indexMatches;
    }

    private static void releaseResourcesOnCancel(Map<String, ResolveClusterInfo> clusterInfoMap) {
        logger.trace("clear resolve-cluster responses on cancellation");
        clusterInfoMap.clear();
    }
}

