/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.logstash.filters.elasticintegration.geoip;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ingest.geoip.shaded.com.maxmind.db.CHMCache;
import org.elasticsearch.ingest.geoip.shaded.com.maxmind.db.NoCache;
import org.elasticsearch.ingest.geoip.shaded.com.maxmind.db.NodeCache;
import org.elasticsearch.ingest.geoip.shaded.com.maxmind.db.Reader;
import org.elasticsearch.logstashbridge.core.CheckedBiFunctionBridge;
import org.elasticsearch.logstashbridge.geoip.AbstractExternalIpDatabaseBridge;

public class IpDatabaseAdapter
extends AbstractExternalIpDatabaseBridge {
    private static final Logger LOGGER = LogManager.getLogger(IpDatabaseAdapter.class);
    private final Reader databaseReader;
    private final String databaseType;
    private volatile boolean isReaderClosed = false;

    public IpDatabaseAdapter(Reader databaseReader) {
        this.databaseReader = databaseReader;
        this.databaseType = databaseReader.getMetadata().getDatabaseType();
    }

    @Override
    public String getDatabaseType() {
        return this.databaseType;
    }

    @Override
    public <RESPONSE> RESPONSE getResponse(String ipAddress, CheckedBiFunctionBridge<Reader, String, RESPONSE, Exception> responseProvider) {
        try {
            return responseProvider.apply(this.databaseReader, ipAddress);
        }
        catch (Exception e) {
            throw IpDatabaseAdapter.convertToRuntime(e);
        }
    }

    private static RuntimeException convertToRuntime(Exception e) {
        if (e instanceof RuntimeException) {
            RuntimeException re = (RuntimeException)e;
            return re;
        }
        return new RuntimeException(e);
    }

    @Override
    public void close() throws IOException {
    }

    public void closeReader() throws IOException {
        LOGGER.debug("Closing the database adapter");
        this.databaseReader.close();
        this.isReaderClosed = true;
    }

    boolean isReaderClosed() {
        return this.isReaderClosed;
    }

    public static IpDatabaseAdapter defaultForPath(Path database) throws IOException {
        return new Builder(database.toFile()).setCache(new CHMCache(10000)).build();
    }

    public static class Builder {
        private File databasePath;
        private NodeCache nodeCache;

        public Builder(File databasePath) {
            this.databasePath = databasePath;
        }

        public Builder setCache(NodeCache nodeCache) {
            this.nodeCache = nodeCache;
            return this;
        }

        public IpDatabaseAdapter build() throws IOException {
            NodeCache nodeCache = Optional.ofNullable(this.nodeCache).orElseGet(NoCache::getInstance);
            Reader databaseReader = new Reader(this.databasePath, nodeCache);
            return new IpDatabaseAdapter(databaseReader);
        }
    }
}

