"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getMonitorToPing = exports.getIntervalFromTimespan = void 0;
var _moment = _interopRequireDefault(require("moment"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getMonitorToPing = (monitor, locationId) => {
  const location = monitor.locations.find(loc => loc.id === locationId);
  return {
    monitor: {
      id: monitor.id,
      name: monitor.name,
      type: monitor.type
    },
    observer: {
      name: location === null || location === void 0 ? void 0 : location.id,
      geo: {
        name: location === null || location === void 0 ? void 0 : location.label
      }
    },
    config_id: monitor.config_id
  };
};
exports.getMonitorToPing = getMonitorToPing;
const getIntervalFromTimespan = timespan => {
  const start = (0, _moment.default)(timespan.gte);
  const end = (0, _moment.default)(timespan.lt);
  return end.diff(start, 'seconds');
};
exports.getIntervalFromTimespan = getIntervalFromTimespan;