"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getStepInformation = void 0;
var _get_journey_failed_steps = require("../../../queries/get_journey_failed_steps");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Fetches detailed step information from Elasticsearch for failed browser monitors
 */
const getStepInformation = async (esClient, checkGroup, monitorType) => {
  // Only fetch for browser monitors
  if (monitorType !== 'browser') {
    return null;
  }
  try {
    var _failedStep$synthetic, _failedStep$synthetic2, _failedStep$synthetic3, _failedStep$synthetic4, _failedStep$synthetic5, _failedStep$synthetic6;
    const failedSteps = await (0, _get_journey_failed_steps.getJourneyFailedSteps)({
      syntheticsEsClient: esClient,
      checkGroups: [checkGroup]
    });
    if (failedSteps.length === 0) {
      return null;
    }

    // Get the first failed step
    const failedStep = failedSteps[0];
    const stepName = (_failedStep$synthetic = failedStep.synthetics) === null || _failedStep$synthetic === void 0 ? void 0 : (_failedStep$synthetic2 = _failedStep$synthetic.step) === null || _failedStep$synthetic2 === void 0 ? void 0 : _failedStep$synthetic2.name;
    const scriptSource = (_failedStep$synthetic3 = failedStep.synthetics) === null || _failedStep$synthetic3 === void 0 ? void 0 : (_failedStep$synthetic4 = _failedStep$synthetic3.payload) === null || _failedStep$synthetic4 === void 0 ? void 0 : _failedStep$synthetic4.source;
    const stepNumber = (_failedStep$synthetic5 = failedStep.synthetics) === null || _failedStep$synthetic5 === void 0 ? void 0 : (_failedStep$synthetic6 = _failedStep$synthetic5.step) === null || _failedStep$synthetic6 === void 0 ? void 0 : _failedStep$synthetic6.index;
    return {
      stepName,
      scriptSource,
      stepNumber
    };
  } catch (error) {
    // Silently fail if we can't fetch step information
    return null;
  }
};
exports.getStepInformation = getStepInformation;