"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerSyntheticsStatusCheckRule = void 0;
var _server = require("@kbn/core/server");
var _lodash = require("lodash");
var _server2 = require("@kbn/alerting-plugin/server");
var _common = require("@kbn/observability-plugin/common");
var _elasticApmNode = _interopRequireDefault(require("elastic-apm-node"));
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _synthetics_monitor_status = require("@kbn/response-ops-rule-params/synthetics_monitor_status");
var _lib = require("../../lib");
var _status_rule_executor = require("./status_rule_executor");
var _synthetics_alerts = require("../../../common/constants/synthetics_alerts");
var _common2 = require("../common");
var _action_variables = require("../action_variables");
var _translations = require("../translations");
var _constants = require("../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const registerSyntheticsStatusCheckRule = (server, plugins, syntheticsMonitorClient) => {
  if (!plugins.alerting) {
    throw new Error('Cannot register the synthetics monitor status rule type. The alerting plugin needs to be enabled.');
  }
  plugins.alerting.registerType({
    id: _ruleDataUtils.SYNTHETICS_ALERT_RULE_TYPES.MONITOR_STATUS,
    category: _server.DEFAULT_APP_CATEGORIES.observability.id,
    producer: 'uptime',
    solution: _common.observabilityFeatureId,
    name: _translations.STATUS_RULE_NAME,
    validate: {
      params: _synthetics_monitor_status.syntheticsMonitorStatusRuleParamsSchema
    },
    defaultActionGroupId: _synthetics_alerts.MONITOR_STATUS.id,
    actionGroups: [_synthetics_alerts.MONITOR_STATUS],
    actionVariables: (0, _action_variables.getActionVariables)({
      plugins
    }),
    isExportable: true,
    minimumLicenseRequired: 'basic',
    doesSetRecoveryContext: true,
    executor: async options => {
      var _params$condition$gro, _params$condition, _ruleState$meta, _ruleState$meta2;
      _elasticApmNode.default.setTransactionName('Synthetics Status Rule Executor');
      const {
        state: ruleState,
        params,
        services,
        spaceId
      } = options;
      const {
        alertsClient,
        uiSettingsClient,
        scopedClusterClient,
        savedObjectsClient
      } = services;
      if (!alertsClient) {
        throw new _server2.AlertsClientError();
      }
      const {
        basePath
      } = server;
      const [dateFormat, timezone] = await Promise.all([uiSettingsClient.get('dateFormat'), uiSettingsClient.get('dateFormat:tz')]);
      const tz = timezone === 'Browser' ? 'UTC' : timezone;
      const groupBy = (_params$condition$gro = params === null || params === void 0 ? void 0 : (_params$condition = params.condition) === null || _params$condition === void 0 ? void 0 : _params$condition.groupBy) !== null && _params$condition$gro !== void 0 ? _params$condition$gro : 'locationId';
      const groupByLocation = groupBy === 'locationId';
      const esClient = new _lib.SyntheticsEsClient(savedObjectsClient, scopedClusterClient.asCurrentUser, {
        heartbeatIndices: _constants.SYNTHETICS_INDEX_PATTERN
      });
      const statusRule = new _status_rule_executor.StatusRuleExecutor(esClient, server, syntheticsMonitorClient, options);
      const {
        downConfigs,
        staleDownConfigs,
        upConfigs,
        pendingConfigs,
        stalePendingConfigs
      } = await statusRule.getConfigs({
        prevDownConfigs: (_ruleState$meta = ruleState.meta) === null || _ruleState$meta === void 0 ? void 0 : _ruleState$meta.downConfigs,
        prevPendingConfigs: (_ruleState$meta2 = ruleState.meta) === null || _ruleState$meta2 === void 0 ? void 0 : _ruleState$meta2.pendingConfigs
      });
      await statusRule.handleDownMonitorThresholdAlert({
        downConfigs
      });
      await statusRule.handlePendingMonitorAlert({
        pendingConfigs
      });
      (0, _common2.setRecoveredAlertsContext)({
        alertsClient,
        basePath,
        spaceId,
        dateFormat,
        tz,
        params,
        groupByLocation,
        staleDownConfigs,
        stalePendingConfigs,
        upConfigs
      });
      return {
        state: (0, _common2.updateState)(ruleState, !(0, _lodash.isEmpty)(downConfigs) || !(0, _lodash.isEmpty)(pendingConfigs), {
          downConfigs,
          pendingConfigs
        })
      };
    },
    alerts: _common2.SyntheticsRuleTypeAlertDefinition,
    getViewInAppRelativeUrl: ({
      rule
    }) => _common.observabilityPaths.ruleDetails(rule.id)
  });
};
exports.registerSyntheticsStatusCheckRule = registerSyntheticsStatusCheckRule;