"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getActionVariables = exports.VIEW_IN_APP_URL = exports.RECOVERY_REASON = exports.MESSAGE = exports.FAILED_STEP_NUMBER = exports.FAILED_STEP_NAME = exports.FAILED_STEP_INFO = exports.ALERT_REASON_MSG = exports.ALERT_DETAILS_URL = exports.ACTION_VARIABLES = void 0;
var _i18n = require("@kbn/i18n");
var _translations = require("./translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MESSAGE = exports.MESSAGE = 'message';
const ALERT_REASON_MSG = exports.ALERT_REASON_MSG = 'reason';
const ALERT_DETAILS_URL = exports.ALERT_DETAILS_URL = 'alertDetailsUrl';
const VIEW_IN_APP_URL = exports.VIEW_IN_APP_URL = 'viewInAppUrl';
const RECOVERY_REASON = exports.RECOVERY_REASON = 'recoveryReason';
const FAILED_STEP_INFO = exports.FAILED_STEP_INFO = 'failedStepInfo';
const FAILED_STEP_NAME = exports.FAILED_STEP_NAME = 'failedStepName';
const FAILED_STEP_NUMBER = exports.FAILED_STEP_NUMBER = 'failedStepNumber';
const GROUPING = 'grouping';
const getActionVariables = ({
  plugins
}) => {
  var _plugins$observabilit;
  return {
    context: [ACTION_VARIABLES[MESSAGE], ...((_plugins$observabilit = plugins.observability.getAlertDetailsConfig()) !== null && _plugins$observabilit !== void 0 && _plugins$observabilit.uptime.enabled ? [ACTION_VARIABLES[ALERT_DETAILS_URL]] : []), ACTION_VARIABLES[ALERT_REASON_MSG], ACTION_VARIABLES[VIEW_IN_APP_URL], ACTION_VARIABLES[RECOVERY_REASON], ACTION_VARIABLES[FAILED_STEP_INFO], ACTION_VARIABLES[FAILED_STEP_NAME], ACTION_VARIABLES[FAILED_STEP_NUMBER], ACTION_VARIABLES[GROUPING], ..._translations.commonMonitorStateI18],
    state: [..._translations.commonStateTranslations]
  };
};
exports.getActionVariables = getActionVariables;
const ACTION_VARIABLES = exports.ACTION_VARIABLES = {
  [MESSAGE]: {
    name: MESSAGE,
    description: _i18n.i18n.translate('xpack.synthetics.alertRules.monitorStatus.actionVariables.context.message.description', {
      defaultMessage: 'A generated message summarizing the status of monitors currently down'
    })
  },
  [ALERT_REASON_MSG]: {
    name: ALERT_REASON_MSG,
    description: _i18n.i18n.translate('xpack.synthetics.alertRules.monitorStatus.actionVariables.context.alertReasonMessage.description', {
      defaultMessage: 'A concise description of the reason for the alert'
    })
  },
  [ALERT_DETAILS_URL]: {
    name: ALERT_DETAILS_URL,
    description: _i18n.i18n.translate('xpack.synthetics.alertRules.monitorStatus.actionVariables.context.alertDetailUrl.description', {
      defaultMessage: 'Link to a view showing further details and context on this alert'
    }),
    usesPublicBaseUrl: true
  },
  [VIEW_IN_APP_URL]: {
    name: VIEW_IN_APP_URL,
    description: _i18n.i18n.translate('xpack.synthetics.alertRules.monitorStatus.actionVariables.context.viewInAppUrl.description', {
      defaultMessage: 'Open alert details and context in Synthetics app.'
    }),
    usesPublicBaseUrl: true
  },
  [RECOVERY_REASON]: {
    name: RECOVERY_REASON,
    description: _i18n.i18n.translate('xpack.synthetics.alertRules.monitorStatus.actionVariables.context.recoveryReason.description', {
      defaultMessage: 'A concise description of the reason for the recovery'
    })
  },
  [FAILED_STEP_INFO]: {
    name: FAILED_STEP_INFO,
    description: _i18n.i18n.translate('xpack.synthetics.alertRules.monitorStatus.actionVariables.context.failedStepInfo.description', {
      defaultMessage: 'Detailed information about the failed step for browser monitors'
    })
  },
  [FAILED_STEP_NAME]: {
    name: FAILED_STEP_NAME,
    description: _i18n.i18n.translate('xpack.synthetics.alertRules.monitorStatus.actionVariables.context.failedStepName.description', {
      defaultMessage: 'The name of the failed step for browser monitors'
    })
  },
  [FAILED_STEP_NUMBER]: {
    name: FAILED_STEP_NUMBER,
    description: _i18n.i18n.translate('xpack.synthetics.alertRules.monitorStatus.actionVariables.context.failedStepNumber.description', {
      defaultMessage: 'The number/index of the failed step for browser monitors'
    })
  },
  [GROUPING]: {
    name: GROUPING,
    description: _i18n.i18n.translate('xpack.synthetics.alertRules.monitorStatus.actionVariables.context.grouping.description', {
      defaultMessage: 'The object containing groups that are reporting data'
    })
  }
};