"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getCertsListEffect = getCertsListEffect;
var _effects = require("redux-saga/effects");
var _i18n = require("@kbn/i18n");
var _fetch_effect = require("../utils/fetch_effect");
var _api = require("./api");
var _actions = require("./actions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function* getCertsListEffect() {
  yield (0, _effects.takeLeading)(_actions.getCertsListAction.get, (0, _fetch_effect.fetchEffectFactory)(_api.getCertsList, _actions.getCertsListAction.success, _actions.getCertsListAction.fail, undefined, getFailMessage));
}
const getFailMessage = _i18n.i18n.translate('xpack.synthetics.getCerts.failed', {
  defaultMessage: 'Failed to get TLS certificates.'
});