"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDescriptionFields = void 0;
var _ui = require("../../../../../common/constants/ui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getDescriptionFields = ({
  rule,
  prebuildFields
}) => {
  if (!rule || !prebuildFields) {
    return [];
  }
  const fields = [prebuildFields.indexPattern([_ui.SYNTHETICS_INDEX_PATTERN])];
  if (rule.params.kqlQuery) {
    fields.push(prebuildFields.customQuery(rule.params.kqlQuery));
  }
  return fields;
};
exports.getDescriptionFields = getDescriptionFields;