"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TestRunDetailsStatus = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _use_journey_steps = require("../../monitor_details/hooks/use_journey_steps");
var _use_selected_monitor = require("../../monitor_details/hooks/use_selected_monitor");
var _monitor_status = require("../../common/components/monitor_status");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/test_run_details/components/test_run_details_status.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const TestRunDetailsStatus = () => {
  var _stepsData$details;
  const {
    monitor,
    isMonitorMissing
  } = (0, _use_selected_monitor.useSelectedMonitor)();
  const {
    data: stepsData,
    loading
  } = (0, _use_journey_steps.useJourneySteps)();
  if (!monitor) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
      align: "left",
      compressed: false,
      listItems: [{
        title: _monitor_status.STATUS_LABEL,
        description: isMonitorMissing && stepsData !== null && stepsData !== void 0 && stepsData.details ? /*#__PURE__*/_react.default.createElement(_monitor_status.BadgeStatus, {
          status: stepsData.details.journey.monitor.status,
          isBrowserType: stepsData.details.journey.monitor.type === 'browser',
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 29,
            columnNumber: 17
          }
        }) : /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
          lines: 1,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 34,
            columnNumber: 17
          }
        })
      }],
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 21,
        columnNumber: 7
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_monitor_status.MonitorStatus, {
    status: stepsData === null || stepsData === void 0 ? void 0 : (_stepsData$details = stepsData.details) === null || _stepsData$details === void 0 ? void 0 : _stepsData$details.journey.monitor.status,
    monitor: monitor,
    loading: loading,
    compressed: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 5
    }
  });
};
exports.TestRunDetailsStatus = TestRunDetailsStatus;