"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TestNowModeFlyoutContainer = TestNowModeFlyoutContainer;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _use_test_flyout_open = require("./hooks/use_test_flyout_open");
var _test_now_mode_flyout = require("./test_now_mode_flyout");
var _manual_test_run_mode = require("./manual_test_run_mode/manual_test_run_mode");
var _contexts = require("../../contexts");
var _manual_test_runs = require("../../state/manual_test_runs");
var _use_monitor_by_id = require("../../hooks/use_monitor_by_id");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/test_now_mode/test_now_mode_flyout_container.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function TestNowModeFlyoutContainer() {
  var _flyoutOpenTestRun$er;
  const dispatch = (0, _reactRedux.useDispatch)();
  const testNowRuns = (0, _reactRedux.useSelector)(_manual_test_runs.testNowRunsSelector);
  const {
    refreshApp
  } = (0, _contexts.useSyntheticsRefreshContext)();
  const flyoutOpenTestRun = (0, _use_test_flyout_open.useTestFlyoutOpen)();
  const onDone = (0, _react.useCallback)(testRunId => {
    dispatch((0, _manual_test_runs.manualTestRunUpdateAction)({
      testRunId,
      status: _manual_test_runs.TestRunStatus.COMPLETED
    }));
    refreshApp();
  }, [dispatch, refreshApp]);
  const handleFlyoutClose = (0, _react.useCallback)(testRunId => {
    dispatch((0, _manual_test_runs.manualTestRunUpdateAction)({
      testRunId,
      isTestNowFlyoutOpen: false
    }));
  }, [dispatch]);
  const monitor = (0, _use_monitor_by_id.useMonitorById)(flyoutOpenTestRun === null || flyoutOpenTestRun === void 0 ? void 0 : flyoutOpenTestRun.configId);
  const testRun = (0, _react.useMemo)(() => {
    return flyoutOpenTestRun !== null && flyoutOpenTestRun !== void 0 && flyoutOpenTestRun.testRunId && monitor ? {
      id: flyoutOpenTestRun.testRunId,
      monitor,
      name: monitor.name
    } : undefined;
  }, [flyoutOpenTestRun, monitor]);
  const flyout = flyoutOpenTestRun && testRun && monitor ? /*#__PURE__*/_react.default.createElement(_test_now_mode_flyout.TestNowModeFlyout, {
    testRun: testRun,
    name: monitor.name,
    inProgress: flyoutOpenTestRun.status === 'in-progress' || flyoutOpenTestRun.status === 'loading',
    onClose: () => handleFlyoutClose(flyoutOpenTestRun.testRunId),
    onDone: onDone,
    isPushing: flyoutOpenTestRun.status === 'loading',
    errors: (_flyoutOpenTestRun$er = flyoutOpenTestRun.errors) !== null && _flyoutOpenTestRun$er !== void 0 ? _flyoutOpenTestRun$er : [],
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 7
    }
  }) : null;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, Object.values(testNowRuns).filter(val => val.testRunId && (val.status === 'in-progress' || val.status === 'loading')).map(manualTestRun => /*#__PURE__*/_react.default.createElement(_manual_test_run_mode.ManualTestRunMode, {
    key: manualTestRun.testRunId,
    manualTestRun: manualTestRun,
    onDone: onDone,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 11
    }
  })), flyout);
}