"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PingListTable = PingListTable;
exports.SpanWithMargin = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _use_ping_expanded = require("./use_ping_expanded");
var _formatting = require("../../../../utils/formatting");
var _translations = _interopRequireWildcard(require("./translations"));
var I18LABELS = _translations;
var _ping_status = require("./columns/ping_status");
var _ping_error = require("./columns/ping_error");
var _response_code = require("./columns/response_code");
var _expand_row = require("./columns/expand_row");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/test_now_mode/simple/ping_list/ping_list_table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function PingListTable({
  loading,
  error,
  pings,
  onChange
}) {
  const {
    expandedRows,
    setExpandedRows
  } = (0, _use_ping_expanded.useExpandedPingList)(pings);
  const hasStatus = pings.reduce((hasHttpStatus, currentPing) => {
    var _currentPing$http, _currentPing$http$res;
    return hasHttpStatus || !!((_currentPing$http = currentPing.http) !== null && _currentPing$http !== void 0 && (_currentPing$http$res = _currentPing$http.response) !== null && _currentPing$http$res !== void 0 && _currentPing$http$res.status_code);
  }, false);
  const hasError = pings.reduce((errorType, currentPing) => {
    var _currentPing$error;
    return errorType || !!((_currentPing$error = currentPing.error) !== null && _currentPing$error !== void 0 && _currentPing$error.type);
  }, false);
  const columns = [{
    field: 'monitor.status',
    name: I18LABELS.STATUS_LABEL,
    render: (pingStatus, item) => /*#__PURE__*/_react.default.createElement(_ping_status.PingStatusColumn, {
      pingStatus: pingStatus,
      item: item,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 48,
        columnNumber: 9
      }
    })
  }, {
    align: 'left',
    field: 'observer.geo.name',
    name: _translations.LOCATION_LABEL
  }, {
    align: 'right',
    field: 'monitor.ip',
    name: _i18n.i18n.translate('xpack.synthetics.pingList.ipAddressColumnLabel', {
      defaultMessage: 'IP'
    })
  }, {
    align: 'center',
    field: 'monitor.duration.us',
    name: _i18n.i18n.translate('xpack.synthetics.pingList.durationMsColumnLabel', {
      defaultMessage: 'Duration'
    }),
    render: duration => duration ? (0, _formatting.formatDuration)(duration) : /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": "ping-list-duration-unavailable-tool-tip",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 73,
        columnNumber: 11
      }
    }, '--')
  }, ...(hasError ? [{
    field: 'error.type',
    name: _translations.ERROR_LABEL,
    width: '30%',
    render: (errorType, item) => /*#__PURE__*/_react.default.createElement(_ping_error.PingErrorCol, {
      ping: item,
      errorType: errorType,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 83,
        columnNumber: 15
      }
    })
  }] : []),
  // Only add this column is there is any status present in list
  ...(hasStatus ? [{
    field: 'http.response.status_code',
    align: 'right',
    name: /*#__PURE__*/_react.default.createElement(SpanWithMargin, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 94,
        columnNumber: 19
      }
    }, _translations.RES_CODE_LABEL),
    render: statusCode => /*#__PURE__*/_react.default.createElement(_response_code.ResponseCodeColumn, {
      statusCode: statusCode,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 95,
        columnNumber: 45
      }
    })
  }] : []), {
    align: 'right',
    width: '24px',
    isExpander: true,
    render: item => /*#__PURE__*/_react.default.createElement(_expand_row.ExpandRowColumn, {
      item: item,
      expandedRows: expandedRows,
      setExpandedRows: setExpandedRows,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 104,
        columnNumber: 9
      }
    })
  }];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    loading: loading,
    columns: columns,
    error: error === null || error === void 0 ? void 0 : error.message,
    items: pings,
    itemId: "docId",
    itemIdToExpandedRowMap: expandedRows,
    noItemsMessage: loading ? _i18n.i18n.translate('xpack.synthetics.pingList.pingsLoadingMesssage', {
      defaultMessage: 'Loading history...'
    }) : _i18n.i18n.translate('xpack.synthetics.pingList.pingsUnavailableMessage', {
      defaultMessage: 'No history found'
    }),
    tableLayout: "auto",
    onChange: onChange,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 5
    }
  });
}
const SpanWithMargin = exports.SpanWithMargin = _styledComponents.default.span`
  margin-right: 16px;
`;