"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FAILED_TO_RUN = exports.ERROR_RUNNING_TEST = exports.BrowserTestRunResult = void 0;
var _react = _interopRequireWildcard(require("react"));
var React = _react;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _browser_test_results = require("../manual_test_run_mode/browser_test_results");
var _browser_steps_list = require("../../common/monitor_test_result/browser_steps_list");
var _use_browser_run_once_monitors = require("../hooks/use_browser_run_once_monitors");
var _test_result_header = require("../test_result_header");
var _stderr_logs = require("../../common/components/stderr_logs");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/test_now_mode/browser/browser_test_results.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const BrowserTestRunResult = ({
  expectPings,
  onDone,
  testRunId
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    retriesExceeded,
    summariesLoading,
    expectedSummariesLoaded,
    stepLoadingInProgress,
    checkGroupResults
  } = (0, _use_browser_run_once_monitors.useBrowserRunOnceMonitors)({
    testRunId,
    expectSummaryDocs: expectPings
  });
  (0, _react.useEffect)(() => {
    if (expectedSummariesLoaded) {
      onDone(testRunId);
    }
  }, [onDone, expectedSummariesLoaded, testRunId]);
  if (retriesExceeded) {
    return /*#__PURE__*/React.createElement(_eui.EuiCallOut, {
      announceOnMount: true,
      title: _browser_test_results.FAILED_TO_SCHEDULE,
      color: "danger",
      iconType: "alert",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 56,
        columnNumber: 7
      }
    });
  }
  return /*#__PURE__*/React.createElement(React.Fragment, null, checkGroupResults.map(checkGroupResult => {
    var _summaryDoc$monitor, _summaryDoc$error$mes, _summaryDoc$error, _summaryDoc$error2, _summaryDoc$error2$me;
    const {
      checkGroupId,
      journeyStarted,
      summaryDoc,
      stepsLoading,
      steps,
      completedSteps
    } = checkGroupResult;
    const isStepsLoading = !summariesLoading && journeyStarted && summaryDoc && stepsLoading;
    const isStepsLoadingFailed = summaryDoc && !summariesLoading && !stepLoadingInProgress && steps.length === 0;
    const isDownMonitor = (summaryDoc === null || summaryDoc === void 0 ? void 0 : (_summaryDoc$monitor = summaryDoc.monitor) === null || _summaryDoc$monitor === void 0 ? void 0 : _summaryDoc$monitor.status) === 'down';
    return /*#__PURE__*/React.createElement(AccordionWrapper, {
      key: 'accordion-' + checkGroupId,
      id: 'accordion-' + checkGroupId,
      element: "fieldset",
      borders: "horizontal",
      buttonProps: {
        paddingSize: 'm'
      },
      buttonContent: getButtonContent(checkGroupResult),
      paddingSize: "s",
      "data-test-subj": "expandResults",
      initialIsOpen: checkGroupResults.length === 1,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 72,
        columnNumber: 11
      }
    }, isStepsLoading && /*#__PURE__*/React.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "xs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 84,
        columnNumber: 15
      }
    }, /*#__PURE__*/React.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 85,
        columnNumber: 17
      }
    }, /*#__PURE__*/React.createElement(_eui.EuiText, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 86,
        columnNumber: 19
      }
    }, LOADING_STEPS)), /*#__PURE__*/React.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 88,
        columnNumber: 17
      }
    }, /*#__PURE__*/React.createElement(_eui.EuiLoadingSpinner, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 89,
        columnNumber: 19
      }
    }))), (isStepsLoadingFailed || isDownMonitor) && /*#__PURE__*/React.createElement(_eui.EuiCallOut, {
      announceOnMount: true,
      "data-test-subj": "monitorTestRunErrorCallout",
      style: {
        marginTop: euiTheme.base,
        marginBottom: euiTheme.base,
        borderRadius: euiTheme.border.radius.medium,
        fontWeight: euiTheme.font.weight.semiBold
      },
      title: ERROR_RUNNING_TEST,
      size: "s",
      color: "danger",
      iconType: "warning",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 95,
        columnNumber: 15
      }
    }, /*#__PURE__*/React.createElement(_eui.EuiText, {
      color: "danger",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 109,
        columnNumber: 17
      }
    }, (_summaryDoc$error$mes = summaryDoc === null || summaryDoc === void 0 ? void 0 : (_summaryDoc$error = summaryDoc.error) === null || _summaryDoc$error === void 0 ? void 0 : _summaryDoc$error.message) !== null && _summaryDoc$error$mes !== void 0 ? _summaryDoc$error$mes : FAILED_TO_RUN)), (isStepsLoadingFailed || isDownMonitor) && (summaryDoc === null || summaryDoc === void 0 ? void 0 : (_summaryDoc$error2 = summaryDoc.error) === null || _summaryDoc$error2 === void 0 ? void 0 : (_summaryDoc$error2$me = _summaryDoc$error2.message) === null || _summaryDoc$error2$me === void 0 ? void 0 : _summaryDoc$error2$me.includes('journey did not finish executing')) && /*#__PURE__*/React.createElement(_stderr_logs.StdErrorLogs, {
      checkGroup: summaryDoc.monitor.check_group,
      hideTitle: completedSteps === 0,
      pageSize: completedSteps === 0 ? 5 : 2,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 115,
        columnNumber: 17
      }
    }), completedSteps > 0 && /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(_eui.EuiTitle, {
      size: "xxxs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 124,
        columnNumber: 17
      }
    }, /*#__PURE__*/React.createElement("h3", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 125,
        columnNumber: 19
      }
    }, STEPS_LABEL)), /*#__PURE__*/React.createElement(_browser_steps_list.BrowserStepsList, {
      steps: steps,
      loading: Boolean(stepLoadingInProgress),
      error: undefined,
      showStepNumber: true,
      compressed: true,
      testNowMode: true,
      showLastSuccessful: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 127,
        columnNumber: 17
      }
    })));
  }));
};
exports.BrowserTestRunResult = BrowserTestRunResult;
const AccordionWrapper = (0, _styledComponents.default)(_eui.EuiAccordion)`
  .euiAccordion__buttonContent {
    width: 100%;
  }
`;
function getButtonContent({
  journeyDoc,
  summaryDoc,
  checkGroupId,
  journeyStarted,
  completedSteps
}) {
  var _journeyDoc$observer, _journeyDoc$observer$;
  const completedText = _i18n.i18n.translate('xpack.synthetics.monitorManagement.stepCompleted', {
    defaultMessage: '{stepCount, number} {stepCount, plural, one {step} other {steps}}  completed',
    values: {
      stepCount: completedSteps !== null && completedSteps !== void 0 ? completedSteps : 0
    }
  });
  return /*#__PURE__*/React.createElement("div", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 166,
      columnNumber: 5
    }
  }, /*#__PURE__*/React.createElement(_test_result_header.TestResultHeader, {
    title: journeyDoc === null || journeyDoc === void 0 ? void 0 : (_journeyDoc$observer = journeyDoc.observer) === null || _journeyDoc$observer === void 0 ? void 0 : (_journeyDoc$observer$ = _journeyDoc$observer.geo) === null || _journeyDoc$observer$ === void 0 ? void 0 : _journeyDoc$observer$.name,
    summaryDocs: summaryDoc ? [summaryDoc] : [],
    checkGroupId: checkGroupId,
    journeyStarted: journeyStarted,
    isCompleted: Boolean(summaryDoc),
    configId: journeyDoc === null || journeyDoc === void 0 ? void 0 : journeyDoc.config_id,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 167,
      columnNumber: 7
    }
  }), /*#__PURE__*/React.createElement(_eui.EuiText, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 175,
      columnNumber: 7
    }
  }, /*#__PURE__*/React.createElement("p", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 176,
      columnNumber: 9
    }
  }, /*#__PURE__*/React.createElement(_eui.EuiText, {
    color: "subdued",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 177,
      columnNumber: 11
    }
  }, completedText)), /*#__PURE__*/React.createElement(_eui.EuiScreenReaderLive, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 179,
      columnNumber: 9
    }
  }, completedText)));
}
const FAILED_TO_RUN = exports.FAILED_TO_RUN = _i18n.i18n.translate('xpack.synthetics.monitorManagement.failedRun', {
  defaultMessage: 'Failed to run steps'
});
const ERROR_RUNNING_TEST = exports.ERROR_RUNNING_TEST = _i18n.i18n.translate('xpack.synthetics.testRun.testErrorLabel', {
  defaultMessage: 'Error running test'
});
const LOADING_STEPS = _i18n.i18n.translate('xpack.synthetics.monitorManagement.loadingSteps', {
  defaultMessage: 'Loading steps...'
});
const STEPS_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorManagement.steps', {
  defaultMessage: 'Steps'
});