"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NetworkRequestsTotal = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/step_details_page/step_waterfall_chart/waterfall/waterfall_header/network_requests_total.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const NetworkRequestsTotal = ({
  totalNetworkRequests,
  fetchedNetworkRequests,
  highlightedNetworkRequests
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 25,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 26,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.synthetics.waterfall.networkRequests.count",
    defaultMessage: "Showing {countShown} of {total} {networkRequestsLabel}",
    values: {
      countShown: /*#__PURE__*/_react.default.createElement("strong", {
        "data-test-subj": "syntheticsWaterfallChartCountShown",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 32,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiI18nNumber, {
        value: highlightedNetworkRequests,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 33,
          columnNumber: 17
        }
      })),
      total: /*#__PURE__*/_react.default.createElement(_eui.EuiI18nNumber, {
        value: totalNetworkRequests,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 36,
          columnNumber: 20
        }
      }),
      networkRequestsLabel: /*#__PURE__*/_react.default.createElement("strong", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 38,
          columnNumber: 15
        }
      }, _i18n.i18n.translate('xpack.synthetics.waterfall.networkRequests.pluralizedCount', {
        defaultMessage: '{total, plural, one {network request} other {network requests}}',
        values: {
          total: totalNetworkRequests
        }
      }))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 27,
      columnNumber: 9
    }
  }), totalNetworkRequests > fetchedNetworkRequests && /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    type: "info",
    color: "warning",
    content: _i18n.i18n.translate('xpack.synthetics.synthetics.waterfall.requestsTotalMessage.info', {
      defaultMessage: 'Waterfall view only shows up to 1000 requests'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 11
    }
  })));
};
exports.NetworkRequestsTotal = NetworkRequestsTotal;