"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NetworkTimingsDonut = void 0;
var _charts = require("@elastic/charts");
var _eui = require("@elastic/eui");
var _chartsTheme = require("@kbn/charts-theme");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _data_formatting = require("../common/network_data/data_formatting");
var _use_network_timings = require("../hooks/use_network_timings");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/step_details_page/step_timing_breakdown/network_timings_donut.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const themeOverrides = {
  chartMargins: {
    top: 0,
    bottom: 0,
    left: 0,
    right: 0
  },
  partition: {
    linkLabel: {
      maximumSection: Infinity,
      maxCount: 0
    },
    idealFontSizeJump: 1.1,
    outerSizeRatio: 0.9,
    emptySizeRatio: 0.6,
    circlePadding: 5
  }
};
const NetworkTimingsDonut = () => {
  const networkTimings = (0, _use_network_timings.useNetworkTimings)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const chartBaseTheme = (0, _chartsTheme.useElasticChartsTheme)();
  if (!networkTimings) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "xl",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 47,
        columnNumber: 12
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 13
    }
  }, TIMINGS_BREAKDOWN))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    content: SUM_TIMINGS,
    position: "right",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.Chart, {
    size: {
      height: 240
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_charts.Settings, {
    theme: [themeOverrides],
    baseTheme: chartBaseTheme,
    showLegend: false,
    locale: _i18n.i18n.getLocale(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.Partition, {
    id: "spec_1",
    data: networkTimings.timingsWithLabels,
    layout: _charts.PartitionLayout.sunburst,
    valueAccessor: d => d === null || d === void 0 ? void 0 : d.value,
    valueFormatter: d => (0, _data_formatting.formatMillisecond)(d, {}),
    layers: [{
      groupByRollup: d => d.label,
      nodeLabel: d => d,
      shape: {
        fillColor: (dataName, index) => {
          // @ts-ignore
          const color = euiTheme.colors.vis[`euiColorVis${index + 1}`];
          return color;
        }
      }
    }],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 9
    }
  })));
};
exports.NetworkTimingsDonut = NetworkTimingsDonut;
const TIMINGS_BREAKDOWN = _i18n.i18n.translate('xpack.synthetics.stepDetailsRoute.timingsBreakdown', {
  defaultMessage: 'Timing breakdown'
});
const SUM_TIMINGS = _i18n.i18n.translate('xpack.synthetics.stepDetailsRoute.timingsBreakdown.info', {
  defaultMessage: 'Sum of all network request timings'
});