"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StepDetailsStatus = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _status_badge = require("../common/monitor_test_result/status_badge");
var _use_journey_steps = require("../monitor_details/hooks/use_journey_steps");
var _monitor_status = require("../common/components/monitor_status");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/step_details_page/step_details_status.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const StepDetailsStatus = () => {
  var _currentStep$syntheti;
  const {
    currentStep
  } = (0, _use_journey_steps.useJourneySteps)();
  let content = /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
    lines: 1,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 17,
      columnNumber: 17
    }
  });
  if (currentStep !== null && currentStep !== void 0 && (_currentStep$syntheti = currentStep.synthetics.step) !== null && _currentStep$syntheti !== void 0 && _currentStep$syntheti.status) {
    var _currentStep$syntheti2;
    content = /*#__PURE__*/_react.default.createElement(_status_badge.StatusBadge, {
      status: (0, _status_badge.parseBadgeStatus)((_currentStep$syntheti2 = currentStep.synthetics.step) === null || _currentStep$syntheti2 === void 0 ? void 0 : _currentStep$syntheti2.status),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 20,
        columnNumber: 15
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    align: "left",
    compressed: false,
    listItems: [{
      title: _monitor_status.STATUS_LABEL,
      description: content
    }],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 24,
      columnNumber: 5
    }
  });
};
exports.StepDetailsStatus = StepDetailsStatus;