"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getStepDetailsRoute = void 0;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _reactReversePortal = require("react-reverse-portal");
var _step_page_nav = require("./step_page_nav");
var _step_number_nav = require("./step_number_nav");
var _step_details_status = require("./step_details_status");
var _monitor_details_location = require("../monitor_details/monitor_details_location");
var _step_detail_page = require("./step_detail_page");
var _constants = require("../../../../../common/constants");
var _portals = require("../monitor_add_edit/portals");
var _step_title = require("./step_title");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/step_details_page/route_config.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const getStepDetailsRoute = (history, syntheticsPath, baseTitle) => {
  return {
    title: _i18n.i18n.translate('xpack.synthetics.stepDetailsRoute.title', {
      defaultMessage: 'Step details | {baseTitle}',
      values: {
        baseTitle
      }
    }),
    path: _constants.SYNTHETICS_STEP_DETAIL_ROUTE,
    component: _step_detail_page.StepDetailPage,
    dataTestSubj: 'syntheticsMonitorEditPage',
    pageHeader: {
      pageTitle: /*#__PURE__*/_react.default.createElement(_step_title.StepTitle, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 36,
          columnNumber: 18
        }
      }),
      rightSideItems: [/*#__PURE__*/_react.default.createElement(_step_page_nav.StepRunDate, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 38,
          columnNumber: 9
        }
      }), /*#__PURE__*/_react.default.createElement(_monitor_details_location.MonitorDetailsLocation, {
        isDisabled: true,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 39,
          columnNumber: 9
        }
      }), /*#__PURE__*/_react.default.createElement(_step_details_status.StepDetailsStatus, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 40,
          columnNumber: 9
        }
      }), /*#__PURE__*/_react.default.createElement(_step_number_nav.StepDetailPageStepNav, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 41,
          columnNumber: 9
        }
      })],
      breadcrumbs: [{
        text: /*#__PURE__*/_react.default.createElement(_reactReversePortal.OutPortal, {
          node: _portals.MonitorDetailsLinkPortalNode,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 45,
            columnNumber: 17
          }
        })
      }]
    }
  };
};
exports.getStepDetailsRoute = getStepDetailsRoute;