"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ApiKeyBtn = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/settings/project_api_keys/api_key_btn.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ApiKeyBtn = ({
  isDisabled,
  apiKey,
  loading,
  onClick: callback
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 24,
      columnNumber: 7
    }
  }), !apiKey && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    isDisabled: isDisabled,
    fullWidth: true,
    isLoading: loading,
    color: "primary",
    onClick: () => callback(),
    "data-test-subj": "uptimeMonitorManagementApiKeyGenerate",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 27,
      columnNumber: 11
    }
  }, loading ? GET_API_KEY_LOADING_LABEL : GET_API_KEY_LABEL), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 11
    }
  })));
};
exports.ApiKeyBtn = ApiKeyBtn;
const GET_API_KEY_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorManagement.getProjectApiKey.label', {
  defaultMessage: 'Generate Project API key'
});
const GET_API_KEY_LOADING_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorManagement.getAPIKeyLabel.loading', {
  defaultMessage: 'Generating API key'
});