"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ManagePrivateLocations = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _public = require("@kbn/kibana-react-plugin/public");
var _lodash = require("lodash");
var _monitor_detail_flyout = require("../../monitors_page/overview/overview/monitor_detail_flyout");
var _locations_table = require("./locations_table");
var _manage_empty_state = require("./manage_empty_state");
var _add_or_edit_location_flyout = require("./add_or_edit_location_flyout");
var _use_locations_api = require("./hooks/use_locations_api");
var _selectors = require("../../../state/private_locations/selectors");
var _state = require("../../../state");
var _agent_policies = require("../../../state/agent_policies");
var _actions = require("../../../state/private_locations/actions");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/settings/private_locations/manage_private_locations.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const getEmptyFunctionComponent = ({
  children
}) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children);
const ManagePrivateLocations = () => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    services
  } = (0, _public.useKibana)();
  const spacesApi = services.spaces;
  const SpacesContextProvider = (0, _react.useMemo)(() => spacesApi ? spacesApi.ui.components.getSpacesContextProvider : getEmptyFunctionComponent, [spacesApi]);
  const isPrivateLocationFlyoutVisible = (0, _reactRedux.useSelector)(_selectors.selectPrivateLocationFlyoutVisible);
  const privateLocationToEdit = (0, _reactRedux.useSelector)(_selectors.selectPrivateLocationToEdit);
  const setIsFlyoutOpen = (0, _react.useCallback)(val => dispatch((0, _actions.setIsPrivateLocationFlyoutVisible)(val)), [dispatch]);
  const {
    onCreateLocationAPI,
    onEditLocationAPI,
    loading,
    privateLocations,
    onDeleteLocationAPI,
    deleteLoading
  } = (0, _use_locations_api.usePrivateLocationsAPI)();
  (0, _react.useEffect)(() => {
    dispatch(_agent_policies.getAgentPoliciesAction.get());
    dispatch((0, _state.getServiceLocations)());
    // make sure flyout is closed when first visiting the page
    dispatch((0, _actions.setIsPrivateLocationFlyoutVisible)(false));
  }, [dispatch]);
  const handleSubmit = formData => {
    if (privateLocationToEdit) {
      const isLabelChanged = formData.label !== privateLocationToEdit.label;
      const areTagsChanged = !(0, _lodash.isEqual)(formData.tags, privateLocationToEdit.tags);
      if (!isLabelChanged && !areTagsChanged) {
        onCloseFlyout();
      } else {
        onEditLocationAPI(privateLocationToEdit.id, {
          label: formData.label,
          tags: formData.tags
        });
      }
    } else {
      onCreateLocationAPI(formData);
    }
  };
  const onEditLocation = privateLocation => {
    dispatch((0, _actions.setPrivateLocationToEdit)(privateLocation));
    setIsFlyoutOpen(true);
  };
  const onCloseFlyout = () => {
    if (privateLocationToEdit) {
      dispatch((0, _actions.setPrivateLocationToEdit)(undefined));
    }
    setIsFlyoutOpen(false);
  };
  return /*#__PURE__*/_react.default.createElement(SpacesContextProvider, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 5
    }
  }, loading ? /*#__PURE__*/_react.default.createElement(_monitor_detail_flyout.LoadingState, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 9
    }
  }) : /*#__PURE__*/_react.default.createElement(_manage_empty_state.ManageEmptyState, {
    privateLocations: privateLocations,
    setIsFlyoutOpen: setIsFlyoutOpen,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_locations_table.PrivateLocationsTable, {
    privateLocations: privateLocations,
    onDelete: onDeleteLocationAPI,
    onEdit: onEditLocation,
    deleteLoading: deleteLoading,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 11
    }
  })), isPrivateLocationFlyoutVisible ? /*#__PURE__*/_react.default.createElement(_add_or_edit_location_flyout.AddOrEditLocationFlyout, {
    onCloseFlyout: onCloseFlyout,
    onSubmit: handleSubmit,
    privateLocations: privateLocations,
    privateLocationToEdit: privateLocationToEdit,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 9
    }
  }) : null);
};
exports.ManagePrivateLocations = ManagePrivateLocations;