"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.START_ADDING_LOCATIONS_DESCRIPTION = exports.READ_DOCS = exports.PrivateLocationDocsLink = exports.LEARN_MORE = exports.EmptyLocations = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _reactRedux = require("react-redux");
var _permissions = require("../../common/components/permissions");
var _contexts = require("../../../contexts");
var _constants = require("../../../../../../common/constants");
var _actions = require("../../../state/private_locations/actions");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/settings/private_locations/empty_locations.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const EmptyLocations = ({
  inFlyout = true,
  setIsFlyoutOpen,
  redirectToSettings
}) => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const history = (0, _reactRouterDom.useHistory)();
  const {
    canSave
  } = (0, _contexts.useSyntheticsSettingsContext)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    hasBorder: true,
    title: /*#__PURE__*/_react.default.createElement("h2", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 38,
        columnNumber: 14
      }
    }, ADD_FIRST_LOCATION),
    titleSize: "s",
    body: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 41,
        columnNumber: 9
      }
    }, !inFlyout ? FIRST_MONITOR : '', " ", START_ADDING_LOCATIONS_DESCRIPTION),
    actions: /*#__PURE__*/_react.default.createElement(_permissions.NoPermissionsTooltip, {
      canEditSynthetics: canSave,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 46,
        columnNumber: 9
      }
    }, redirectToSettings ? /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "syntheticsEmptyLocationsButton",
      iconType: "plusInCircle",
      color: "primary",
      fill: true,
      isDisabled: !canSave,
      href: history.createHref({
        pathname: _constants.PRIVATE_LOCATIONS_ROUTE
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 48,
        columnNumber: 13
      }
    }, ADD_LOCATION) : /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "syntheticsEmptyLocationsButton",
      iconType: "plusInCircle",
      isDisabled: !canSave,
      color: "primary",
      fill: true,
      onClick: () => {
        setIsFlyoutOpen === null || setIsFlyoutOpen === void 0 ? void 0 : setIsFlyoutOpen(true);
        dispatch((0, _actions.setManageFlyoutOpen)(true));
        dispatch((0, _actions.setIsPrivateLocationFlyoutVisible)(true));
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 61,
        columnNumber: 13
      }
    }, ADD_LOCATION)),
    footer: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 79,
        columnNumber: 9
      }
    }, LEARN_MORE, " ", /*#__PURE__*/_react.default.createElement(PrivateLocationDocsLink, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 80,
        columnNumber: 24
      }
    })),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 5
    }
  });
};
exports.EmptyLocations = EmptyLocations;
const PrivateLocationDocsLink = ({
  label
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
  "data-test-subj": "syntheticsPrivateLocationDocsLinkLink",
  href: "https://www.elastic.co/guide/en/observability/current/synthetics-private-location.html",
  target: "_blank",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 88,
    columnNumber: 3
  }
}, label !== null && label !== void 0 ? label : READ_DOCS);
exports.PrivateLocationDocsLink = PrivateLocationDocsLink;
const FIRST_MONITOR = _i18n.i18n.translate('xpack.synthetics.monitorManagement.firstLocationMonitor', {
  defaultMessage: 'In order to create a monitor, you will need to add a location first.'
});
const ADD_FIRST_LOCATION = _i18n.i18n.translate('xpack.synthetics.monitorManagement.createFirstLocation', {
  defaultMessage: 'Create your first private location'
});
const START_ADDING_LOCATIONS_DESCRIPTION = exports.START_ADDING_LOCATIONS_DESCRIPTION = _i18n.i18n.translate('xpack.synthetics.monitorManagement.startAddingLocationsDescription', {
  defaultMessage: 'Private locations allow you to run monitors from your own premises. They require an Elastic agent and Agent policy which you can control and maintain via Fleet.'
});
const ADD_LOCATION = _i18n.i18n.translate('xpack.synthetics.monitorManagement.createLocation', {
  defaultMessage: 'Create location'
});
const READ_DOCS = exports.READ_DOCS = _i18n.i18n.translate('xpack.synthetics.monitorManagement.readDocs', {
  defaultMessage: 'read the docs'
});
const LEARN_MORE = exports.LEARN_MORE = _i18n.i18n.translate('xpack.synthetics.monitorManagement.learnMore', {
  defaultMessage: 'For more information,'
});