"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DefaultConnectorField = DefaultConnectorField;
exports.TAGS_LABEL = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _i18nReact = require("@kbn/i18n-react");
var _hooks = require("../../../hooks");
var _use_alerting_defaults = require("./hooks/use_alerting_defaults");
var _translations = require("./translations");
var _add_connector_flyout = require("./add_connector_flyout");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/settings/alerting_defaults/connector_field.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function DefaultConnectorField({
  isLoading,
  isDisabled,
  onChange,
  selectedConnectors
}) {
  const {
    options
  } = (0, _use_alerting_defaults.useAlertingDefaults)();
  const inputRef = (0, _react.useRef)(null);
  const {
    focusConnectorField
  } = (0, _hooks.useGetUrlParams)();
  const updateUrlParams = (0, _hooks.useUrlParams)()[1];
  const [error, setError] = (0, _react.useState)(undefined);
  (0, _react.useEffect)(() => {
    if (focusConnectorField && inputRef.current && !isLoading) {
      inputRef.current.focus();
    }
  }, [focusConnectorField, inputRef, isLoading]);
  const onBlur = () => {
    if (inputRef.current) {
      const {
        value
      } = inputRef.current;
      setError(value.length === 0 ? undefined : `"${value}" is not a valid option`);
    }
    if (inputRef.current && !isLoading && focusConnectorField) {
      updateUrlParams({
        focusConnectorField: undefined
      });
    }
  };
  const onSearchChange = (value, hasMatchingOptions) => {
    setError(value.length === 0 || hasMatchingOptions ? undefined : `"${value}" is not a valid option`);
  };
  return /*#__PURE__*/_react.default.createElement(RowWrapper, {
    describedByIds: ['defaultConnectors'],
    error: error,
    fullWidth: true,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.synthetics.sourceConfiguration.defaultConnectors",
      defaultMessage: "Default connectors",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 67,
        columnNumber: 9
      }
    }),
    labelAppend: /*#__PURE__*/_react.default.createElement(_add_connector_flyout.AddConnectorFlyout, {
      isDisabled: isDisabled,
      focusInput: (0, _react.useCallback)(() => {
        if (inputRef.current) {
          inputRef.current.focus();
        }
      }, []),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 73,
        columnNumber: 9
      }
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    inputRef: input => {
      inputRef.current = input;
    },
    placeholder: _translations.alertFormI18n.inputPlaceHolder,
    options: options,
    selectedOptions: options.filter(opt => selectedConnectors === null || selectedConnectors === void 0 ? void 0 : selectedConnectors.includes(opt.value)),
    onBlur: onBlur,
    isDisabled: isDisabled,
    "data-test-subj": `default-connectors-input-${isLoading ? 'loading' : 'loaded'}`,
    fullWidth: true,
    "aria-label": TAGS_LABEL,
    isLoading: isLoading,
    onChange: newSelectedConnectors => {
      onChange(newSelectedConnectors.map(tag => tag.value));
    },
    onSearchChange: onSearchChange,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 7
    }
  }));
}
const RowWrapper = (0, _styledComponents.default)(_eui.EuiFormRow)`
  &&& > .euiFormRow__labelWrapper {
    align-items: baseline;
  }
`;
const TAGS_LABEL = exports.TAGS_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorManagement.paramForm.tagsLabel', {
  defaultMessage: 'Tags'
});