"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OverviewGrid = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _eui = require("@elastic/eui");
var _use_overview_trends_requests = require("../../hooks/use_overview_trends_requests");
var _show_all_spaces = require("../../common/show_all_spaces");
var _constants = require("../../../../../embeddables/constants");
var _add_to_dashboard = require("../../../common/components/add_to_dashboard");
var _use_overview_status = require("../../hooks/use_overview_status");
var _group_fields = require("./grid_by_group/group_fields");
var _overview = require("../../../../state/overview");
var _use_monitors_sorted_by_status = require("../../../../hooks/use_monitors_sorted_by_status");
var _overview_pagination_info = require("./overview_pagination_info");
var _sort_fields = require("./sort_fields");
var _no_monitors_found = require("../../common/no_monitors_found");
var _contexts = require("../../../../contexts");
var _monitor_detail_flyout = require("./monitor_detail_flyout");
var _overview_grid_compact_view = require("./compact_view/overview_grid_compact_view");
var _view_buttons = require("./view_buttons/view_buttons");
var _overview_card_view = require("./overview_cards_view/overview_card_view");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/monitors_page/overview/overview/overview_grid.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const OverviewGrid = exports.OverviewGrid = /*#__PURE__*/(0, _react.memo)(({
  view,
  isEmbeddable
}) => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    status,
    loaded: isInitialized,
    loading
  } = (0, _use_overview_status.useOverviewStatus)({
    scopeStatusByLocation: true
  });
  const monitorsSortedByStatus = (0, _use_monitors_sorted_by_status.useMonitorsSortedByStatus)();
  const [maxItem, setMaxItem] = (0, _react.useState)(0);
  (0, _use_overview_trends_requests.useOverviewTrendsRequests)(monitorsSortedByStatus, maxItem);
  const setFlyoutConfigCallback = (0, _react.useCallback)(params => dispatch((0, _overview.setFlyoutConfig)(params)), [dispatch]);
  const {
    lastRefresh
  } = (0, _contexts.useSyntheticsRefreshContext)();
  (0, _react.useEffect)(() => {
    dispatch(_overview.refreshOverviewTrends.get());
  }, [dispatch, lastRefresh]);

  // Display no monitors found when down, up, or disabled filter produces no results
  if (status && !monitorsSortedByStatus.length && isInitialized) {
    return /*#__PURE__*/_react.default.createElement(_no_monitors_found.NoMonitorsFound, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 59,
        columnNumber: 14
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center",
    responsive: false,
    wrap: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_overview_pagination_info.OverviewPaginationInfo, {
    total: status ? monitorsSortedByStatus.length : undefined,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_show_all_spaces.ShowAllSpaces, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_add_to_dashboard.AddToDashboard, {
    type: _constants.SYNTHETICS_MONITORS_EMBEDDABLE,
    asButton: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_sort_fields.SortFields, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_group_fields.GroupFields, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 13
    }
  })), !isEmbeddable ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_view_buttons.ViewButtons, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 15
    }
  })) : null), loading && isInitialized ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
    size: "xs",
    color: "accent",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    css: {
      blockSize: 14
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 13
    }
  })) : /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 11
    }
  }), view === 'cardView' ? /*#__PURE__*/_react.default.createElement(_overview_card_view.OverviewCardView, {
    monitorsSortedByStatus: monitorsSortedByStatus,
    maxItem: maxItem,
    setMaxItem: setMaxItem,
    setFlyoutConfigCallback: setFlyoutConfigCallback,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 11
    }
  }) : view === 'compactView' ? /*#__PURE__*/_react.default.createElement(_overview_grid_compact_view.OverviewGridCompactView, {
    setFlyoutConfigCallback: setFlyoutConfigCallback,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 11
    }
  }) : null, /*#__PURE__*/_react.default.createElement(_monitor_detail_flyout.MaybeMonitorDetailsFlyout, {
    setFlyoutConfigCallback: setFlyoutConfigCallback,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 9
    }
  }));
});