"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CardsViewFooter = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _reactRedux = require("react-redux");
var _use_overview_status = require("../../../hooks/use_overview_status");
var _state = require("../../../../../state");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/monitors_page/overview/overview/overview_cards_view/cards_view_footer.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const OVERVIEW_ROW_COUNT = 4;
const CardsViewFooter = ({
  monitorsSortedByStatus,
  currentIndex
}) => {
  const {
    pageState: {
      perPage
    },
    groupBy: {
      field: groupField
    }
  } = (0, _reactRedux.useSelector)(_state.selectOverviewState);
  const isUnGrouped = groupField === 'none';
  const {
    allConfigs,
    loaded
  } = (0, _use_overview_status.useOverviewStatus)({
    scopeStatusByLocation: true
  });
  if (isUnGrouped && loaded &&
  // display this footer when user scrolls to end of list
  currentIndex * OVERVIEW_ROW_COUNT + OVERVIEW_ROW_COUNT >= monitorsSortedByStatus.length) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 7
    }
  }, monitorsSortedByStatus.length === allConfigs.length && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 13
    }
  }, SHOWING_ALL_MONITORS_LABEL)), monitorsSortedByStatus.length === allConfigs.length && monitorsSortedByStatus.length > perPage && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "syntheticsOverviewGridButton",
    onClick: () => {
      window.scrollTo({
        top: 0,
        left: 0,
        behavior: 'smooth'
      });
    },
    iconType: "sortUp",
    iconSide: "right",
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 15
    }
  }, SCROLL_TO_TOP_LABEL))));
};
exports.CardsViewFooter = CardsViewFooter;
const SHOWING_ALL_MONITORS_LABEL = _i18n.i18n.translate('xpack.synthetics.overview.grid.showingAllMonitors.label', {
  defaultMessage: 'Showing all monitors'
});
const SCROLL_TO_TOP_LABEL = _i18n.i18n.translate('xpack.synthetics.overview.grid.scrollToTop.label', {
  defaultMessage: 'Back to top'
});